<?php
/**
 * About Section options
 *
 * @package Busyness
 */

// Add About section
$wp_customize->add_section( 'busyness_about_section', array(
	'title'             => esc_html__( 'About','busyness-pro' ),
	'description'       => esc_html__( 'About Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// About content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[about_section_enable]', array(
	'default'			=> 	$options['about_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[about_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_about_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );


// Event social icons number control and setting
$wp_customize->add_setting( 'busyness_theme_options[about_count]', array(
	'default'          	=> $options['about_count'],
	'sanitize_callback' => 'busyness_sanitize_number_range',
	'validate_callback' => 'busyness_validate_about_count',
) );

$wp_customize->add_control( 'busyness_theme_options[about_count]', array(
	'label'             => esc_html__( 'Number of Items', 'busyness-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 6. Please input the valid number and save. Then refresh the page to see the change.', 'busyness-pro' ),
	'section'           => 'busyness_about_section',
	'active_callback'   => 'busyness_is_about_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 6,
		'style' => 'width: 100px;'
		),
) );

// About content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[about_content_type]', array(
	'default'          	=> $options['about_content_type'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[about_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'busyness-pro' ),
	'section'           => 'busyness_about_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_about_section_enable',
	'choices'			=> array(
		'page' 		=> esc_html__( 'Page', 'busyness-pro' ),
		'post' 		=> esc_html__( 'Post', 'busyness-pro' ),
		'category' 	=> esc_html__( 'Category', 'busyness-pro' ),
	),
) );

for ( $i = 1; $i <= $options['about_count']; $i++ ) :

	// about sub title setting and control
	$wp_customize->add_setting( 'busyness_theme_options[about_sub_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'          	=> $options['about_sub_title'],
	) );

	$wp_customize->add_control( 'busyness_theme_options[about_sub_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Sub Title %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_about_section',
		'active_callback' 	=> 'busyness_is_about_section_enable',
		'type'				=> 'text',
	) );

	// about pages drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[about_content_page_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[about_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_about_section',
		'choices'			=> busyness_page_choices(),
		'active_callback'	=> 'busyness_is_about_section_content_page_enable',
	) ) );

	// about posts drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[about_content_post_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[about_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_about_section',
		'choices'			=> busyness_post_choices(),
		'active_callback'	=> 'busyness_is_about_section_content_post_enable',
	) ) );

	// about posts drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[about_display_content_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_select',
		'default'          	=> 'excerpt',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[about_display_content_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Display Content %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_about_section',
		'choices'			=> array(
			'excerpt'      => esc_html__( 'Excerpt', 'busyness-pro' ),
			'full-content' => esc_html__( 'Full Content', 'busyness-pro' ),
			'disable'      => esc_html__( 'Disable', 'busyness-pro' ),
		),
	) ) );

	// About btn title setting and control
	$wp_customize->add_setting( 'busyness_theme_options[about_btn_title_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'          	=> $options['about_btn_title']
	) );

	$wp_customize->add_control( 'busyness_theme_options[about_btn_title_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Button Label %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_about_section',
		'active_callback' 	=> 'busyness_is_about_section_enable',
		'type'				=> 'text',
	) );

	// about hr setting and control
	$wp_customize->add_setting( 'busyness_theme_options[about_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new busyness_Customize_Horizontal_Line( $wp_customize, 'busyness_theme_options[about_hr_'. $i .']',
		array(
			'section'         => 'busyness_about_section',
			'active_callback' => 'busyness_is_about_section_content_seperator_enable',
			'type'			  => 'hr'
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'busyness_theme_options[about_content_category]', array(
	'sanitize_callback' => 'busyness_sanitize_single_category',
) ) ;

$wp_customize->add_control( new busyness_Dropdown_Taxonomies_Control( $wp_customize,'busyness_theme_options[about_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'busyness-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'busyness-pro' ),
	'section'           => 'busyness_about_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'busyness_is_about_section_content_category_enable'
) ) );
