<?php
/**
 * Blog Section options
 *
 * @package Busyness
 */

// Add Blog section
$wp_customize->add_section( 'busyness_blog_section', array(
	'title'             => esc_html__( 'Blog','busyness-pro' ),
	'description'       => esc_html__( 'Blog Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Blog content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[blog_section_enable]', array(
	'default'			=> 	$options['blog_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[blog_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_blog_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// blog sub title setting and control
$wp_customize->add_setting( 'busyness_theme_options[blog_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['blog_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[blog_sub_title]', array(
	'label'           	=> esc_html__( 'Section Sub Title', 'busyness-pro' ),
	'section'        	=> 'busyness_blog_section',
	'active_callback' 	=> 'busyness_is_blog_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[blog_sub_title]', array(
		'selector'            => '#blog .section-header p',
		'settings'            => 'busyness_theme_options[blog_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_blog_sub_title_partial',
    ) );
}

// blog title setting and control
$wp_customize->add_setting( 'busyness_theme_options[blog_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['blog_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[blog_title]', array(
	'label'           	=> esc_html__( 'Section Title', 'busyness-pro' ),
	'section'        	=> 'busyness_blog_section',
	'active_callback' 	=> 'busyness_is_blog_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[blog_title]', array(
		'selector'            => '#blog .section-header h2',
		'settings'            => 'busyness_theme_options[blog_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_blog_title_partial',
    ) );
}

// blog content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[blog_column]', array(
	'default'          	=> $options['blog_column'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[blog_column]', array(
	'label'             => esc_html__( 'Column Layout', 'busyness-pro' ),
	'section'           => 'busyness_blog_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_blog_section_enable',
	'choices'			=> array(
		'col2'		=> esc_html__( 'Two Column', 'busyness-pro' ),
		'col3'		=> esc_html__( 'Three Column', 'busyness-pro' ),
		'col4'		=> esc_html__( 'Four Column', 'busyness-pro' ),

	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'busyness_theme_options[blog_count]', array(
	'default'          	=> $options['blog_count'],
	'sanitize_callback' => 'busyness_sanitize_number_range',
	'validate_callback' => 'busyness_validate_blog_count',
) );

$wp_customize->add_control( 'busyness_theme_options[blog_count]', array(
	'label'             => esc_html__( 'Number of Items', 'busyness-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'busyness-pro' ),
	'section'           => 'busyness_blog_section',
	'active_callback'   => 'busyness_is_blog_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 2,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

// Blog content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[blog_content_type]', array(
	'default'          	=> $options['blog_content_type'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[blog_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'busyness-pro' ),
	'section'           => 'busyness_blog_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_blog_section_enable',
	'choices'			=> array(
		'page' 		=> esc_html__( 'Page', 'busyness-pro' ),
		'post' 		=> esc_html__( 'Post', 'busyness-pro' ),
		'category' 	=> esc_html__( 'Category', 'busyness-pro' ),
		'recent' 	=> esc_html__( 'Recent', 'busyness-pro' ),
	),
) );


for ( $i = 1; $i <= $options['blog_count']; $i++ ) :
	// blog pages drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[blog_content_page_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[blog_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_blog_section',
		'choices'			=> busyness_page_choices(),
		'active_callback'	=> 'busyness_is_blog_section_content_page_enable',
	) ) );

	// blog posts drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[blog_content_post_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[blog_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_blog_section',
		'choices'			=> busyness_post_choices(),
		'active_callback'	=> 'busyness_is_blog_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'busyness_theme_options[blog_content_category]', array(
	'sanitize_callback' => 'busyness_sanitize_single_category',
) ) ;

$wp_customize->add_control( new busyness_Dropdown_Taxonomies_Control( $wp_customize,'busyness_theme_options[blog_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'busyness-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'busyness-pro' ),
	'section'           => 'busyness_blog_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'busyness_is_blog_section_content_category_enable'
) ) );

// Add dropdown categories setting and control.
$wp_customize->add_setting( 'busyness_theme_options[blog_category_exclude]', array(
	'sanitize_callback' => 'busyness_sanitize_category_list',
) ) ;

$wp_customize->add_control( new busyness_Dropdown_Category_Control( $wp_customize,'busyness_theme_options[blog_category_exclude]', array(
	'label'             => esc_html__( 'Select Excluding Categories', 'busyness-pro' ),
	'description'      	=> esc_html__( 'Note: Select categories to exclude. Press Shift key select multilple categories.', 'busyness-pro' ),
	'section'           => 'busyness_blog_section',
	'type'              => 'dropdown-categories',
	'active_callback'	=> 'busyness_is_blog_section_content_recent_enable'
) ) );
