<?php
/**
 * Client Section options
 *
 * @package Busyness
 */

// Add Client section
$wp_customize->add_section( 'busyness_client_section', array(
	'title'             => esc_html__( 'Client Section','busyness-pro' ),
	'description'       => esc_html__( 'Client Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Client content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[client_section_enable]', array(
	'default'			=> 	$options['client_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[client_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_client_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// Event social icons number control and setting
$wp_customize->add_setting( 'busyness_theme_options[client_count]', array(
	'default'          	=> $options['client_count'],
	'sanitize_callback' => 'busyness_sanitize_number_range',
	'validate_callback' => 'busyness_validate_client_count',
) );

$wp_customize->add_control( 'busyness_theme_options[client_count]', array(
	'label'             => esc_html__( 'Number of Items', 'busyness-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'busyness-pro' ),
	'section'           => 'busyness_client_section',
	'active_callback'   => 'busyness_is_client_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 2,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

for ($i=1; $i <= $options['client_count'] ; $i++) {

	$wp_customize->add_setting( 'busyness_theme_options[client_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new busyness_Customize_Horizontal_Line( $wp_customize, 'busyness_theme_options[client_hr_'. $i .']',
		array(
			'section'         => 'busyness_client_section',
			'active_callback' => 'busyness_is_client_section_enable',
			'type'			  => 'hr'
	) ) );

	$wp_customize->add_setting( 'busyness_theme_options[client_image_'. $i .']', array(
		'sanitize_callback' => 'busyness_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'busyness_theme_options[client_image_'. $i .']',
			array(
			'label'       		=> sprintf( esc_html__( 'Client Logo %d', 'busyness-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'busyness-pro' ), 1920, 620 ),
			'section'     		=> 'busyness_client_section',
			'active_callback'	=> 'busyness_is_client_section_enable',
	) ) );

	$wp_customize->add_setting( 'busyness_theme_options[client_link_'. $i .']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'busyness_theme_options[client_link_'. $i .']', array(
		'label'           	=> sprintf( esc_html__( 'Client URL %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_client_section',
		'active_callback' 	=> 'busyness_is_client_section_enable',
		'type'				=> 'url',
	) );

}