<?php
/**
 * Counter Section options
 *
 * @package Busyness
 */

// Add Counter section
$wp_customize->add_section( 'busyness_counter_section', array(
	'title'             => esc_html__( 'Counters','busyness-pro' ),
	'description'       => esc_html__( 'Counters Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Counter content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[counter_section_enable]', array(
	'default'			=> 	$options['counter_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[counter_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_counter_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// counter image setting and control.
$wp_customize->add_setting( 'busyness_theme_options[counter_image]', array(
	'sanitize_callback' => 'busyness_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'busyness_theme_options[counter_image]',
		array(
		'label'       		=> sprintf( esc_html__( 'Background Image', 'busyness-pro' ), $i ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'busyness-pro' ), 1920, 620 ),
		'section'     		=> 'busyness_counter_section',
		'active_callback'	=> 'busyness_is_counter_section_enable',
) ) );

// counter content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[counter_column]', array(
	'default'          	=> $options['counter_column'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[counter_column]', array(
	'label'             => esc_html__( 'Column Layout', 'busyness-pro' ),
	'section'           => 'busyness_counter_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_counter_section_enable',
	'choices'			=> array(
		'col2'		=> esc_html__( 'Two Column', 'busyness-pro' ),
		'col3'		=> esc_html__( 'Three Column', 'busyness-pro' ),
		'col4'		=> esc_html__( 'Four Column', 'busyness-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'busyness_theme_options[counter_count]', array(
	'default'          	=> $options['counter_count'],
	'sanitize_callback' => 'busyness_sanitize_number_range',
	'validate_callback' => 'busyness_validate_counter_count',
) );

$wp_customize->add_control( 'busyness_theme_options[counter_count]', array(
	'label'             => esc_html__( 'Number of Items', 'busyness-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'busyness-pro' ),
	'section'           => 'busyness_counter_section',
	'active_callback'   => 'busyness_is_counter_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['counter_count']; $i++ ) :

	// counter note control and setting
	$wp_customize->add_setting( 'busyness_theme_options[counter_content_icon_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new busyness_Icon_Picker( $wp_customize, 'busyness_theme_options[counter_content_icon_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Icon %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_counter_section',
		'active_callback'	=> 'busyness_is_counter_section_enable',
	) ) );

	// counter title setting and control
	$wp_customize->add_setting( 'busyness_theme_options[counter_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'busyness_theme_options[counter_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Counter Title %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_counter_section',
		'active_callback' 	=> 'busyness_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter title setting and control
	$wp_customize->add_setting( 'busyness_theme_options[counter_number_' . $i . ']', array(
		'sanitize_callback' => 'absint',
	) );

	$wp_customize->add_control( 'busyness_theme_options[counter_number_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Counter Number %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_counter_section',
		'active_callback' 	=> 'busyness_is_counter_section_enable',
		'type'				=> 'text',
	) );

	// counter hr setting and control
	$wp_customize->add_setting( 'busyness_theme_options[counter_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new busyness_Customize_Horizontal_Line( $wp_customize, 'busyness_theme_options[counter_hr_'. $i .']',
		array(
			'section'         => 'busyness_counter_section',
			'active_callback' => 'busyness_is_counter_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;



