<?php
/**
 * Call to Action Section options
 *
 * @package Busyness
 */

// Add Call to Action section
$wp_customize->add_section( 'busyness_cta_section', array(
	'title'             => esc_html__( 'Call to Action','busyness-pro' ),
	'description'       => esc_html__( 'Call to Action Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Call to Action content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[cta_section_enable]', array(
	'default'			=> 	$options['cta_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[cta_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_cta_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// Call to Action content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[cta_content_type]', array(
	'default'          	=> $options['cta_content_type'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[cta_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'busyness-pro' ),
	'section'           => 'busyness_cta_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_cta_section_enable',
	'choices'			=> array(
		'page' 		=> esc_html__( 'Page', 'busyness-pro' ),
		'post' 		=> esc_html__( 'Post', 'busyness-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'busyness-pro' ),
	),
) );


// cta pages drop down chooser control and setting
$wp_customize->add_setting( 'busyness_theme_options[cta_content_page]', array(
	'sanitize_callback' => 'busyness_sanitize_page',
) );

$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[cta_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'busyness-pro' ),
	'section'           => 'busyness_cta_section',
	'choices'			=> busyness_page_choices(),
	'active_callback'	=> 'busyness_is_cta_section_content_page_enable',
) ) );

// cta posts drop down chooser control and setting
$wp_customize->add_setting( 'busyness_theme_options[cta_content_post]', array(
	'sanitize_callback' => 'busyness_sanitize_page',
) );

$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[cta_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'busyness-pro' ),
	'section'           => 'busyness_cta_section',
	'choices'			=> busyness_post_choices(),
	'active_callback'	=> 'busyness_is_cta_section_content_post_enable',
) ) );

$wp_customize->add_setting( 'busyness_theme_options[cta_image]', array(
	'sanitize_callback' => 'busyness_sanitize_image'
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'busyness_theme_options[cta_image]',
		array(
		'label'       		=> esc_html__( 'Background Image ', 'busyness-pro' ),
		'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'busyness-pro' ), 1920, 620 ),
		'section'     		=> 'busyness_cta_section',
		'active_callback'	=> 'busyness_is_cta_section_content_custom_enable',
) ) );

// cta title setting and control
$wp_customize->add_setting( 'busyness_theme_options[cta_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['cta_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[cta_title]', array(
	'label'           	=> esc_html__( 'Title', 'busyness-pro' ),
	'section'        	=> 'busyness_cta_section',
	'active_callback' 	=> 'busyness_is_cta_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[cta_title]', array(
		'selector'            => '#call-to-action .wrapper .section-header h2.section-title',
		'settings'            => 'busyness_theme_options[cta_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_cta_title_partial',
    ) );
}

// cta description setting and control
$wp_customize->add_setting( 'busyness_theme_options[cta_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['cta_description'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[cta_description]', array(
	'label'           	=> esc_html__( 'Description', 'busyness-pro' ),
	'section'        	=> 'busyness_cta_section',
	'active_callback' 	=> 'busyness_is_cta_section_content_custom_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[cta_description]', array(
		'selector'            => '#call-to-action .wrapper .section-content p',
		'settings'            => 'busyness_theme_options[cta_description]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_cta_description_partial',
    ) );
}

// cta btn title setting and control
$wp_customize->add_setting( 'busyness_theme_options[cta_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['cta_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[cta_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'busyness-pro' ),
	'section'        	=> 'busyness_cta_section',
	'active_callback' 	=> 'busyness_is_cta_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[cta_btn_title]', array(
		'selector'            => '#call-to-action .wrapper a.btn',
		'settings'            => 'busyness_theme_options[cta_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_cta_btn_title_partial',
    ) );
}

// cta btn link setting and control
$wp_customize->add_setting( 'busyness_theme_options[cta_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'busyness_theme_options[cta_btn_link]', array(
	'label'           	=> esc_html__( 'Button URL', 'busyness-pro' ),
	'section'        	=> 'busyness_cta_section',
	'active_callback' 	=> 'busyness_is_cta_section_content_custom_enable',
	'type'				=> 'url',
) );