<?php
/**
 * My Portfolio Section options
 *
 * @package Busyness
 */

// Add Featured section
$wp_customize->add_section( 'busyness_portfolio_section', array(
	'title'             => esc_html__( 'Portfolio','busyness-pro' ),
	'description'       => esc_html__( 'My Portfolio Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Featured content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[portfolio_section_enable]', array(
	'default'			=> 	$options['portfolio_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[portfolio_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_portfolio_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// Featured sub title setting and control
$wp_customize->add_setting( 'busyness_theme_options[portfolio_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['portfolio_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[portfolio_sub_title]', array(
	'label'           	=> esc_html__( 'Section Sub Title', 'busyness-pro' ),
	'section'        	=> 'busyness_portfolio_section',
	'active_callback' 	=> 'busyness_is_portfolio_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[portfolio_sub_title]', array(
		'selector'            => '#portfolio .section-header p',
		'settings'            => 'busyness_theme_options[portfolio_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_portfolio_sub_title_partial',
    ) );
}

// Featured title setting and control
$wp_customize->add_setting( 'busyness_theme_options[portfolio_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['portfolio_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[portfolio_title]', array(
	'label'           	=> esc_html__( 'Section Title', 'busyness-pro' ),
	'section'        	=> 'busyness_portfolio_section',
	'active_callback' 	=> 'busyness_is_portfolio_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[portfolio_title]', array(
		'selector'            => '#portfolio .section-header h2',
		'settings'            => 'busyness_theme_options[portfolio_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_portfolio_title_partial',
    ) );
}

// Portfolio content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[portfolio_autoplay_enable]', array(
	'default'			=> 	$options['portfolio_autoplay_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[portfolio_autoplay_enable]', array(
	'label'             => esc_html__( 'Enable Autoplay ', 'busyness-pro' ),
	'section'           => 'busyness_portfolio_section',
	'active_callback'   => 'busyness_is_portfolio_section_enable',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// Event social icons number control and setting
$wp_customize->add_setting( 'busyness_theme_options[portfolio_count]', array(
	'default'          	=> $options['portfolio_count'],
	'sanitize_callback' => 'busyness_sanitize_number_range',
	'validate_callback' => 'busyness_validate_portfolio_count',
) );

$wp_customize->add_control( 'busyness_theme_options[portfolio_count]', array(
	'label'             => esc_html__( 'Number of Items', 'busyness-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'busyness-pro' ),
	'section'           => 'busyness_portfolio_section',
	'active_callback'   => 'busyness_is_portfolio_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

// portfolio posts drop down chooser control and setting
$wp_customize->add_setting( 'busyness_theme_options[portfolio_categories]', array(
	'sanitize_callback' => 'busyness_sanitize_category_list',
) );

$wp_customize->add_control( new busyness_Dropdown_Multiple_Chooser( $wp_customize, 'busyness_theme_options[portfolio_categories]', array(
	'label'             => esc_html__( 'Select Multiple Categories', 'busyness-pro' ),
	'type'           	=> 'dropdown_multiple_chooser',
	'choices'			=> 	busyness_category_choices(),
	'section'           => 'busyness_portfolio_section',
	'active_callback'	=> 'busyness_is_portfolio_section_enable',
) ) );

// Button Label setting and control
$wp_customize->add_setting( 'busyness_theme_options[portfolio_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['portfolio_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[portfolio_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'busyness-pro' ),
	'section'        	=> 'busyness_portfolio_section',
	'active_callback' 	=> 'busyness_is_portfolio_section_enable',
	'type'				=> 'text',
) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[portfolio_btn_title]', array(
		'selector'            => '#portfolio .more-link a',
		'settings'            => 'busyness_theme_options[portfolio_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_portfolio_btn_title_partial',
    ) );
}

// portfolio bt link setting and control
$wp_customize->add_setting( 'busyness_theme_options[portfolio_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'busyness_theme_options[portfolio_btn_url]', array(
	'label'           	=> sprintf( esc_html__( 'Button URL', 'busyness-pro' ) ),
	'section'        	=> 'busyness_portfolio_section',
	'active_callback' 	=> 'busyness_is_portfolio_section_enable',
	'type'				=> 'url',
) );