<?php
/**
 * My pricing Section options
 *
 * @package Busyness
 */

// Add Featured section
$wp_customize->add_section( 'busyness_pricing_section', array(
	'title'             => esc_html__( 'Pricing','busyness-pro' ),
	'description'       => esc_html__( 'My pricing Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Featured content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[pricing_section_enable]', array(
	'default'			=> 	$options['pricing_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[pricing_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_pricing_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// Featured sub title setting and control
$wp_customize->add_setting( 'busyness_theme_options[pricing_sub_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['pricing_sub_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[pricing_sub_title]', array(
	'label'           	=> esc_html__( 'Section Sub Title', 'busyness-pro' ),
	'section'        	=> 'busyness_pricing_section',
	'active_callback' 	=> 'busyness_is_pricing_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[pricing_sub_title]', array(
		'selector'            => '#pricing .section-header p',
		'settings'            => 'busyness_theme_options[pricing_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_pricing_sub_title_partial',
    ) );
}

// Featured title setting and control
$wp_customize->add_setting( 'busyness_theme_options[pricing_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['pricing_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[pricing_title]', array(
	'label'           	=> esc_html__( 'Section Title', 'busyness-pro' ),
	'section'        	=> 'busyness_pricing_section',
	'active_callback' 	=> 'busyness_is_pricing_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[pricing_title]', array(
		'selector'            => '#pricing .section-header h2',
		'settings'            => 'busyness_theme_options[pricing_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_pricing_title_partial',
    ) );
}


for ($i=1; $i <= 3 ; $i++) {

	//hr setting and control
	$wp_customize->add_setting( 'busyness_theme_options[team_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new busyness_Customize_Horizontal_Line( $wp_customize, 'busyness_theme_options[team_hr_'. $i .']',
		array(
			'section'         => 'busyness_pricing_section',
			'active_callback' => 'busyness_is_pricing_section_enable',
			'type'			  => 'hr'
	) ) );

	$wp_customize->add_setting( 'busyness_theme_options[pricing_package_title_' . $i . ']', array(
	'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'busyness_theme_options[pricing_package_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Package Title %d', 'busyness-pro' ), $i),
		'section'        	=> 'busyness_pricing_section',
		'active_callback' 	=> 'busyness_is_pricing_section_enable',
		'type'				=> 'text',
	) );

	$wp_customize->add_setting( 'busyness_theme_options[pricing_package_price_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'busyness_theme_options[pricing_package_price_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Package Price %d', 'busyness-pro' ), $i),
		'section'        	=> 'busyness_pricing_section',
		'active_callback' 	=> 'busyness_is_pricing_section_enable',
		'type'				=> 'text',
	) );

	$wp_customize->add_setting( 'busyness_theme_options[pricing_package_period_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'busyness_theme_options[pricing_package_period_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Package Period %d', 'busyness-pro' ), $i),
		'section'        	=> 'busyness_pricing_section',
		'active_callback' 	=> 'busyness_is_pricing_section_enable',
		'type'				=> 'text',
	) );

	$wp_customize->add_setting( 'busyness_theme_options[pricing_package_content_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'busyness_theme_options[pricing_package_content_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Package Description %d', 'busyness-pro' ), $i),
		'section'        	=> 'busyness_pricing_section',
		'active_callback' 	=> 'busyness_is_pricing_section_enable',
		'type'				=> 'textarea',
	) );

	// Button Label setting and control
	$wp_customize->add_setting( 'busyness_theme_options[pricing_btn_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'busyness_theme_options[pricing_btn_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Button Label %d', 'busyness-pro' ), $i),
		'section'        	=> 'busyness_pricing_section',
		'active_callback' 	=> 'busyness_is_pricing_section_enable',
		'type'				=> 'text',
	) );


	// pricing bt link setting and control
	$wp_customize->add_setting( 'busyness_theme_options[pricing_btn_url_' . $i . ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'busyness_theme_options[pricing_btn_url_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Button URL %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_pricing_section',
		'active_callback' 	=> 'busyness_is_pricing_section_enable',
		'type'				=> 'url',
	) );


}

