<?php
/**
 * promotion Section options
 *
 * @package Busyness
 */

// Add promotion section
$wp_customize->add_section( 'busyness_promotion_section', array(
	'title'             => esc_html__( 'Promotion','busyness-pro' ),
	'description'       => esc_html__( 'Promotion Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// promotion content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[promotion_section_enable]', array(
	'default'			=> 	$options['promotion_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[promotion_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_promotion_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// promotion content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[promotion_content_type]', array(
	'default'          	=> $options['promotion_content_type'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[promotion_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'busyness-pro' ),
	'section'           => 'busyness_promotion_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_promotion_section_enable',
	'choices'			=> array(
		'page' 		=> esc_html__( 'Page', 'busyness-pro' ),
		'post' 		=> esc_html__( 'Post', 'busyness-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'busyness-pro' ),
	),
) );


// promotion pages drop down chooser control and setting
$wp_customize->add_setting( 'busyness_theme_options[promotion_content_page]', array(
	'sanitize_callback' => 'busyness_sanitize_page',
) );

$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[promotion_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'busyness-pro' ),
	'section'           => 'busyness_promotion_section',
	'choices'			=> busyness_page_choices(),
	'active_callback'	=> 'busyness_is_promotion_section_content_page_enable',
) ) );

// promotion posts drop down chooser control and setting
$wp_customize->add_setting( 'busyness_theme_options[promotion_content_post]', array(
	'sanitize_callback' => 'busyness_sanitize_page',
) );

$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[promotion_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'busyness-pro' ),
	'section'           => 'busyness_promotion_section',
	'choices'			=> busyness_post_choices(),
	'active_callback'	=> 'busyness_is_promotion_section_content_post_enable',
) ) );


// promotion title setting and control
$wp_customize->add_setting( 'busyness_theme_options[promotion_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['promotion_title'],

) );

$wp_customize->add_control( 'busyness_theme_options[promotion_title]', array(
	'label'           	=> esc_html__( 'Title', 'busyness-pro' ),
	'section'        	=> 'busyness_promotion_section',
	'active_callback' 	=> 'busyness_is_promotion_section_content_custom_enable',
	'type'				=> 'text',
) );


// promotion description setting and control
$wp_customize->add_setting( 'busyness_theme_options[promotion_description]', array(
	'sanitize_callback' => 'wp_kses_post',
	'default'			=> $options['promotion_description'],

) );

$wp_customize->add_control( 'busyness_theme_options[promotion_description]', array(
	'label'           	=> esc_html__( 'Description', 'busyness-pro' ),
	'section'        	=> 'busyness_promotion_section',
	'active_callback' 	=> 'busyness_is_promotion_section_content_custom_enable',
	'type'				=> 'textarea',
) );


// promotion btn title setting and control
$wp_customize->add_setting( 'busyness_theme_options[promotion_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['promotion_btn_title'],
) );

$wp_customize->add_control( 'busyness_theme_options[promotion_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'busyness-pro' ),
	'section'        	=> 'busyness_promotion_section',
	'active_callback' 	=> 'busyness_is_promotion_section_enable',
	'type'				=> 'text',
) );

// promotion btn link setting and control
$wp_customize->add_setting( 'busyness_theme_options[promotion_btn_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'busyness_theme_options[promotion_btn_link]', array(
	'label'           	=> esc_html__( 'Button URL', 'busyness-pro' ),
	'section'        	=> 'busyness_promotion_section',
	'active_callback' 	=> 'busyness_is_promotion_section_content_custom_enable',
	'type'				=> 'url',
) );