<?php
/**
 * Service Section options
 *
 * @package Busyness
 */

// Add Service section
$wp_customize->add_section( 'busyness_service_section', array(
	'title'             => esc_html__( 'Services','busyness-pro' ),
	'description'       => esc_html__( 'Services Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Service content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[service_section_enable]', array(
	'default'			=> 	$options['service_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[service_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_service_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// service sub title setting and control
$wp_customize->add_setting( 'busyness_theme_options[service_sub_title]', array(
	'default'			=> 	$options['service_sub_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[service_sub_title]', array(
	'label'           	=> sprintf( esc_html__( 'Section Sub Title', 'busyness-pro' ) ),
	'section'        	=> 'busyness_service_section',
	'active_callback' 	=> 'busyness_is_service_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[service_sub_title]', array(
		'selector'            => '#featured-services .section-header p',
		'settings'            => 'busyness_theme_options[service_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_service_sub_title_partial',
    ) );
}

// Service title setting and control
$wp_customize->add_setting( 'busyness_theme_options[service_title]', array(
	'default'			=> 	$options['service_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[service_title]', array(
	'label'           	=> sprintf( esc_html__( 'Section Title', 'busyness-pro' ) ),
	'section'        	=> 'busyness_service_section',
	'active_callback' 	=> 'busyness_is_service_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[service_title]', array(
		'selector'            => '#featured-services .section-header h2',
		'settings'            => 'busyness_theme_options[service_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_service_title_partial',
    ) );
}

// service content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[service_column]', array(
	'default'          	=> $options['service_column'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[service_column]', array(
	'label'             => esc_html__( 'Column Layout', 'busyness-pro' ),
	'section'           => 'busyness_service_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_service_section_enable',
	'choices'			=> array(
		'col2'		=> esc_html__( 'Two Column', 'busyness-pro' ),
		'col3'		=> esc_html__( 'Three Column', 'busyness-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'busyness_theme_options[service_count]', array(
	'default'          	=> $options['service_count'],
	'sanitize_callback' => 'busyness_sanitize_number_range',
	'validate_callback' => 'busyness_validate_service_count',
) );

$wp_customize->add_control( 'busyness_theme_options[service_count]', array(
	'label'             => esc_html__( 'Number of Items', 'busyness-pro' ),
	'description'       => esc_html__( 'Note: Min 2 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'busyness-pro' ),
	'section'           => 'busyness_service_section',
	'active_callback'   => 'busyness_is_service_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 2,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

// Service content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[service_content_type]', array(
	'default'          	=> $options['service_content_type'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[service_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'busyness-pro' ),
	'section'           => 'busyness_service_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_service_section_enable',
	'choices'			=> array(
		'page' 		=> esc_html__( 'Page', 'busyness-pro' ),
		'post' 		=> esc_html__( 'Post', 'busyness-pro' ),
		'category' 	=> esc_html__( 'Category', 'busyness-pro' ),
	),
) );

for ( $i = 1; $i <= $options['service_count']; $i++ ) :

	$wp_customize->add_setting( 'busyness_theme_options[service_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new busyness_Customize_Horizontal_Line( $wp_customize, 'busyness_theme_options[service_hr_'. $i .']',
		array(
			'section'         => 'busyness_service_section',
			'active_callback' => 'busyness_is_service_section_enable',
			'type'			  => 'hr'
	) ) );


	// service note control and setting
	$wp_customize->add_setting( 'busyness_theme_options[service_content_icon_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( new busyness_Icon_Picker( $wp_customize, 'busyness_theme_options[service_content_icon_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Icon %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_service_section',
		'active_callback'	=> 'busyness_is_service_section_enable',
	) ) );

	// service pages drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[service_content_page_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[service_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_service_section',
		'choices'			=> busyness_page_choices(),
		'active_callback'	=> 'busyness_is_service_section_content_page_enable',
	) ) );

	// service posts drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[service_content_post_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[service_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_service_section',
		'choices'			=> busyness_post_choices(),
		'active_callback'	=> 'busyness_is_service_section_content_post_enable',
	) ) );

	// service hr setting and control
	$wp_customize->add_setting( 'busyness_theme_options[service_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new busyness_Customize_Horizontal_Line( $wp_customize, 'busyness_theme_options[service_hr_'. $i .']',
		array(
			'section'         => 'busyness_service_section',
			'active_callback' => 'busyness_is_service_section_content_seperator_enable',
			'type'			  => 'hr'
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'busyness_theme_options[service_content_category]', array(
	'sanitize_callback' => 'busyness_sanitize_single_category',
) ) ;

$wp_customize->add_control( new busyness_Dropdown_Taxonomies_Control( $wp_customize,'busyness_theme_options[service_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'busyness-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'busyness-pro' ),
	'section'           => 'busyness_service_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'busyness_is_service_section_content_category_enable'
) ) );

// About btn title setting and control
$wp_customize->add_setting( 'busyness_theme_options[service_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['service_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[service_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'busyness-pro' ),
	'section'        	=> 'busyness_service_section',
	'active_callback' 	=> 'busyness_is_service_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[service_btn_title]', array(
		'selector'            => '#featured-services .more-link a',
		'settings'            => 'busyness_theme_options[service_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_service_btn_title_partial',
    ) );
}

// service bt link setting and control
$wp_customize->add_setting( 'busyness_theme_options[service_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'busyness_theme_options[service_link]', array(
	'label'           	=> sprintf( esc_html__( 'Button URL', 'busyness-pro' ) ),
	'section'        	=> 'busyness_service_section',
	'active_callback' 	=> 'busyness_is_service_section_enable',
	'type'				=> 'url',
) );
