<?php
/**
 * Slider Section options
 *
 * @package Busyness
 */

// Add Slider section
$wp_customize->add_section( 'busyness_slider_section', array(
	'title'             => esc_html__( 'Main Slider','busyness-pro' ),
	'description'       => esc_html__( 'Slider Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Slider content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[slider_section_enable]', array(
	'default'			=> 	$options['slider_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[slider_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_slider_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// Slider number control and setting
$wp_customize->add_setting( 'busyness_theme_options[slider_count]', array(
	'default'          	=> $options['slider_count'],
	'sanitize_callback' => 'busyness_sanitize_number_range',
	'validate_callback' => 'busyness_validate_slider_count',
) );

$wp_customize->add_control( 'busyness_theme_options[slider_count]', array(
	'label'             => esc_html__( 'Number of Items', 'busyness-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then refresh the page to see the change.', 'busyness-pro' ),
	'section'           => 'busyness_slider_section',
	'active_callback'   => 'busyness_is_slider_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );

// Slider autoplay enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[slider_autoplay_enable]', array(
	'default'			=> 	$options['slider_autoplay_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[slider_autoplay_enable]', array(
	'label'             => esc_html__( 'Enable Autoplay', 'busyness-pro' ),
	'section'           => 'busyness_slider_section',
	'active_callback'   => 'busyness_is_slider_section_enable',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// Slider Button label setting and control
$wp_customize->add_setting( 'busyness_theme_options[slider_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['slider_btn_label'],
	'transport'			=> 'postMessage'
) );

$wp_customize->add_control( 'busyness_theme_options[slider_btn_label]', array(
	'label'           	=> esc_html__( 'Button Label', 'busyness-pro' ),
	'section'        	=> 'busyness_slider_section',
	'active_callback' 	=> 'busyness_is_slider_section_enable',
	'type'				=> 'text',
) );


if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[slider_btn_label]', array(
		'selector'            => '#featured-slider .read-more .slider-btn',
		'settings'            => 'busyness_theme_options[slider_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'business_pro_slider_btn_label_partial',
    ) );
}

// Slider content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[slider_content_type]', array(
	'default'          	=> $options['slider_content_type'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[slider_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'busyness-pro' ),
	'section'           => 'busyness_slider_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_slider_section_enable',
	'choices'			=> array(
		'page' 		=> esc_html__( 'Page', 'busyness-pro' ),
		'post' 		=> esc_html__( 'Post', 'busyness-pro' ),
		'category' 	=> esc_html__( 'Category', 'busyness-pro' ),
	),
) );

for ( $i = 1; $i <= $options['slider_count']; $i++ ) :
	// slider pages drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[slider_content_page_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[slider_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_slider_section',
		'choices'			=> busyness_page_choices(),
		'active_callback'	=> 'busyness_is_slider_section_content_page_enable',
	) ) );

	// slider posts drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[slider_content_post_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[slider_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_slider_section',
		'choices'			=> busyness_post_choices(),
		'active_callback'	=> 'busyness_is_slider_section_content_post_enable',
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'busyness_theme_options[slider_content_category]', array(
	'sanitize_callback' => 'busyness_sanitize_single_category',
) ) ;

$wp_customize->add_control( new busyness_Dropdown_Taxonomies_Control( $wp_customize,'busyness_theme_options[slider_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'busyness-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'busyness-pro' ),
	'section'           => 'busyness_slider_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'busyness_is_slider_section_content_category_enable'
) ) );

// Slider Secondary button label setting and control
$wp_customize->add_setting( 'busyness_theme_options[slider_alt_btn_label]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['slider_alt_btn_label'],
	'transport'			=> 'postMessage'
) );

$wp_customize->add_control( 'busyness_theme_options[slider_alt_btn_label]', array(
	'label'           	=> esc_html__( 'Secondary Button Label', 'busyness-pro' ),
	'section'        	=> 'busyness_slider_section',
	'active_callback' 	=> 'busyness_is_slider_section_enable',
	'type'				=> 'text',
) );

if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[slider_alt_btn_label]', array(
		'selector'            => '#featured-slider .read-more .customize-unpreviewable',
		'settings'            => 'busyness_theme_options[slider_alt_btn_label]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'business_pro_slider_alt_btn_label_partial',
    ) );
}

// Slider Secondary Button URL setting and control
$wp_customize->add_setting( 'busyness_theme_options[slider_alt_btn_url]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'busyness_theme_options[slider_alt_btn_url]', array(
	'label'           	=> esc_html__( 'Secondary Button URL', 'busyness-pro' ),
	'section'        	=> 'busyness_slider_section',
	'active_callback' 	=> 'busyness_is_slider_section_enable',
	'type'				=> 'url',
) );