<?php
/**
 * Team Section options
 *
 * @package Busyness
 */

// Add Team section
$wp_customize->add_section( 'busyness_team_section', array(
	'title'             => esc_html__( 'Teams','busyness-pro' ),
	'description'       => esc_html__( 'Teams Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Team content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[team_section_enable]', array(
	'default'			=> 	$options['team_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[team_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_team_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// team title setting and control
$wp_customize->add_setting( 'busyness_theme_options[team_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['team_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[team_title]', array(
	'label'           	=> esc_html__( 'Section Title', 'busyness-pro' ),
	'section'        	=> 'busyness_team_section',
	'active_callback' 	=> 'busyness_is_team_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[team_title]', array(
		'selector'            => '#our-team .section-header h2',
		'settings'            => 'busyness_theme_options[team_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_team_title_partial',
    ) );
}

// team sub title
$wp_customize->add_setting( 'busyness_theme_options[team_sub_title]', array(
	'default'          	=> $options['team_sub_title'],
	'sanitize_callback' => 'sanitize_textarea_field',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[team_sub_title]', array(
	'label'             => esc_html__( 'Section Sub Title', 'busyness-pro' ),
	'section'           => 'busyness_team_section',
	'active_callback'	=> 'busyness_is_team_section_enable',
	'type'				=> 'textarea',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[team_sub_title]', array(
		'selector'            => '#our-team .section-header p',
		'settings'            => 'busyness_theme_options[team_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_team_sub_title_partial',
    ) );
}

// Team content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[team_content_type]', array(
	'default'          	=> $options['team_content_type'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[team_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'busyness-pro' ),
	'section'           => 'busyness_team_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_team_section_enable',
	'choices'			=> array(
		'page' 		=> esc_html__( 'Page', 'busyness-pro' ),
		'post' 		=> esc_html__( 'Post', 'busyness-pro' ),
		'category' 	=> esc_html__( 'Category', 'busyness-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'busyness-pro' ),
	),
) );

// Event social icons number control and setting
$wp_customize->add_setting( 'busyness_theme_options[team_count]', array(
	'default'          	=> $options['team_count'],
	'sanitize_callback' => 'busyness_sanitize_number_range',
	'validate_callback' => 'busyness_validate_team_count',
) );

$wp_customize->add_control( 'busyness_theme_options[team_count]', array(
	'label'             => esc_html__( 'Number of Items', 'busyness-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 12. Please input the valid number and save. Then refresh the page to see the change.', 'busyness-pro' ),
	'section'           => 'busyness_team_section',
	'active_callback'   => 'busyness_is_team_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 12,
		'style' => 'width: 100px;'
		),
) );

for ( $i = 1; $i <= $options['team_count']; $i++ ) :

	// team pages drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[team_content_page_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[team_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_team_section',
		'choices'			=> busyness_page_choices(),
		'active_callback'	=> 'busyness_is_team_section_content_page_enable',
	) ) );

	// team posts drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[team_content_post_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[team_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_team_section',
		'choices'			=> busyness_post_choices(),
		'active_callback'	=> 'busyness_is_team_section_content_post_enable',
	) ) );


	// team image
	$wp_customize->add_setting( 'busyness_theme_options[team_content_custom_image_' . $i . ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'busyness_theme_options[team_content_custom_image_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Image %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_team_section',
		'active_callback'   => 'busyness_is_team_section_content_custom_enable',
	) ) );

	// team custom title
	$wp_customize->add_setting( 'busyness_theme_options[team_content_custom_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'busyness_theme_options[team_content_custom_title_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Title %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_team_section',
		'active_callback'	=> 'busyness_is_team_section_content_custom_enable',
	) );

	// team bt link setting and control
	$wp_customize->add_setting( 'busyness_theme_options[custom_team_url_'.$i.']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'busyness_theme_options[custom_team_url_'.$i.']', array(
		'label'           	=> sprintf( esc_html__( 'Custom team Url', 'busyness-pro' ) ),
		'section'        	=> 'busyness_team_section',
		'active_callback' 	=> 'busyness_is_team_section_content_custom_enable',
		'type'				=> 'url',
	) );

	// team custom content
	$wp_customize->add_setting( 'busyness_theme_options[team_content_custom_position_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'busyness_theme_options[team_content_custom_position_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Position %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_team_section',
		'active_callback'	=> 'busyness_is_team_section_enable',
	) );

	// team social
	$wp_customize->add_setting( 'busyness_theme_options[team_social_' . $i. ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( new busyness_Multi_Input_Custom_Control( $wp_customize, 'busyness_theme_options[team_social_' . $i. ']', array(
		'label'             => esc_html__( 'Social Media Links', 'busyness-pro' ),
		'button_text'       => esc_html__( 'Add Links', 'busyness-pro' ),
		'section'           => 'busyness_team_section',
		'active_callback' 	=> 'busyness_is_team_section_enable',
	) ) );

	//hr setting and control
	$wp_customize->add_setting( 'busyness_theme_options[team_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new busyness_Customize_Horizontal_Line( $wp_customize, 'busyness_theme_options[team_hr_'. $i .']',
		array(
			'section'         => 'busyness_team_section',
			'active_callback' => 'busyness_is_team_section_enable',
			'type'			  => 'hr'
	) ) );
endfor;

// Add dropdown category setting and control.
$wp_customize->add_setting(  'busyness_theme_options[team_content_category]', array(
	'sanitize_callback' => 'busyness_sanitize_single_category',
) ) ;

$wp_customize->add_control( new busyness_Dropdown_Taxonomies_Control( $wp_customize,'busyness_theme_options[team_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'busyness-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'busyness-pro' ),
	'section'           => 'busyness_team_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'busyness_is_team_section_content_category_enable'
) ) );

// About btn title setting and control
$wp_customize->add_setting( 'busyness_theme_options[team_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['team_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[team_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'busyness-pro' ),
	'section'        	=> 'busyness_team_section',
	'active_callback' 	=> 'busyness_is_team_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[team_btn_title]', array(
		'selector'            => '#our-team .more-link a',
		'settings'            => 'busyness_theme_options[team_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_team_btn_title_partial',
    ) );
}

// team bt link setting and control
$wp_customize->add_setting( 'busyness_theme_options[team_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'busyness_theme_options[team_link]', array(
	'label'           	=> sprintf( esc_html__( 'Button URL', 'busyness-pro' ) ),
	'section'        	=> 'busyness_team_section',
	'active_callback' 	=> 'busyness_is_team_section_enable',
	'type'				=> 'url',
) );
