<?php
/**
 * Testimonial Section options
 *
 * @package Busyness
 */

// Add Testimonial section
$wp_customize->add_section( 'busyness_testimonial_section', array(
	'title'             => esc_html__( 'Testimonial','busyness-pro' ),
	'description'       => esc_html__( 'Testimonial Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Testimonial content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[testimonial_section_enable]', array(
	'default'			=> 	$options['testimonial_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[testimonial_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_testimonial_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// testimonial sub title setting and control
$wp_customize->add_setting( 'busyness_theme_options[testimonial_sub_title]', array(
	'default'			=> 	$options['testimonial_sub_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[testimonial_sub_title]', array(
	'label'           	=> sprintf( esc_html__( 'Section Sub Title', 'busyness-pro' ) ),
	'section'        	=> 'busyness_testimonial_section',
	'active_callback' 	=> 'busyness_is_testimonial_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[testimonial_sub_title]', array(
		'selector'            => '#testimonial-slider-section .section-header p',
		'settings'            => 'busyness_theme_options[testimonial_sub_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_testimonial_sub_title_partial',
    ) );
}

// Service title setting and control
$wp_customize->add_setting( 'busyness_theme_options[testimonial_title]', array(
	'default'			=> 	$options['testimonial_title'],
	'sanitize_callback' => 'sanitize_text_field',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[testimonial_title]', array(
	'label'           	=> sprintf( esc_html__( 'Section Title', 'busyness-pro' ) ),
	'section'        	=> 'busyness_testimonial_section',
	'active_callback' 	=> 'busyness_is_testimonial_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[testimonial_title]', array(
		'selector'            => '#testimonial-slider-section .section-header h2',
		'settings'            => 'busyness_theme_options[testimonial_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_testimonial_title_partial',
    ) );
}

// Event social icons number control and setting
$wp_customize->add_setting( 'busyness_theme_options[testimonial_count]', array(
	'default'          	=> $options['testimonial_count'],
	'sanitize_callback' => 'busyness_sanitize_number_range',
	'validate_callback' => 'busyness_validate_testimonial_count',
) );

$wp_customize->add_control( 'busyness_theme_options[testimonial_count]', array(
	'label'             => esc_html__( 'Number of Items', 'busyness-pro' ),
	'description'       => esc_html__( 'Note: Min 1 & Max 10. Please input the valid number and save. Then refresh the page to see the change.', 'busyness-pro' ),
	'section'           => 'busyness_testimonial_section',
	'active_callback'   => 'busyness_is_testimonial_section_enable',
	'type'				=> 'number',
	'input_attrs'		=> array(
		'min'	=> 1,
		'max'	=> 10,
		'style' => 'width: 100px;'
		),
) );

// Testimonial content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[testimonial_content_type]', array(
	'default'          	=> $options['testimonial_content_type'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[testimonial_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'busyness-pro' ),
	'section'           => 'busyness_testimonial_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_testimonial_section_enable',
	'choices'			=> array(
		'page' 		=> esc_html__( 'Page', 'busyness-pro' ),
		'post' 		=> esc_html__( 'Post', 'busyness-pro' ),
		'category' 	=> esc_html__( 'Category', 'busyness-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'busyness-pro' ),
	),
) );

// Add dropdown category setting and control.
$wp_customize->add_setting(  'busyness_theme_options[testimonial_content_category]', array(
	'sanitize_callback' => 'busyness_sanitize_single_category',
) ) ;

$wp_customize->add_control( new busyness_Dropdown_Taxonomies_Control( $wp_customize,'busyness_theme_options[testimonial_content_category]', array(
	'label'             => esc_html__( 'Select Category', 'busyness-pro' ),
	'description'      	=> esc_html__( 'Note: Latest selected no of posts will be shown from selected category', 'busyness-pro' ),
	'section'           => 'busyness_testimonial_section',
	'type'              => 'dropdown-taxonomies',
	'active_callback'	=> 'busyness_is_testimonial_section_content_category_enable'
) ) );

for ( $i = 1; $i <= $options['testimonial_count']; $i++ ) :
	// testimonial pages drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[testimonial_content_page_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[testimonial_content_page_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Page %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_testimonial_section',
		'choices'			=> busyness_page_choices(),
		'active_callback'	=> 'busyness_is_testimonial_section_content_page_enable',
	) ) );

	// testimonial posts drop down chooser control and setting
	$wp_customize->add_setting( 'busyness_theme_options[testimonial_content_post_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_page',
	) );

	$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[testimonial_content_post_' . $i . ']', array(
		'label'             => sprintf( esc_html__( 'Select Post %d', 'busyness-pro' ), $i ),
		'section'           => 'busyness_testimonial_section',
		'choices'			=> busyness_post_choices(),
		'active_callback'	=> 'busyness_is_testimonial_section_content_post_enable',
	) ) );

	// testimonial title setting and control
	$wp_customize->add_setting( 'busyness_theme_options[testimonial_title_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'busyness_theme_options[testimonial_title_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Title %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_testimonial_section',
		'active_callback' 	=> 'busyness_is_testimonial_section_content_custom_enable',
		'type'				=> 'text',
	) );

	// testimonial position setting and control
	$wp_customize->add_setting( 'busyness_theme_options[testimonial_position_' . $i . ']', array(
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'busyness_theme_options[testimonial_position_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Position %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_testimonial_section',
		'active_callback' 	=> 'busyness_is_testimonial_section_content_position_enable',
		'type'				=> 'text',
	) );

	// testimonial description setting and control
	$wp_customize->add_setting( 'busyness_theme_options[testimonial_description_' . $i . ']', array(
		'sanitize_callback' => 'wp_kses_post',
	) );

	$wp_customize->add_control( 'busyness_theme_options[testimonial_description_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'Description %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_testimonial_section',
		'active_callback' 	=> 'busyness_is_testimonial_section_content_custom_enable',
		'type'				=> 'textarea',
	) );

	// testimonial image setting and control.
	$wp_customize->add_setting( 'busyness_theme_options[testimonial_image_' . $i . ']', array(
		'sanitize_callback' => 'busyness_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'busyness_theme_options[testimonial_image_' . $i . ']',
			array(
			'label'       		=> sprintf( esc_html__( 'Image %d', 'busyness-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'busyness-pro' ), 200, 200 ),
			'section'     		=> 'busyness_testimonial_section',
			'active_callback'	=> 'busyness_is_testimonial_section_content_custom_enable',
	) ) );

	// testimonial position setting and control
	$wp_customize->add_setting( 'busyness_theme_options[testimonial_link_' . $i . ']', array(
		'sanitize_callback' => 'esc_url_raw',
	) );

	$wp_customize->add_control( 'busyness_theme_options[testimonial_link_' . $i . ']', array(
		'label'           	=> sprintf( esc_html__( 'URL Link %d', 'busyness-pro' ), $i ),
		'section'        	=> 'busyness_testimonial_section',
		'active_callback' 	=> 'busyness_is_testimonial_section_content_custom_enable',
		'type'				=> 'url',
	) );

	// testimonial hr setting and control
	$wp_customize->add_setting( 'busyness_theme_options[testimonial_hr_'. $i .']', array(
		'sanitize_callback' => 'sanitize_text_field'
	) );

	$wp_customize->add_control( new busyness_Customize_Horizontal_Line( $wp_customize, 'busyness_theme_options[testimonial_hr_'. $i .']',
		array(
			'section'         => 'busyness_testimonial_section',
			'active_callback' => 'busyness_is_testimonial_section_content_seperator_enable',
			'type'			  => 'hr'
	) ) );
endfor;
