<?php
/**
 * Video Section options
 *
 * @package Busyness
 */

// Add Video section
$wp_customize->add_section( 'busyness_video_section', array(
	'title'             => esc_html__( 'Video','busyness-pro' ),
	'description'       => esc_html__( 'Video Section options.', 'busyness-pro' ),
	'panel'             => 'busyness_home_page_panel',
) );

// Video content enable control and setting
$wp_customize->add_setting( 'busyness_theme_options[video_section_enable]', array(
	'default'			=> 	$options['video_section_enable'],
	'sanitize_callback' => 'busyness_sanitize_switch_control',
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[video_section_enable]', array(
	'label'             => esc_html__( 'Enable Section', 'busyness-pro' ),
	'section'           => 'busyness_video_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// Video content type control and setting
$wp_customize->add_setting( 'busyness_theme_options[video_content_type]', array(
	'default'          	=> $options['video_content_type'],
	'sanitize_callback' => 'busyness_sanitize_select',
) );

$wp_customize->add_control( 'busyness_theme_options[video_content_type]', array(
	'label'             => esc_html__( 'Content Type', 'busyness-pro' ),
	'section'           => 'busyness_video_section',
	'type'				=> 'select',
	'active_callback' 	=> 'busyness_is_video_section_enable',
	'choices'			=> array(
		'page' 		=> esc_html__( 'Page', 'busyness-pro' ),
		'post' 		=> esc_html__( 'Post', 'busyness-pro' ),
		'custom' 	=> esc_html__( 'Custom', 'busyness-pro' ),
	),
) );

// video pages drop down chooser control and setting
$wp_customize->add_setting( 'busyness_theme_options[video_content_page]', array(
	'sanitize_callback' => 'busyness_sanitize_page',
) );

$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[video_content_page]', array(
	'label'             => esc_html__( 'Select Page', 'busyness-pro' ),
	'section'           => 'busyness_video_section',
	'choices'			=> busyness_page_choices(),
	'active_callback'	=> 'busyness_is_video_section_content_page_enable',
) ) );

// video posts drop down chooser control and setting
$wp_customize->add_setting( 'busyness_theme_options[video_content_post]', array(
	'sanitize_callback' => 'busyness_sanitize_page',
) );

$wp_customize->add_control( new busyness_Dropdown_Chooser( $wp_customize, 'busyness_theme_options[video_content_post]', array(
	'label'             => esc_html__( 'Select Post', 'busyness-pro' ),
	'section'           => 'busyness_video_section',
	'choices'			=> busyness_post_choices(),
	'active_callback'	=> 'busyness_is_video_section_content_post_enable',
) ) );

// video title setting and control
$wp_customize->add_setting( 'busyness_theme_options[video_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['video_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[video_title]', array(
	'label'           	=> esc_html__( 'Title', 'busyness-pro' ),
	'section'        	=> 'busyness_video_section',
	'active_callback' 	=> 'busyness_is_video_section_content_custom_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[video_title]', array(
		'selector'            => '#video .section-header h2',
		'settings'            => 'busyness_theme_options[video_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_video_title_partial',
    ) );
}

// video image setting and control.
	$wp_customize->add_setting( 'busyness_theme_options[video_image]', array(
		'sanitize_callback' => 'busyness_sanitize_image'
	) );

	$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'busyness_theme_options[video_image]',
			array(
			'label'       		=> sprintf( esc_html__( 'Image %d', 'busyness-pro' ), $i ),
			'description' 		=> sprintf( esc_html__( 'Recommended size: %1$dpx x %2$dpx ', 'busyness-pro' ), 1920, 620 ),
			'section'     		=> 'busyness_video_section',
			'active_callback'	=> 'busyness_is_video_section_content_custom_enable',
	) ) );

// video btn title setting and control
$wp_customize->add_setting( 'busyness_theme_options[video_btn_title]', array(
	'sanitize_callback' => 'sanitize_text_field',
	'default'			=> $options['video_btn_title'],
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[video_btn_title]', array(
	'label'           	=> esc_html__( 'Button Label', 'busyness-pro' ),
	'section'        	=> 'busyness_video_section',
	'active_callback' 	=> 'busyness_is_video_section_enable',
	'type'				=> 'text',
) );

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
    $wp_customize->selective_refresh->add_partial( 'busyness_theme_options[video_btn_title]', array(
		'selector'            => '#video .icon-play span',
		'settings'            => 'busyness_theme_options[video_btn_title]',
		'container_inclusive' => false,
		'fallback_refresh'    => true,
		'render_callback'     => 'busyness_video_btn_title_partial',
    ) );
}

// video btn link setting and control
$wp_customize->add_setting( 'busyness_theme_options[video_link]', array(
	'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( 'busyness_theme_options[video_link]', array(
	'label'           	=> esc_html__( 'Button URL', 'busyness-pro' ),
	'section'        	=> 'busyness_video_section',
	'active_callback' 	=> 'busyness_is_video_section_enable',
	'type'				=> 'url',
) );