<?php
/**
 * Footer options
 *
 * @package Busyness
 */

// Footer Section
$wp_customize->add_section( 'busyness_section_footer',
	array(
		'title'      			=> esc_html__( 'Footer', 'busyness-pro' ),
		'priority'   			=> 900,
		'panel'      			=> 'busyness_theme_options_panel',
	)
);

// Setting copyright_text.
$wp_customize->add_setting( 'busyness_theme_options[copyright_text]',
	array(
		'default'       		=> $options['copyright_text'],
		'capability'        	=> 'edit_theme_options',
		'sanitize_callback'		=> 'wp_kses_post',
	)
);

$wp_customize->add_control( 'busyness_theme_options[copyright_text]',
    array(
		'label'      			=> esc_html__( 'Copyright Text', 'busyness-pro' ),
		'section'    			=> 'busyness_section_footer',
		'type'		 			=> 'textarea',
    )
);

// Setting - powered_by_text.
$wp_customize->add_setting( 'busyness_theme_options[powered_by_text]',
	array(
		'default'           => $options['powered_by_text'],
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'wp_kses_post',
	)
);
$wp_customize->add_control( 'busyness_theme_options[powered_by_text]',
	array(
		'label'    => esc_html__( 'Powered By Text', 'busyness-pro' ),
		'section'  => 'busyness_section_footer',
		'type'     => 'textarea',
	)
);

// footer social menu
$wp_customize->add_setting( 'busyness_theme_options[footer_social_menu]',
	array(
		'sanitize_callback' => 'busyness_sanitize_switch_control',
		'default'       		=> $options['footer_social_menu'],
	)
);
$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[footer_social_menu]',
    array(
		'label'      		=> esc_html__( 'Footer Social Menu ', 'busyness-pro' ),
		'description'       => sprintf( '%1$s <a class="social-menu-trigger" href="#"> %2$s </a> %3$s', esc_html__( 'Note: To show social menu.', 'busyness-pro' ), esc_html__( 'Click Here', 'busyness-pro' ), esc_html__( 'to create menu', 'busyness-pro' ) ),
		'section'    		=> 'busyness_section_footer',
		'on_off_label' 		=> busyness_switch_options(),
    )
) );

// scroll top visible
$wp_customize->add_setting( 'busyness_theme_options[scroll_top_visible]',
	array(
		'default'       	=> $options['scroll_top_visible'],
		'sanitize_callback' => 'busyness_sanitize_switch_control',
	)
);
$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[scroll_top_visible]',
    array(
		'label'      		=> esc_html__( 'Scroll Top Button', 'busyness-pro' ),
		'section'    		=> 'busyness_section_footer',
		'on_off_label' 		=> busyness_switch_options(),
    )
) );

// Add reset footer setting and control.
$wp_customize->add_setting( 'busyness_theme_options[reset_footer]', array(
	'default'           => $options['reset_footer'],
	'sanitize_callback' => 'busyness_sanitize_checkbox',
	'transport'			  => 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[reset_footer]', array(
	'label'             => esc_html__( 'Check to reset footer options', 'busyness-pro' ),
	'section'           => 'busyness_section_footer',
	'type'              => 'checkbox',
) );
