<?php
/**
 * Header options
 *
 * @package Busyness
 */

// Header Menu Options
$wp_customize->add_section( 'busyness_topbar_section', array(
	'title'            	=> esc_html__( 'Header','busyness-pro' ),
	'description'       => esc_html__( 'Header Section Options', 'busyness-pro' ),
	'panel'             => 'busyness_theme_options_panel',
) );

// Header Menu Button
$wp_customize->add_setting( 'busyness_theme_options[topbar_login_register_enable]', array(
	'sanitize_callback' 	=> 'busyness_sanitize_switch_control',
	'default'       		=> $options['topbar_login_register_enable'],
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[topbar_login_register_enable]', array(
	'label'      		=> esc_html__( 'Enable Button', 'busyness-pro' ),
	'section'    		=> 'busyness_topbar_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );

// Header button setting and control
$wp_customize->add_setting( 'busyness_theme_options[topbar_login_label]', array(
	'default'			=> $options['topbar_login_label'],
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( 'busyness_theme_options[topbar_login_label]', array(
	'label'           	=> esc_html__( 'Button Label', 'busyness-pro' ),
	'section'        	=> 'busyness_topbar_section',
	'type'				=> 'text',
	'active_callback'	=> 'busyness_is_login_register_meta_section_enable',
) );

// Header button url setting and control
$wp_customize->add_setting( 'busyness_theme_options[topbar_login_url]', array(
	'sanitize_callback' => 'esc_url_raw',
	'transport'			=> 'postMessage',
) );

$wp_customize->add_control( 'busyness_theme_options[topbar_login_url]', array(
	'label'           	=> esc_html__( 'Button URL', 'busyness-pro' ),
	'section'        	=> 'busyness_topbar_section',
	'type'				=> 'url',
	'active_callback'	=> 'busyness_is_login_register_meta_section_enable',
) );

// Header sticky setting and control.
$wp_customize->add_setting( 'busyness_theme_options[menu_sticky]', array(
	'sanitize_callback' => 'busyness_sanitize_switch_control',
	'default'           => $options['menu_sticky'],
) );

$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[menu_sticky]', array(
	'label'             => esc_html__( 'Sticky Header', 'busyness-pro' ),
	'section'           => 'busyness_topbar_section',
	'on_off_label' 		=> busyness_switch_options(),
) ) );
