<?php
/**
 * Loader options
 *
 * @package Busyness
 */

$wp_customize->add_section( 'busyness_loader', array(
	'title'            		=> esc_html__( 'Loader','busyness-pro' ),
	'description'      		=> esc_html__( 'Loader section options.', 'busyness-pro' ),
	'panel'            		=> 'busyness_theme_options_panel',
) );

// Loader enable setting and control.
$wp_customize->add_setting( 'busyness_theme_options[loader_enable]', array(
	'sanitize_callback' 	=> 'busyness_sanitize_switch_control',
	'default'             	=> $options['loader_enable'],
) );

$wp_customize->add_control(  new busyness_Switch_Control( $wp_customize, 'busyness_theme_options[loader_enable]', array(
	'label'               	=> esc_html__( 'Enable loader', 'busyness-pro' ),
	'section'             	=> 'busyness_loader',
	'on_off_label' 			=> busyness_switch_options(),
) ) );

// Loader icons setting and control.
$wp_customize->add_setting( 'busyness_theme_options[loader_icon]', array(
	'sanitize_callback' 	=> 'busyness_sanitize_select',
	'default'				=> $options['loader_icon'],
) );

$wp_customize->add_control( 'busyness_theme_options[loader_icon]', array(
	'label'           		=> esc_html__( 'Icon', 'busyness-pro' ),
	'section'         		=> 'busyness_loader',
	'type'					=> 'select',
	'choices'				=> busyness_get_spinner_list(),
	'active_callback' 		=> 'busyness_is_loader_enable',
) );
