<?php
/**
 * Section Sortable options
 *
 * @package Busyness
 */

// Add sidebar section
$wp_customize->add_section( 'busyness_sortable', array(
	'title'               => esc_html__('Homepage Sortable','busyness-pro'),
	'description'         => esc_html__( 'Homepage Sortable options.', 'busyness-pro' ),
	'panel'               => 'busyness_theme_options_panel',
) );

// Site layout setting and control.
$wp_customize->add_setting( 'busyness_theme_options[sortable]', array(
	'default'			  => $options['sortable'],
	'sanitize_callback'   => 'busyness_sanitize_sortable',
) );

$wp_customize->add_control( new busyness_Customize_Sortable_Control ( $wp_customize, 'busyness_theme_options[sortable]', array(
	'label'               => esc_html__( 'Sortable Homepage', 'busyness-pro' ),
	'description'         => esc_html__( 'Drag and Drop to sort the sections according to your preference.', 'busyness-pro' ),
	'section'             => 'busyness_sortable',
	'type'                => 'sortable',
	'choices'			  => busyness_sortable_sections(),
) ) );