<?php
/**
 * Typography options
 *
 * @package Busyness
 */

// Typography Section
$wp_customize->add_section( 'busyness_section_typography',
	array(
		'title'      		=> esc_html__( 'Typography', 'busyness-pro' ),
		'priority'   		=> 600,
		'panel'      		=> 'busyness_theme_options_panel',
	)
);

$load_font_cdn_desc = sprintf(
	wp_kses(
		__( 'A German court fined a website using Google-hosted webfonts for violating Europe’s General Data Protection Regulation (GDPR). So this has been discouraged. More info %1$shere%2$s', 'busyness-pro' ),
		array(
			'a' => array(
				'href' => array(),
				'target' => array(),
			)
		)
	),
	'<a target="_blank" href="https://make.wordpress.org/themes/2022/06/18/complying-with-gdpr-when-using-google-fonts/">',
	'</a>'
);

// Setting - reset_font_settings.
$wp_customize->add_setting( 'theme_options[load_font_cdn]',
	array(
		'default'           => $options['load_font_cdn'],
		'capability'        => 'edit_theme_options',
		'transport'         => 'postMessage',
		'sanitize_callback' => 'busyness_sanitize_checkbox',
	)
);
$wp_customize->add_control( new busyness_Switch_Control( $wp_customize, 'theme_options[load_font_cdn]', array(
		'label'       => esc_html__( 'Load Google Font from CDN', 'busyness-pro' ),
		'description' => $load_font_cdn_desc,
		'section'     => 'busyness_section_typography',
		'on_off_label'=> busyness_hide_options(),
		'priority'    => 10,
	) )
);

// Theme typography setting and control.
$wp_customize->add_setting( 'busyness_theme_options[theme_typography]',
	array(
		'default'    		=> $options['theme_typography'],
		'sanitize_callback'	=> 'busyness_sanitize_select',
	)
);
$wp_customize->add_control( 'busyness_theme_options[theme_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Heading Typography', 'busyness-pro' ),
		'section'     		=> 'busyness_section_typography',
		'settings'    		=> 'busyness_theme_options[theme_typography]',
		'type'		  		=> 'select',
		'choices'			=> busyness_typography_options(),
    )
);

//Body Theme typography setting and control.
$wp_customize->add_setting( 'busyness_theme_options[body_theme_typography]',
	array(
		'default'    		=> $options['body_theme_typography'],
		'sanitize_callback'	=> 'busyness_sanitize_select',
	)
);
$wp_customize->add_control( 'busyness_theme_options[body_theme_typography]',
    array(
		'label'       		=> esc_html__( 'Choose Body Typography', 'busyness-pro' ),
		'section'     		=> 'busyness_section_typography',
		'settings'    		=> 'busyness_theme_options[body_theme_typography]',
		'type'		  		=> 'select',
		'choices'			=> busyness_body_typography_options(),
    )
);
