<?php
/**
* Customizer validation functions
*
* @package Busyness
*/

if ( ! function_exists( 'busyness_validate_long_excerpt' ) ) :
  function busyness_validate_long_excerpt( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'busyness-pro' ) );
     } elseif ( $value < 5 ) {
         $validity->add( 'min_no_of_words', esc_html__( 'Minimum no of words is 5', 'busyness-pro' ) );
     } elseif ( $value > 100 ) {
         $validity->add( 'max_no_of_words', esc_html__( 'Maximum no of words is 100', 'busyness-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'busyness_validate_slider_count' ) ) :
  function busyness_validate_slider_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'busyness-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'busyness-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'busyness-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'busyness_validate_service_count' ) ) :
  function busyness_validate_service_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'busyness-pro' ) );
     } elseif ( $value < 2 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 2', 'busyness-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'busyness-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'busyness_validate_about_count' ) ) :
  function busyness_validate_about_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'busyness-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'busyness-pro' ) );
     } elseif ( $value > 6 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 6', 'busyness-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'busyness_validate_testimonial_count' ) ) :
  function busyness_validate_testimonial_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'busyness-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'busyness-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'busyness-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'busyness_validate_feature_count' ) ) :
  function busyness_validate_feature_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'busyness-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'busyness-pro' ) );
     } elseif ( $value > 10 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 10', 'busyness-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'busyness_validate_counter_count' ) ) :
  function busyness_validate_counter_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'busyness-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'busyness-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'busyness-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'busyness_validate_team_count' ) ) :
  function busyness_validate_team_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'busyness-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of posts is 1', 'busyness-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of posts is 12', 'busyness-pro' ) );
     }
     return $validity;
  }
endif;

if ( ! function_exists( 'busyness_validate_client_count' ) ) :
  function busyness_validate_client_count( $validity, $value ){
         $value = intval( $value );
     if ( empty( $value ) || ! is_numeric( $value ) ) {
         $validity->add( 'required', esc_html__( 'You must supply a valid number.', 'busyness-pro' ) );
     } elseif ( $value < 1 ) {
         $validity->add( 'min_no_of_posts', esc_html__( 'Minimum no of client is 1', 'busyness-pro' ) );
     } elseif ( $value > 12 ) {
         $validity->add( 'max_no_of_posts', esc_html__( 'Maximum no of clients is 12', 'busyness-pro' ) );
     }
     return $validity;
  }
endif;





