<?php
/**
 * Busyness options
 *
 * @package Busyness
 */

/**
 * List of pages for page choices.
 * @return Array Array of page ids and name.
 */
function busyness_page_choices() {
    $pages = get_pages();
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'busyness-pro' );
    foreach ( $pages as $page ) {
        $choices[ $page->ID ] = $page->post_title;
    }
    return  $choices;
}

/**
 * List of posts for post choices.
 * @return Array Array of post ids and name.
 */
function busyness_post_choices() {
    $posts = get_posts( array( 'numberposts' => -1 ) );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'busyness-pro' );
    foreach ( $posts as $post ) {
        $choices[ $post->ID ] = $post->post_title;
    }
    return  $choices;
}

/**
 * List of category for category choices.
 * @return Array Array of post ids and name.
 */
function busyness_category_choices() {
    $tax_args = array(
        'hierarchical' => 0,
        'taxonomy'     => 'category',
    );
    $taxonomies = get_categories( $tax_args );
    $choices = array();
    $choices[0] = esc_html__( '--Select--', 'busyness-pro' );
    foreach ( $taxonomies as $tax ) {
        $choices[ $tax->term_id ] = $tax->name;
    }
    return  $choices;
}

if ( ! function_exists( 'busyness_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function busyness_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'busyness-pro' ),
            'header-font-1'   => esc_html__( 'Rajdhani', 'busyness-pro' ),
            'header-font-2'   => esc_html__( 'Cherry Swash', 'busyness-pro' ),
            'header-font-3'   => esc_html__( 'Philosopher', 'busyness-pro' ),
            'header-font-4'   => esc_html__( 'Slabo 27px', 'busyness-pro' ),
            'header-font-5'   => esc_html__( 'Dosis', 'busyness-pro' ),
        );

        $output = apply_filters( 'busyness_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;


if ( ! function_exists( 'busyness_body_typography_options' ) ) :
    /**
     * Returns list of typography
     * @return array font styles
     */
    function busyness_body_typography_options(){
        $choices = array(
            'default'         => esc_html__( 'Default', 'busyness-pro' ),
            'body-font-1'     => esc_html__( 'News Cycle', 'busyness-pro' ),
            'body-font-2'     => esc_html__( 'Pontano Sans', 'busyness-pro' ),
            'body-font-3'     => esc_html__( 'Gudea', 'busyness-pro' ),
            'body-font-4'     => esc_html__( 'Quattrocento', 'busyness-pro' ),
            'body-font-5'     => esc_html__( 'Khand', 'busyness-pro' ),
        );

        $output = apply_filters( 'busyness_body_typography_options', $choices );
        if ( ! empty( $output ) ) {
            ksort( $output );
        }

        return $output;
    }
endif;

if ( ! function_exists( 'busyness_site_layout' ) ) :
    /**
     * Site Layout
     * @return array site layout options
     */
    function busyness_site_layout() {
        $busyness_site_layout = array(
            'wide'  => get_template_directory_uri() . '/assets/images/full.png',
            'boxed-layout' => get_template_directory_uri() . '/assets/images/boxed.png',
            'frame-layout' => get_template_directory_uri() . '/assets/images/framed.png',
        );

        $output = apply_filters( 'busyness_site_layout', $busyness_site_layout );
        return $output;
    }
endif;

if ( ! function_exists( 'busyness_selected_sidebar' ) ) :
    /**
     * Sidebars options
     * @return array Sidbar positions
     */
    function busyness_selected_sidebar() {
        $busyness_selected_sidebar = array(
            'sidebar-1'             => esc_html__( 'Default Sidebar', 'busyness-pro' ),
            'optional-sidebar'      => esc_html__( 'Optional Sidebar 1', 'busyness-pro' ),
            'optional-sidebar-2'    => esc_html__( 'Optional Sidebar 2', 'busyness-pro' ),
            'optional-sidebar-3'    => esc_html__( 'Optional Sidebar 3', 'busyness-pro' ),
            'optional-sidebar-4'    => esc_html__( 'Optional Sidebar 4', 'busyness-pro' ),
        );

        $output = apply_filters( 'busyness_selected_sidebar', $busyness_selected_sidebar );

        return $output;
    }
endif;


if ( ! function_exists( 'busyness_global_sidebar_position' ) ) :
    /**
     * Global Sidebar position
     * @return array Global Sidebar positions
     */
    function busyness_global_sidebar_position() {
        $busyness_global_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
        );

        $output = apply_filters( 'busyness_global_sidebar_position', $busyness_global_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'busyness_sidebar_position' ) ) :
    /**
     * Sidebar position
     * @return array Sidbar positions
     */
    function busyness_sidebar_position() {
        $busyness_sidebar_position = array(
            'right-sidebar' => get_template_directory_uri() . '/assets/images/right.png',
            'left-sidebar'  => get_template_directory_uri() . '/assets/images/left.png',
            'no-sidebar'    => get_template_directory_uri() . '/assets/images/full.png',
            'no-sidebar-content'   => get_template_directory_uri() . '/assets/images/boxed.png',
        );

        $output = apply_filters( 'busyness_sidebar_position', $busyness_sidebar_position );

        return $output;
    }
endif;


if ( ! function_exists( 'busyness_pagination_options' ) ) :
    /**
     * Pagination
     * @return array site pagination options
     */
    function busyness_pagination_options() {
        $busyness_pagination_options = array(
            'numeric'   => esc_html__( 'Numeric', 'busyness-pro' ),
            'default'   => esc_html__( 'Default(Older/Newer)', 'busyness-pro' ),
            'infinite'  => esc_html__( 'Infinite', 'busyness-pro' ),
        );

        $output = apply_filters( 'busyness_pagination_options', $busyness_pagination_options );

        return $output;
    }
endif;

if ( ! function_exists( 'busyness_get_spinner_list' ) ) :
    /**
     * List of spinner icons options.
     * @return array List of all spinner icon options.
     */
    function busyness_get_spinner_list() {
        $arr = array(
            'default'               => esc_html__( 'Default', 'busyness-pro' ),
            'spinner-wheel'         => esc_html__( 'Wheel', 'busyness-pro' ),
            'spinner-double-circle' => esc_html__( 'Double Circle', 'busyness-pro' ),
            'spinner-two-way'       => esc_html__( 'Two Way', 'busyness-pro' ),
            'spinner-umbrella'      => esc_html__( 'Umbrella', 'busyness-pro' ),
            'spinner-dots'          => esc_html__( 'Dots', 'busyness-pro' ),
            'spinner-one-way'       => esc_html__( 'One Way', 'busyness-pro' ),
            'spinner-fidget'        => esc_html__( 'Fidget', 'busyness-pro' ),
        );
        return apply_filters( 'busyness_spinner_list', $arr );
    }
endif;

if ( ! function_exists( 'busyness_switch_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function busyness_switch_options() {
        $arr = array(
            'on'        => esc_html__( 'Enable', 'busyness-pro' ),
            'off'       => esc_html__( 'Disable', 'busyness-pro' )
        );
        return apply_filters( 'busyness_switch_options', $arr );
    }
endif;

if ( ! function_exists( 'busyness_hide_options' ) ) :
    /**
     * List of custom Switch Control options
     * @return array List of switch control options.
     */
    function busyness_hide_options() {
        $arr = array(
            'on'        => esc_html__( 'Yes', 'busyness-pro' ),
            'off'       => esc_html__( 'No', 'busyness-pro' )
        );
        return apply_filters( 'busyness_hide_options', $arr );
    }
endif;

if ( ! function_exists( 'busyness_sortable_sections' ) ) :
    /**
     * List of sections Control options
     * @return array List of Sections control options.
     */
    function busyness_sortable_sections() {
        $sections = array(
            'slider' => esc_html__( 'Slider', 'busyness-pro' ),
            'about' => esc_html__( 'About Us', 'busyness-pro' ),
            'service'   => esc_html__( 'Services', 'busyness-pro' ),
            'video'  => esc_html__( 'Video', 'busyness-pro' ),
            'portfolio'     => esc_html__( 'Portfolio', 'busyness-pro' ),
            'team' => esc_html__( ' Team', 'busyness-pro' ),
            'counter' => esc_html__( 'Counter', 'busyness-pro' ),
            'testimonial'      => esc_html__( 'Testimonial', 'busyness-pro' ),
            'cta' => esc_html__( 'Call to Action', 'busyness-pro' ),
            'feature' => esc_html__( 'Feature', 'busyness-pro' ),
            'blog' => esc_html__( 'Blog', 'busyness-pro' ),
            'pricing' => esc_html__( 'Pricing', 'busyness-pro' ),
            'promotion' => esc_html__( 'Promotion', 'busyness-pro' ),
            'client' => esc_html__( 'Client', 'busyness-pro' ),
        );
        return apply_filters( 'busyness_sortable_sections', $sections );
    }
endif;
