<?php
/**
 * About section
 *
 * This is the template for the content of about section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_about_section' ) ) :
    /**
    * Add about section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_about_section() {
        $options = busyness_get_theme_options();
        // Check if about is enabled on frontpage
        $about_enable = apply_filters( 'busyness_section_status', true, 'about_section_enable' );

        if ( true !== $about_enable ) {
            return false;
        }
        // Get about section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_about_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render about section now.
        busyness_render_about_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_about_section_details' ) ) :
    /**
    * about section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input about section details.
    */
    function busyness_get_about_section_details( $input ) {
        $options = busyness_get_theme_options();

        // Content type.
        $about_content_type  = $options['about_content_type'];
        $about_count = ! empty( $options['about_count'] ) ? $options['about_count'] : 4;

        $content = array();
        switch ( $about_content_type ) {

            case 'page':
                $page_ids = array();
                $sub_title = array();
                $btn_title = array();

                for ( $i = 1; $i <= $about_count; $i++ ) {
                    if ( ! empty( $options['about_content_page_' . $i] ) ) :
                        $page_ids[] = $options['about_content_page_' . $i];
                        $sub_title[] = ! empty( $options['about_sub_title_' . $i] ) ? $options['about_sub_title_' . $i] : '';
                        $btn_title[] = ! empty( $options['about_btn_title_' . $i] ) ? $options['about_btn_title_' . $i] : '';
                    endif;
                }

                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $about_count ),
                    'orderby'           => 'post__in',
                    );
            break;

            case 'post':
                $post_ids = array();
                $sub_title = array();
                $btn_title = array();

                for ( $i = 1; $i <= $about_count; $i++ ) {
                    if ( ! empty( $options['about_content_post_' . $i] ) ) :
                        $post_ids[] = $options['about_content_post_' . $i];
                        $sub_title[] = ! empty( $options['about_sub_title_' . $i] ) ? $options['about_sub_title_' . $i] : '';
                        $btn_title[] = ! empty( $options['about_btn_title_' . $i] ) ? $options['about_btn_title_' . $i] : '';
                    endif;
                }

                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $about_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'category':
                $cat_id = ! empty( $options['about_content_category'] ) ? $options['about_content_category'] : '';
                $sub_title = array();
                $btn_title = array();

                for ( $i = 1; $i <= $about_count; $i++ ) {
                    $sub_title[] = ! empty( $options['about_sub_title_' . $i] ) ? $options['about_sub_title_' . $i] : '';
                    $btn_title[] = ! empty( $options['about_btn_title_' . $i] ) ? $options['about_btn_title_' . $i] : '';
                }

                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $about_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );
            break;

            default:
            break;
        }


            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
                $i = 0;
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['sub_title'] = ! empty( $sub_title[ $i ] ) ? $sub_title[ $i ] :'';
                    $page_post['btn_title'] = ! empty( $btn_title[ $i ] ) ? $btn_title[ $i ] :'';
                    
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : '';

                    $page_post['excerpt'] = '';
                    
                    $j = $i + 1;
                    
                    if ( ! isset( $options['about_display_content_' . $j] ) ) {
                        $options['about_display_content_' . $j] = 'excerpt';
                    }

                    if ( 'excerpt' === $options['about_display_content_' . $j] ) {
                        $page_post['excerpt'] = busyness_trim_content( 25 );
                    } elseif( 'full-content' === $options['about_display_content_' . $j] ) {
                        $page_post['excerpt'] = apply_filters( 'the_content', get_the_content() );
                    }

                    // Push to the main array.
                    array_push( $content, $page_post );
                    $i++;
                endwhile;
            endif;
            wp_reset_postdata();


        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// about section content details.
add_filter( 'busyness_filter_about_section_details', 'busyness_get_about_section_details' );


if ( ! function_exists( 'busyness_render_about_section' ) ) :
  /**
   * Start about section
   *
   * @return string about content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_about_section( $content_details = array() ) {
        $options = busyness_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="about-us" class="relative page-section">
            <div class="wrapper">
                <?php foreach ( $content_details as $content ) : ?>
                    <article>
                         <?php if ( ! empty( $content['image'] ) ) : ?>
                            <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                                <a href="<?php echo esc_url( $content['url'] ); ?>" class="post-thumbnail-link"></a>
                            </div><!-- .featured-image -->
                        <?php endif; ?>

                        <div class="entry-container">
                           <div class="section-header">
                                <h2 class="section-title"><?php echo esc_html( $content['title'] ); ?></h2>
                                <?php if ( ! empty( $content['sub_title'] ) ) : ?>
                                    <p class="section-subtitle"><?php echo esc_html( $content['sub_title'] ); ?></p>
                                <?php endif; ?>
                            </div><!-- .section-header -->

                            <div class="section-content">
                                <p><?php echo $content['excerpt']; ?></p>
                            </div><!-- .section-content -->

                            <?php if ( ! empty( $content['btn_title'] ) ): ?>
                                <div class="more-link">
                                    <a href="<?php echo esc_url( $content['url'] ); ?>" class="btn btn-transparent">
                                        <?php echo esc_html( $content['btn_title'] ); ?>
                                    </a>
                                </div><!-- .more-link -->
                            <?php endif ?>
                        </div><!-- .entry-container -->
                    </article>
                <?php endforeach; ?>
            </div><!-- .wrapper -->
        </div><!-- #about-us -->
    <?php }
endif;
