<?php
/**
 * Blog section
 *
 * This is the template for the content of blog section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_blog_section' ) ) :
    /**
    * Add blog section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_blog_section() {
    	$options = busyness_get_theme_options();
        // Check if blog is enabled on frontpage
        $blog_enable = apply_filters( 'busyness_section_status', true, 'blog_section_enable' );

        if ( true !== $blog_enable ) {
            return false;
        }
        // Get blog section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_blog_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render blog section now.
        busyness_render_blog_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_blog_section_details' ) ) :
    /**
    * blog section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input blog section details.
    */
    function busyness_get_blog_section_details( $input ) {
        $options = busyness_get_theme_options();

        // Content type.
        $blog_content_type  = $options['blog_content_type'];
        $blog_count = ! empty( $options['blog_count'] ) ? $options['blog_count'] : 3;

        $content = array();
        switch ( $blog_content_type ) {

            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $blog_count; $i++ ) {
                    if ( ! empty( $options['blog_content_page_' . $i] ) )
                        $page_ids[] = $options['blog_content_page_' . $i];
                }

                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $blog_count ),
                    'orderby'           => 'post__in',
                    );
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $blog_count; $i++ ) {
                    if ( ! empty( $options['blog_content_post_' . $i] ) )
                        $post_ids[] = $options['blog_content_post_' . $i];
                }

                $args = array(
                    'post_type'             => 'post',
                    'post__in'              => ( array ) $post_ids,
                    'posts_per_page'        => absint( $blog_count ),
                    'orderby'               => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'category':
                $cat_id = ! empty( $options['blog_content_category'] ) ? $options['blog_content_category'] : '';
                $args = array(
                    'post_type'             => 'post',
                    'posts_per_page'        => absint( $blog_count ),
                    'cat'                   => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'recent':
                $cat_ids = ! empty( $options['blog_category_exclude'] ) ? $options['blog_category_exclude'] : array();
                $args = array(
                    'post_type'             => 'post',
                    'posts_per_page'        => absint( $blog_count ),
                    'cat'                   => ( array ) $cat_ids,
                    'ignore_sticky_posts'   => true,
                    );
            break;

            default:
            break;
        }


        // Run The Loop.
        $query = new WP_Query( $args );
        if ( $query->have_posts() ) :
            while ( $query->have_posts() ) : $query->the_post();
                $page_post['id']        = get_the_id();
                $page_post['title']     = get_the_title();
                $page_post['url']       = get_the_permalink();
                $page_post['excerpt']   = busyness_trim_content( 20 );
                $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : '';

                // Push to the main array.
                array_push( $content, $page_post );
            endwhile;
        endif;
        wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// blog section content details.
add_filter( 'busyness_filter_blog_section_details', 'busyness_get_blog_section_details' );


if ( ! function_exists( 'busyness_render_blog_section' ) ) :
  /**
   * Start blog section
   *
   * @return string blog content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_blog_section( $content_details = array() ) {
        $options = busyness_get_theme_options();
        $column = ! empty( $options['blog_column'] ) ? $options['blog_column'] : 'col3';
        $theme_version = $options['theme_version'];
        $blog_content_type  = $options['blog_content_type'];

        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="blog" class="relative page-section">
                <div class="wrapper">
                    <div class="section-header">
                        <?php if ( ! empty($options['blog_title']) ): ?>
                            <h2 class="section-title">
                                <?php echo esc_html( $options['blog_title'] ) ; ?>
                            </h2>
                        <?php endif ?>
                        <?php if ( ! empty($options['blog_sub_title']) ): ?>
                            <p class="section-subtitle">
                                <?php echo esc_html( $options['blog_sub_title'] ) ; ?>
                            </p>
                        <?php endif ?>
                    </div><!-- .section-header -->

                    <div class="section-content section-wrapper posts-wrapper <?php echo esc_html( $options['blog_column'] ) ; ?>">
                        <?php foreach ( $content_details as $content ):
                            $image = ! empty( $content['image'] ) ? $content['image'] : '';
                        ?>
                            <article class="hentry">
                                <div class="blog-wrapper">
                                    <?php
                                    if ( !empty( $content['image'] ) ) :
                                    ?>
                                        <div class="featured-image">
                                            <a href="<?php echo esc_url( $content['url'] ) ; ?>">
                                                <img src="<?php echo esc_url( $image ) ; ?>">
                                            </a>
                                            <?php
                                            if ( 'knowledge-version' === $theme_version && $blog_content_type != 'page' && ( ! $options['hide_date'] ) ) {
                                            ?>
                                                <div class="entry-meta">
                                                    <?php
                                                    busyness_posted_on( $content['id'] );
                                                    knowledge_posted_by( $content['id'] );
                                                    ?>
                                                </div><!-- .entry-meta -->
                                            <?php
                                            } ?>
                                        </div><!-- .featured-image -->
                                    <?php
                                    endif; ?>

                                    <div class="entry-container">
                                        <?php if ( 'knowledge-version' != $theme_version ) : ?>
                                            <div class="entry-meta">
                                                <span class="posted-on">
                                                    <span class="screen-reader-text"><?php echo esc_html__('Posted on', 'busyness-pro') ?></span>
                                                    <?php busyness_posted_on( $content['id'] ) ; ?>
                                                </span><!-- .posted-on -->
                                            </div>
                                        <?php
                                        endif; ?>

                                        <header class="entry-header">
                                            <h2 class="entry-title">
                                                <a href="<?php echo esc_url( $content['url'] ) ; ?>">
                                                    <?php echo esc_html( $content['title'] ) ; ?>
                                                </a>
                                            </h2>
                                            <?php
                                            if ( 'knowledge-version' === $theme_version && empty( $content['image'] ) ) {
                                            ?>
                                                <div class="entry-meta">
                                                    <span class="posted-on">
                                                        <span class="screen-reader-text"><?php esc_html_e('Posted on','busyness-pro') ?></span>
                                                        <?php busyness_posted_on( $content['id'] ) ; ?>
                                                    </span><!-- .posted-on -->
                                                </div><!-- .entry-meta -->
                                            <?php
                                            } ?>
                                        </header>

                                        <div class="entry-content">
                                            <p>
                                                <?php echo esc_html( $content['excerpt'] ) ; ?>
                                            </p>
                                        </div><!-- .entry-content -->

                                        <?php
                                        if ( 'knowledge-version' === $theme_version && $blog_content_type != 'page' ) {
                                        ?>
                                            <footer class="entry-footer">
                                                <span class="cat-links"><span class="categories-label"><?php esc_html_e( 'Categories: ', 'busyness-pro' ); ?>
                                                    <?php the_category(', ', '', $content['id'] ) ; ?>
                                                 </span><!-- .cat-links -->
                                                <?php knowledge_edit_link(); ?>
                                            </footer><!-- .entry-footer -->
                                        <?php
                                        }
                                        else {
                                        ?>
                                            <span class="cat-links">
                                                <?php the_category('', '', $content['id'] ) ; ?>
                                            </span>
                                        <?php
                                        } ?>

                                    </div>
                                </div>
                            </article>
                        <?php endforeach ?>
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div>
    <?php }
endif;