<?php
/**
 * Client section
 *
 * This is the template for the content of client section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_client_section' ) ) :
    /**
    * Add client section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_client_section() {
    	$options = busyness_get_theme_options();
        // Check if client is enabled on frontpage
        $client_enable = apply_filters( 'busyness_section_status', true, 'client_section_enable' );

        if ( true !== $client_enable ) {
            return false;
        }
        // Get client section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_client_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render client section now.
        busyness_render_client_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_client_section_details' ) ) :
    /**
    * client section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input client section details.
    */
    function busyness_get_client_section_details( $input ) {
        $options = busyness_get_theme_options();

        $client_count = ! empty( $options['client_count'] ) ? $options['client_count'] : 3 ;

        $content = array();

        for ($i=1; $i <= $client_count ; $i++) {

            $client_post['image']            = ! empty ( $options['client_image_' . $i ] ) ? $options['client_image_' . $i ] : '' ;
            $client_post['url']            = ! empty ( $options['client_link_' . $i ] ) ? $options['client_link_' . $i ] : '' ;


            array_push( $content, $client_post );
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// client section content details.
add_filter( 'busyness_filter_client_section_details', 'busyness_get_client_section_details' );


if ( ! function_exists( 'busyness_render_client_section' ) ) :
  /**
   * Start client section
   *
   * @return string client content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_client_section( $content_details = array() ) {
        $options = busyness_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        }
        if ( $options['client_count'] >= 6) {
           $slide = 6;
        }else{
            $slide = $options['client_count'];
        }
        ?>
            <div id="client-slider" class="relative page-section">
                <div class="wrapper">
                    <div class="client-slider-container regular" data-slick='{"slidesToShow": 6, "slidesToScroll": 1, "infinite": false, "speed": 800, "dots": false, "arrows":true, "autoplay": true, "fade": false }'>
                        <?php $i = 1 ; foreach ( $content_details as $content ): ?>
                            <?php if ( ! empty( $content['image'] ) ): ?>
                                <a href="<?php echo esc_url( $content['url'] ) ; ?>">
                                    <img src="<?php echo esc_url( $content['image'] ) ; ?>" >
                                </a>
                            <?php endif ?>
                        <?php $i++; endforeach; ?>
                    </div><!-- .client-slider -->
                </div><!-- .wrapper -->
            </div><!-- #client-slider -->

    <?php }
endif;