<?php
/**
 * Counter section
 *
 * This is the template for the content of counter section
 *
 * @package Busyness
 */
if ( ! function_exists( 'busyness_add_counter_section' ) ) :
    /**
    * Add counter section
    *
    *@since Busynness Pro 1.0.0
    */
    function busyness_add_counter_section() {
        $options = busyness_get_theme_options();
        // Check if counter is enabled on frontpage
        $counter_enable = apply_filters( 'busyness_section_status', true, 'counter_section_enable' );

        if ( true !== $counter_enable ) {
            return false;
        }

        // Render counter section now.
        busyness_render_counter_section();
    }
endif;

if ( ! function_exists( 'busyness_render_counter_section' ) ) :
  /**
   * Start counter section
   *
   * @return string counter content
   * @since Music Freak Pro 1.0.0
   *
   */
   function busyness_render_counter_section() {
        $options = busyness_get_theme_options();
        $counter_count = ! empty( $options['counter_count'] ) ? $options['counter_count'] : 4;
        $column = !empty( $options['counter_column'] ) ? $options['counter_column'] : 'col4' ;
        $background_image = !empty( $options['counter_image'] ) ? $options['counter_image'] : '' ;
        ?>

        <div id="counter" class="relative page-section" style="background-image:url('<?php echo esc_url( $background_image ); ?>')">
            <div class="wrapper">
                <div class="counter-wrapper clear <?php echo esc_attr( $column ); ?>">
                    <?php for ( $i = 1; $i <= $counter_count; $i++ ) : ?>
                        <article class="hentry">
                             <?php if ( ! empty( $options['counter_title_' . $i] ) && ! empty( $options['counter_number_' . $i] ) ) : ?>
                                <div class="icon-container">
                                    <a href="#">
                                        <i class="fa <?php echo ! empty( $options['counter_content_icon_' . $i] ) ? esc_attr( $options['counter_content_icon_' . $i] ) : 'fa-laptop' ?>"></i>
                                    </a>
                                </div><!-- .icon-container -->
                                <div class="text">
                                    <span class="stat-count"><?php echo esc_html( $options['counter_number_' . $i] ); ?></span>
                                    <small><?php echo esc_html( $options['counter_title_' . $i] ); ?></small>
                                </div><!-- .text -->
                            <?php endif; ?>
                        </article>
                    <?php endfor; ?>
                </div><!-- .section-content -->
            </div><!-- .wrapper -->
         </div><!-- #counter -->

    <?php }
endif;
