<?php
/**
 * Features section
 *
 * This is the template for the content of features section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_feature_section' ) ) :
    /**
    * Add client section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_feature_section() {
    	$options = busyness_get_theme_options();
        // Check if client is enabled on frontpage
        $feature_enable = apply_filters( 'busyness_section_status', true, 'feature_section_enable' );

        if ( true !== $feature_enable ) {
            return false;
        }
        // Get client section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_feature_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render client section now.
        busyness_render_feature_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_feature_section_details' ) ) :
    /**
    * client section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input client section details.
    */
    function busyness_get_feature_section_details( $input ) {
        $options = busyness_get_theme_options();

        // Content type.
        $feature_content_type  = $options['feature_content_type'];
        $feature_count = ! empty( $options['feature_count'] ) ? $options['feature_count'] : 3;

        $content = array();
        switch ( $feature_content_type ) {

            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $feature_count; $i++ ) {
                    if ( ! empty( $options['feature_content_page_' . $i] ) )
                        $page_ids[] = $options['feature_content_page_' . $i];
                }

                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $feature_count ),
                    'orderby'           => 'post__in',
                    );
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $feature_count; $i++ ) {
                    if ( ! empty( $options['feature_content_post_' . $i] ) )
                        $post_ids[] = $options['feature_content_post_' . $i];
                }

                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $feature_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'category':
                $cat_id = ! empty( $options['feature_content_category'] ) ? $options['feature_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $feature_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'custom':
                $custom = array();
                for ($i=1; $i <= $feature_count ; $i++) {
                   $custom['title'] = ! empty( $options['feature_title_'.$i ] ) ? $options['feature_title_'.$i ] : '' ;
                   $custom['exerpt'] = ! empty( $options['feature_description_'.$i ] ) ? $options['feature_description_'.$i ] : '' ;
                   $custom['url'] = ! empty( $options['feature_link_'.$i ] ) ? $options['feature_link_'.$i ] : '' ;
                   $custom['icon'] = ! empty( $options['feature_icon_'.$i ] ) ? $options['feature_icon_'.$i ] : '' ;

                   array_push( $content , $custom );
                }
            break;

            default:
            break;
        }

        if ( $options['feature_content_type'] !== 'custom' ) {
             // Run The Loop.
            $query = new WP_Query( $args );
            $i = 1 ;
            if ( $query->have_posts() ) :
                while ( $query->have_posts() ) : $query->the_post();
                    $feature_page_post['title']     = get_the_title();
                    $feature_page_post['icon']      = ! empty( $options['feature_icon_'.$i ] ) ? $options['feature_icon_'.$i ] : '' ;
                    $feature_page_post['url']       = get_the_permalink();
                    $feature_page_post['exerpt']    = busyness_trim_content( 25 );


                    // Push to the main array.
                    array_push( $content, $feature_page_post );
                    $i++;
                endwhile;
            endif;
            wp_reset_postdata();
        }



        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// client section content details.
add_filter( 'busyness_filter_feature_section_details', 'busyness_get_feature_section_details' );


if ( ! function_exists( 'busyness_render_feature_section' ) ) :
  /**
   * Start client section
   *
   * @return string client content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_feature_section( $content_details = array() ) {
        $options = busyness_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="our-features" class="relative page-section">
                <div class="wrapper">
                    <div class="section-header">
                        <?php if ( ! empty( $options['feature_title'] ) ): ?>
                            <h2 class="section-title">
                                <?php echo esc_html( $options['feature_title'] ) ; ?>
                            </h2>
                        <?php endif ?>
                        <?php if ( ! empty( $options['feature_sub_title'] ) ): ?>
                            <p class="section-subtitle">
                                <?php echo esc_html( $options['feature_sub_title'] ) ; ?>
                            </p>
                        <?php endif ?>
                    </div><!-- .section-header -->

                    <div class="section-content clear">
                        <div class="features-wrapper">
                            <?php foreach ( $content_details as $content ): ?>
                                <article>
                                    <div class="featured-image">
                                        <a href="<?php echo esc_url( $content['url'] ) ; ?>">
                                            <i class="fa <?php echo esc_attr( $content['icon'] ) ; ?>"></i>
                                        </a>
                                    </div><!-- .featured-image -->

                                    <header class="entry-header">
                                        <h2 class="entry-title">
                                            <a href="<?php echo esc_url( $content['url'] ) ; ?>">
                                                <?php echo esc_html( $content['title'] ) ; ?>
                                            </a>
                                        </h2>
                                        <p>
                                            <?php echo esc_html( $content['exerpt'] ) ; ?>
                                        </p>
                                    </header>
                                </article>
                            <?php endforeach ?>
                        </div><!-- .features-wrapper -->
                        <?php if ( ! empty( $options['feature_image'] ) ): ?>
                            <div class="center-featured-image">
                                <img src="<?php echo esc_url( $options['feature_image'] ) ; ?>" >
                            </div><!-- .center-featured-image -->
                        <?php endif ?>
                    </div><!-- .happy-clients -->
                </div><!-- .wrapper -->
            </div><!-- #my-clients -->
    <?php }
endif;
