<?php
/**
 * Portfolio Section
 *
 * This is the template for the content of portfolio section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_portfolio_section' ) ) :
    /**
    * Add portfolio section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_portfolio_section() {
    	$options = busyness_get_theme_options();
        // Check if portfolio is enabled on frontpage
        $portfolio_enable = apply_filters( 'busyness_section_status', true, 'portfolio_section_enable' );

        if ( true !== $portfolio_enable ) {
            return false;
        }
        // Get portfolio section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_portfolio_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render portfolio section now.
        busyness_render_portfolio_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_portfolio_section_details' ) ) :
    /**
    * portfolio section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input portfolio section details.
    */
    function busyness_get_portfolio_section_details( $input ) {
        $options = busyness_get_theme_options();

        // Content type.
        $portfolio_count = ! empty( $options['portfolio_count'] ) ? $options['portfolio_count'] : 8;

        $content = array();
        $cats = ! empty( $options['portfolio_categories'] ) ? $options['portfolio_categories'] : array();

        if ( empty( $cats ) )
            return;

        $args = array(
            'post_type'             => 'post',
            'posts_per_page'        => absint( $portfolio_count ),
            'category__in'          => $cats,
            'ignore_sticky_posts'   => true,
            );

        // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['id']        = get_the_id();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = busyness_trim_content( 25 );
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'post-thumbnail' ) : '';


                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// portfolio section content details.
add_filter( 'busyness_filter_portfolio_section_details', 'busyness_get_portfolio_section_details' );


if ( ! function_exists( 'busyness_render_portfolio_section' ) ) :
  /**
   * Start portfolio section
   *
   * @return string portfolio content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_portfolio_section( $content_details = array() ) {
        $options = busyness_get_theme_options();
        $cats = ! empty( $options['portfolio_categories'] ) ? $options['portfolio_categories'] : array();
        $btn_label = ! empty( $options['portfolio_btn_title'] ) ? $options['portfolio_btn_title'] : '';
        $btn_url = ! empty( $options['portfolio_btn_url'] ) ? $options['portfolio_btn_url'] : '';
        if ( empty( $content_details ) ) {
            return;
        } ?>


        <div id="portfolio" class="page-section">
            <?php if ( ! empty( $options['portfolio_title'] ) || ! empty( $options['portfolio_sub_title'] ) ) : ?>
                <div class="section-header">

                    <?php if ( ! empty( $options['portfolio_title'] ) ) : ?>
                        <h2 class="section-title"><?php echo esc_html( $options['portfolio_title'] ); ?></h2>
                    <?php endif;

                     if ( ! empty( $options['portfolio_sub_title'] ) ) : ?>
                        <p class="section-subtitle"><?php echo esc_html( $options['portfolio_sub_title'] ); ?></p>
                    <?php endif; ?>
                </div><!-- .section-header -->
            <?php endif; ?>

            <div class="section-content col4">
                <nav class="portfolio-filter">
                    <ul class="nav-tabs clear">
                        <li class="active"><a href="#" data-filter="*"><?php esc_html_e( 'All', 'busyness-pro' ); ?></a>
                        </li>
                        <?php foreach ( $cats as $cat ) :
                            $category = get_category( $cat ); ?>
                            <li>
                                <a href="#" data-filter=".<?php echo esc_attr( $category->slug ); ?>"><?php echo esc_html( $category->name ); ?></a>
                            </li>
                        <?php endforeach; ?>
                    </ul><!-- .nav-tabs -->
                </nav>


                <div class="grid gallery-popup">
                    <?php foreach ( $content_details as $content ) :
                            $post_category = get_the_category( $content['id'] );
                        ?>
                        <div class="grid-item <?php foreach ( $post_category as $cat ) { echo esc_attr($cat->slug) . ' '; } ?>">
                            <a href="<?php echo esc_url( $content['image'] ); ?>" class="popup">
                                <div class="featured-image" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>')">
                                    <div class="overlay"></div>
                                    <h3 class="gallery-title"><?php echo esc_html( $content['title'] ); ?></h3>
                                </div><!-- .featured-image -->
                            </a>
                        </div><!-- .grid-item -->
                    <?php endforeach; ?>
                </div><!-- .grid -->

                <?php if ( ! empty($btn_label) && ! empty($btn_url) ): ?>
                    <div class="more-link">
                        <a href="<?php echo esc_url( $btn_url ); ?>" class="btn btn-transparent">
                            <?php echo esc_html( $btn_label ); ?>
                        </a>
                    </div><!-- .more-link -->
                <?php endif ?>

            </div><!-- .section-content -->
        </div><!-- #portfolio -->


    <?php }
endif;