<?php
/**
 * pricing section
 *
 * This is the template for the content of pricing section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_pricing_section' ) ) :
    /**
    * Add pricing section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_pricing_section() {
    	$options = busyness_get_theme_options();
        // Check if pricing is enabled on frontpage
        $pricing_enable = apply_filters( 'busyness_section_status', true, 'pricing_section_enable' );

        if ( true !== $pricing_enable ) {
            return false;
        }
        // Get pricing section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_pricing_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render pricing section now.
        busyness_render_pricing_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_pricing_section_details' ) ) :
    /**
    * pricing section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input pricing section details.
    */
    function busyness_get_pricing_section_details( $input ) {
        $options = busyness_get_theme_options();

        $content = array();

        for ($i=1; $i <= 3 ; $i++) {

            $pricing_post['title']          = ! empty ( $options['pricing_package_title_' . $i ] ) ? $options['pricing_package_title_' . $i ] : '' ;
            $pricing_post['price']          = ! empty ( $options['pricing_package_price_' . $i ] ) ? $options['pricing_package_price_' . $i ] : '' ;
            $pricing_post['period']         = ! empty ( $options['pricing_package_period_' . $i ] ) ? $options['pricing_package_period_' . $i ] : '' ;
            $pricing_post['description']    = ! empty ( $options['pricing_package_content_' . $i ] ) ? $options['pricing_package_content_' . $i ] : '' ;
            $pricing_post['btn']            = ! empty ( $options['pricing_btn_title_' . $i ] ) ? $options['pricing_btn_title_' . $i ] : '' ;
            $pricing_post['url']            = ! empty ( $options['pricing_btn_url_' . $i ] ) ? $options['pricing_btn_url_' . $i ] : '' ;


            array_push( $content, $pricing_post );
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// pricing section content details.
add_filter( 'busyness_filter_pricing_section_details', 'busyness_get_pricing_section_details' );


if ( ! function_exists( 'busyness_render_pricing_section' ) ) :
  /**
   * Start pricing section
   *
   * @return string pricing content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_pricing_section( $content_details = array() ) {
        $options = busyness_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        }
        ?>
            <div id="pricing" class="page-section">
                <div class="wrapper">
                    <div class="section-header">
                        <?php if ( ! empty( $options['pricing_title'] ) ): ?>
                            <h2 class="section-title">
                                <?php echo esc_html( $options['pricing_title'] ) ?>
                            </h2>
                        <?php endif ?>

                        <?php if ( ! empty( $options['pricing_sub_title'] ) ): ?>
                            <p class="section-subtitle">
                                 <?php echo esc_html( $options['pricing_sub_title'] ) ?>
                            </p>
                        <?php endif ?>

                    </div><!-- .section-header -->

                    <div class="section-content col3">
                        <?php foreach ( $content_details as $content ): ?>
                            <article class="hentry">
                                <div class="price-table-wrapper">
                                    <header class="entry-header">
                                        <h2 class="entry-title">
                                            <?php echo esc_html( $content['title'] ) ; ?>
                                        </h2>
                                        <h3 class="price">
                                            <?php echo esc_html( $content['price'] ) ; ?>
                                        </h3>
                                        <span>
                                            <?php echo esc_html( $content['period'] ) ; ?>
                                        </span>
                                    </header>

                                   <div class="entry-content">
                                       <p>
                                            <?php echo esc_html( $content['description'] ) ; ?>
                                       </p>
                                   </div>
                                   <?php if ( ! empty( $content['btn'] ) ): ?>
                                       <div class="more-link">
                                            <a href="<?php echo esc_url( $content['url'] ) ; ?>" class="btn btn-primary">
                                                 <?php echo esc_html( $content['btn'] ) ; ?>
                                            </a>
                                        </div>
                                   <?php endif ?>

                                </div><!-- .price-table-wrapper -->
                            </article>
                        <?php endforeach ?>
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #pricing -->

    <?php }
endif;