<?php
/**
 * Promotion section
 *
 * This is the template for the content of promotion section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_promotion_section' ) ) :
    /**
    * Add promotion section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_promotion_section() {
    	$options = busyness_get_theme_options();
        // Check if promotion is enabled on frontpage
        $promotion_enable = apply_filters( 'busyness_section_status', true, 'promotion_section_enable' );

        if ( true !== $promotion_enable ) {
            return false;
        }
        // Get promotion section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_promotion_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render promotion section now.
        busyness_render_promotion_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_promotion_section_details' ) ) :
    /**
    * promotion section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input promotion section details.
    */
    function busyness_get_promotion_section_details( $input ) {
        $options = busyness_get_theme_options();

        // Content type.
        $promotion_content_type  = $options['promotion_content_type'];

        $content = array();
        switch ( $promotion_content_type ) {

            case 'custom':
                $custom['title']        = ! empty( $options['promotion_title'] ) ? $options['promotion_title'] : '';
                $custom['url']          = ! empty( $options['promotion_btn_link'] ) ? $options['promotion_btn_link'] : '';
                $custom['excerpt']      = ! empty( $options['promotion_description'] ) ? $options['promotion_description'] : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'page':
                $page_id = ! empty( $options['promotion_content_page'] ) ? $options['promotion_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );
            break;

            case 'post':
                $post_id = ! empty( $options['promotion_content_post'] ) ? $options['promotion_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    'ignore_sticky_posts' => true,
                    );
            break;

            default:
            break;
        }

        if ( 'custom' !== $promotion_content_type ) :
            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = busyness_trim_content( 25 );

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
        endif;

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// promotion section content details.
add_filter( 'busyness_filter_promotion_section_details', 'busyness_get_promotion_section_details' );


if ( ! function_exists( 'busyness_render_promotion_section' ) ) :
  /**
   * Start promotion section
   *
   * @return string promotion content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_promotion_section( $content_details = array() ) {
        $options = busyness_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>
        <div id="promotion">
            <div class="wrapper">
                <?php foreach ( $content_details as $content ): ?>
                    <div class="promotion-wrapper">
                       <div class="section-header">
                            <?php if ( ! empty( $content['title'] ) ): ?>
                                <h2 class="section-title">
                                    <?php echo esc_html( $content['title'] ) ; ?>
                                </h2>
                            <?php endif ?>
                            <?php if ( ! empty( $content['excerpt'] ) ): ?>
                                <p class="section-subtitle">
                                    <?php echo esc_html( $content['excerpt'] ) ; ?>
                                </p>
                            <?php endif ?>

                        </div><!-- .section-header -->
                        <?php if ( ! empty( $content['url'] ) ): ?>
                            <div class="section-content">
                                <div class="more-link">
                                    <a href="<?php echo esc_url( $content['url'] ) ; ?>" class="btn btn-primary">
                                        <?php echo esc_html( $options['promotion_btn_title'] ) ; ?>
                                    </a>
                                </div>
                            </div><!-- .section-content -->
                        <?php endif ?>

                    </div><!-- .promotion-wrapper -->
                <?php endforeach ?>
            </div><!-- .wrapper -->
        </div><!-- #promotion -->
    <?php
    }
endif;