<?php
/**
 * Team section
 *
 * This is the template for the content of team section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_team_section' ) ) :
    /**
    * Add team section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_team_section() {
        $options = busyness_get_theme_options();
        // Check if team is enabled on frontpage
        $team_enable = apply_filters( 'busyness_section_status', true, 'team_section_enable' );

        if ( true !== $team_enable ) {
            return false;
        }
        // Get team section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_team_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render team section now.
        busyness_render_team_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_team_section_details' ) ) :
    /**
    * team section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input team section details.
    */
    function busyness_get_team_section_details( $input ) {
        $options = busyness_get_theme_options();

        // Content type.
        $team_content_type  = $options['team_content_type'];
        $team_count = ! empty( $options['team_count'] ) ? $options['team_count'] : 4;

        $content = array();
        switch ( $team_content_type ) {

            case 'custom':
                for ( $i=1; $i <= $options['team_count']; $i++ ) {
                    $custom['title']       = ! empty( $options['team_content_custom_title_' . $i ] ) ? $options['team_content_custom_title_' . $i ] : '';
                    $custom['img']        = ! empty( $options['team_content_custom_image_' . $i ] ) ? $options['team_content_custom_image_' . $i ] : '';
                    $custom['link']        = ! empty( $options['custom_team_url_' . $i ] ) ? $options['custom_team_url_' . $i ] : '';
                    array_push( $content, $custom );
                }

                // Push to the main array.
            break;

            case 'page':
                $page_ids = array();

                for ( $i = 1; $i <= $team_count; $i++ ) {
                    if ( ! empty( $options['team_content_page_' . $i] ) )
                        $page_ids[] = $options['team_content_page_' . $i];
                }

                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $team_count ),
                    'orderby'           => 'post__in',
                    );
            break;

            case 'post':
                $post_ids = array();

                for ( $i = 1; $i <= $team_count; $i++ ) {
                    if ( ! empty( $options['team_content_post_' . $i] ) )
                        $post_ids[] = $options['team_content_post_' . $i];
                }

                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $team_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'category':
                $cat_id = ! empty( $options['team_content_category'] ) ? $options['team_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $team_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );
            break;

            default:
            break;
        }

        if ( 'custom' != $team_content_type ) {
            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['img']   = get_the_post_thumbnail_url( null, 'large' );
                    $page_post['url']       = get_the_permalink();


                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
        }


        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// team section content details.
add_filter( 'busyness_filter_team_section_details', 'busyness_get_team_section_details' );


if ( ! function_exists( 'busyness_render_team_section' ) ) :
  /**
   * Start team section
   *
   * @return string team content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_team_section( $content_details = array() ) {
        $options = busyness_get_theme_options();
        $btn_label = ! empty( $options['team_btn_title'] ) ? $options['team_btn_title'] : '';
        $btn_url = ! empty( $options['team_link'] ) ? $options['team_link'] : '';
        if ( empty( $content_details ) ) {
            return;
        }

        if ( $options['team_count'] > 4 ) {
            $class = 4;
        } else {
            $class= $options['team_count'];
        }
        ?>


            <div id="our-team" class="page-section no-padding-top">
                <div class="wrapper">
                    <div class="team-wrapper clear">
                        <div class="section-header">
                            <?php if ( ! empty( $options['team_title'] ) ) : ?>
                                <h2 class="section-title"><?php echo esc_html( $options['team_title'] ); ?></h2>
                            <?php endif; ?>
                            <?php if ( ! empty( $options['team_sub_title'] ) ) : ?>
                                <p class="section-subtitle"><?php echo wp_kses_post( $options['team_sub_title'] ); ?></p>
                            <?php endif; ?>
                        </div><!-- .section-header -->
                    </div><!-- .team-wrapper -->

                    <div class="section-wrapper col<?php echo absint( $class ); ?>">
                        <?php
                        $i = 1;
                        foreach ( $content_details as $content ) : ?>
                            <article class="hentry">
                                <div class="team-item-wrapper">
                                    <div class="featured-image" style="background-image:url('<?php echo esc_url( $content['img'] ); ?>')">
                                        <a href="<?php echo esc_url( $content['url'] ); ?>" > </a>
                                    </div><!-- .featured-image -->

                                    <div class="entry-container">
                                        <header class="entry-header">
                                            <?php if ( ! empty( $content['title'] ) ) : ?>
                                                <h2 class="entry-title"><a href="<?php echo esc_url( $content['url'] ); ?>"><?php echo esc_html( $content['title'] ); ?></a></h2>
                                            <?php endif;

                                            if ( ! empty( $options['team_content_custom_position_' . $i ] ) ) : ?>
                                                <span class="member-position"><?php echo esc_html( $options['team_content_custom_position_' . $i ] ); ?></span>
                                            <?php endif; ?>
                                        </header>
                                         <div class="social-icons">
                                            <ul>

                                            <?php
                                                $team_socials = ! empty( $options['team_social_' . $i ] ) ? explode( '|', $options['team_social_' . $i ] ) : array();

                                                foreach ( $team_socials as $team_social ) : ?>
                                                    <li>
                                                        <a href="<?php echo esc_url( $team_social ); ?>"><?php echo busyness_return_social_icon( $team_social ); ?></a>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div><!-- .social-icons -->
                                    </div><!-- .entry-container -->
                                </div><!-- .team-item-wrapper -->
                            </article><!-- .hentry -->
                        <?php
                        $i++;
                        endforeach; ?>
                        <?php if ( ! empty( $btn_url ) && ! empty( $btn_label ) ): ?>
                            <div class="more-link">
                                <a href="<?php echo esc_url( $btn_url ); ?>" class="btn">
                                    <?php echo esc_html( $btn_label ); ?>
                                </a>
                            </div><!-- .read-more -->
                        <?php endif ?>
                    </div><!-- .section-wrapper -->
                </div><!-- .wrapper -->
            </div><!-- #our-team -->

    <?php }
endif;