<?php
/**
 * Testimonial section
 *
 * This is the template for the content of testimonial section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_testimonial_section' ) ) :
    /**
    * Add testimonial section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_testimonial_section() {
    	$options = busyness_get_theme_options();
        // Check if testimonial is enabled on frontpage
        $testimonial_enable = apply_filters( 'busyness_section_status', true, 'testimonial_section_enable' );

        if ( true !== $testimonial_enable ) {
            return false;
        }
        // Get testimonial section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_testimonial_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render testimonial section now.
        busyness_render_testimonial_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_testimonial_section_details' ) ) :
    /**
    * testimonial section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input testimonial section details.
    */
    function busyness_get_testimonial_section_details( $input ) {
        $options = busyness_get_theme_options();

        // Content type.
        $testimonial_content_type  = $options['testimonial_content_type'];
        $testimonial_count = ! empty( $options['testimonial_count'] ) ? $options['testimonial_count'] : 3;

        $content = array();
        switch ( $testimonial_content_type ) {

            case 'page':
                $page_ids = array();
                $position = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_page_' . $i] ) ) :
                        $page_ids[] = $options['testimonial_content_page_' . $i];
                        $position[] = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';
                    endif;
                }

                $args = array(
                    'post_type'         => 'page',
                    'post__in'          => ( array ) $page_ids,
                    'posts_per_page'    => absint( $testimonial_count ),
                    'orderby'           => 'post__in',
                    );
            break;

            case 'post':
                $post_ids = array();
                $position = array();

                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    if ( ! empty( $options['testimonial_content_post_' . $i] ) ) :
                        $post_ids[] = $options['testimonial_content_post_' . $i];
                        $position[] = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';
                    endif;
                }

                $args = array(
                    'post_type'         => 'post',
                    'post__in'          => ( array ) $post_ids,
                    'posts_per_page'    => absint( $testimonial_count ),
                    'orderby'           => 'post__in',
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'category':
                $cat_id = ! empty( $options['testimonial_content_category'] ) ? $options['testimonial_content_category'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'posts_per_page'    => absint( $testimonial_count ),
                    'cat'               => absint( $cat_id ),
                    'ignore_sticky_posts'   => true,
                    );
            break;

            case 'custom':
                for ( $i = 1; $i <= $testimonial_count; $i++ ) {
                    $custom['title']        = ! empty( $options['testimonial_title_' . $i] ) ? $options['testimonial_title_' . $i] : '';
                    $custom['excerpt']      = ! empty( $options['testimonial_description_' . $i] ) ? $options['testimonial_description_' . $i] : '';
                    $custom['image']        = ! empty( $options['testimonial_image_' . $i] ) ? $options['testimonial_image_' . $i] : '';
                    $custom['url']          = ! empty( $options['testimonial_link_' . $i] ) ? $options['testimonial_link_' . $i] : '';
                    $custom['position']     = ! empty( $options['testimonial_position_' . $i] ) ? $options['testimonial_position_' . $i] : '';


                    // Push to the main array.
                    array_push( $content, $custom );
                }
            break;


            default:
            break;
        }

        if ( 'custom' !== $testimonial_content_type ) {
            // Run The Loop.
            $query = new WP_Query( $args );
            $i = 0;
            if ( $query->have_posts() ) :
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['position']  = ( 'category' !== $testimonial_content_type && ! empty( $position[$i] ) ) ? $position[$i] : '';
                    $page_post['url']       = get_the_permalink();
                    $page_post['excerpt']   = busyness_trim_content( 20 );
                    $page_post['image']  	= has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'thumbnail' ) : '';

                    // Push to the main array.
                    array_push( $content, $page_post );
                    $i++;
                endwhile;
            endif;
            wp_reset_postdata();
        }

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// testimonial section content details.
add_filter( 'busyness_filter_testimonial_section_details', 'busyness_get_testimonial_section_details' );


if ( ! function_exists( 'busyness_render_testimonial_section' ) ) :
  /**
   * Start testimonial section
   *
   * @return string testimonial content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_testimonial_section( $content_details = array() ) {
        $options = busyness_get_theme_options();
        if ( empty( $content_details ) ) {
            return;
        } ?>

        <div id="testimonial-slider-section" class="relative page-section">
            <div class="wrapper">
                <div class="section-header">
                    <?php if ( ! empty( $options['testimonial_title'] ) ) : ?>
                        <h2 class="section-title"><?php echo esc_html( $options['testimonial_title'] ); ?></h2>
                    <?php endif; ?>
                    <?php if ( ! empty( $options['testimonial_sub_title'] ) ) : ?>
                        <p class="section-subtitle"><?php echo esc_html( $options['testimonial_sub_title'] ); ?></p>
                    <?php endif; ?>
                </div><!-- .section-header -->

                <div class="testimonial-wrapper">
                    <div class="testimonial-slider" data-slick='{"slidesToShow": 3, "slidesToScroll": 1, "infinite": true, "speed": 1500, "dots": true, "arrows":false, "autoplay": true, "draggable": true, "centerMode": true, "focusOnSelect": true, "fade": false }'>
                        <?php foreach ( $content_details as $content ) : ?>
                            <article>
                                <div class="title-warpper">
                                    <?php if ( ! empty( $content['excerpt'] ) ) : ?>
                                        <div class="entry-content">
                                            <p><?php echo wp_kses_post( $content['excerpt'] ) ;?></p>
                                        </div><!-- .entry-content -->
                                    <?php endif; ?>
                                </div>

                                <div class="author-title">
                                    <?php if ( ! empty( $content['image'] ) ) : ?>
                                        <a href="<?php echo esc_url( $content['url'] ); ?>"><img src="<?php echo esc_url( $content['image'] ); ?>" alt="<?php echo esc_attr( $content['title'] ); ?>"></a>
                                    <?php endif;

                                         if ( ! empty( $content['title'] ) ) : ?>
                                            <h3><?php echo esc_html( $content['title'] ); ?></h3>
                                        <?php endif;

                                        if ( ! empty( $content['position'] ) ) : ?>
                                            <p ><?php echo esc_html( $content['position'] ); ?></p>
                                        <?php endif; ?>

                                </div><!-- .title-wrapper -->
                            </article>
                        <?php endforeach; ?>

                    </div><!-- .testimonial-slider -->
                </div><!-- .wrapper -->
            </div><!-- .wrapper -->
        </div><!-- #testimonial-slider-section -->

    <?php }
endif;