<?php
/**
 * Video section
 *
 * This is the template for the content of video section
 *
 * @package Busyness
 */

if ( ! function_exists( 'busyness_add_video_section' ) ) :
    /**
    * Add video section
    *
    *@since Busyness Pro 1.0.0
    */
    function busyness_add_video_section() {
    	$options = busyness_get_theme_options();
        // Check if video is enabled on frontpage
        $video_enable = apply_filters( 'busyness_section_status', true, 'video_section_enable' );

        if ( true !== $video_enable ) {
            return false;
        }
        // Get video section details
        $section_details = array();
        $section_details = apply_filters( 'busyness_filter_video_section_details', $section_details );

        if ( empty( $section_details ) ) {
            return;
        }

        // Render video section now.
        busyness_render_video_section( $section_details );
    }
endif;

if ( ! function_exists( 'busyness_get_video_section_details' ) ) :
    /**
    * video section details.
    *
    * @since Busyness Pro 1.0.0
    * @param array $input video section details.
    */
    function busyness_get_video_section_details( $input ) {
        $options = busyness_get_theme_options();

        // Content type.
        $video_content_type  = $options['video_content_type'];

        $content = array();
        switch ( $video_content_type ) {

            case 'custom':
                $custom['title']        = ! empty( $options['video_title'] ) ? $options['video_title'] : '';
                $custom['image']        = ! empty( $options['video_image'] ) ? $options['video_image'] : '';

                // Push to the main array.
                array_push( $content, $custom );
            break;

            case 'page':
                $page_id = ! empty( $options['video_content_page'] ) ? $options['video_content_page'] : '';
                $args = array(
                    'post_type'         => 'page',
                    'page_id'           => $page_id,
                    'posts_per_page'    => 1,
                    );
            break;

            case 'post':
                $post_id = ! empty( $options['video_content_post'] ) ? $options['video_content_post'] : '';
                $args = array(
                    'post_type'         => 'post',
                    'p'                 => $post_id,
                    'posts_per_page'    => 1,
                    'ignore_sticky_posts' => true,
                    );
            break;

            default:
            break;
        }

        if ( 'custom' !== $video_content_type ) :
            // Run The Loop.
            $query = new WP_Query( $args );
            if ( $query->have_posts() ) :
                while ( $query->have_posts() ) : $query->the_post();
                    $page_post['title']     = get_the_title();
                    $page_post['image']     = has_post_thumbnail() ? get_the_post_thumbnail_url( get_the_id(), 'full' ) : '';

                    // Push to the main array.
                    array_push( $content, $page_post );
                endwhile;
            endif;
            wp_reset_postdata();
        endif;

        if ( ! empty( $content ) ) {
            $input = $content;
        }
        return $input;
    }
endif;
// video section content details.
add_filter( 'busyness_filter_video_section_details', 'busyness_get_video_section_details' );


if ( ! function_exists( 'busyness_render_video_section' ) ) :
  /**
   * Start video section
   *
   * @return string video content
   * @since Busyness Pro 1.0.0
   *
   */
   function busyness_render_video_section( $content_details = array() ) {
        $options = busyness_get_theme_options();

        if ( empty( $content_details ) ) {
            return;
        } ?>

        <?php foreach ( $content_details as $content ) : ?>
            <div id="video" style="background-image: url('<?php echo esc_url( $content['image'] ); ?>');">
                <div class="wrapper">
                    <?php if ( ! empty( $content['title'] ) ) : ?>
                        <div class="section-header">
                            <h2 class="section-title"><?php echo esc_html( $content['title'] ); ?></h2>
                        </div><!-- .section-header -->
                    <?php endif; ?>

                    <div class="section-content">
                        <div class="icon-play">
                            <?php if ( ! empty( $options['video_link'] ) && ! empty( $options['video_btn_title'] ) ) : ?>
                                <a href="<?php echo esc_url( $options['video_link'] ); ?>" class="video-link">
                                    <?php
                                        echo busyness_get_svg( array( 'icon' => 'play' ) );
                                    ?>
                                </a>
                                <?php if ( ! empty( $options['video_btn_title'] ) ) : ?>
                                    <span> <?php echo esc_html( $options['video_btn_title'] ); ?> </span>
                                <?php endif;
                            endif; ?>
                        </div><!-- .icon-play -->
                    </div><!-- .section-content -->
                </div><!-- .wrapper -->
            </div><!-- #video -->
        <?php if ( ! empty( $options['video_link'] ) && ! empty( $options['video_btn_title'] ) ) : ?>
            <div class="video-overlay"></div>
            <div class="video-popup">
                <div class="widget widget_media_video">
                    <?php echo do_shortcode( '[video src="' . esc_url( $options['video_link'] ) . '"]' ); ?>
                </div>
            </div><!-- .popup -->
        <?php endif; ?>
    <?php endforeach;
    }
endif;