<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Busyness
 */

$options = busyness_get_theme_options();
$theme_version = $options['theme_version'];
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'clear' ); ?>>
	<?php
	if ( 'knowledge-version' != $theme_version ) : ?>
		<div class="entry-meta">
	        <?php if ( ! $options['single_post_hide_author'] ) :
	            echo busyness_author( get_the_author_meta( 'ID' ) );
	        endif;


			busyness_single_categories();
			busyness_entry_footer();
			?>
	    </div><!-- .entry-meta -->
	<?php
	endif; ?>

    <div class="entry-content">
        <?php
			the_content( sprintf(
				/* translators: %s: Name of current post. */
				wp_kses( __( 'Continue reading %s <span class="meta-nav">&rarr;</span>', 'busyness-pro' ), array( 'span' => array( 'class' => array() ) ) ),
				the_title( '<span class="screen-reader-text">"', '"</span>', false )
			) );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'busyness-pro' ),
				'after'  => '</div>',
			) );
		?>
    </div><!-- .entry-content -->

    <?php
    if ( 'knowledge-version' === $theme_version ) :
    	busyness_entry_footer();
    endif; ?>

</article><!-- #post-## -->
