<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Busyness
 */

$options = busyness_get_theme_options();
$class = has_post_thumbnail() ? '' : 'no-post-thumbnail';
$readmore = ! empty( $options['read_more_text'] ) ? $options['read_more_text'] : esc_html__( 'Read More', 'busyness-pro' );
$theme_version = $options['theme_version'];
?>

<article class="hentry" id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>
    <div class="blog-wrapper">
        <?php if ( has_post_thumbnail() ) : ?>
            <div class="featured-image">
                <a href="<?php the_permalink(); ?>">
                    <img src="<?php the_post_thumbnail_url( ); ?>" alt="post-image">
                </a>
                <?php
                if ( ! $options['hide_date'] && 'knowledge-version' === $theme_version ) :
                    echo '<div class="entry-meta">';
                    busyness_posted_on();
                    knowledge_posted_by();
                    echo '</div><!-- .entry-meta -->';
                endif;
                ?>
            </div><!-- .featured-image -->
        <?php endif; ?>

        <div class="entry-container">
            <?php
            if ( ! $options['hide_date'] && 'knowledge-version' != $theme_version) :
                echo '<div class="entry-meta">';
                    busyness_posted_on();
                echo '</div><!-- .entry-meta -->';
            endif;
            ?>

            <header class="entry-header">
                <h2 class="entry-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h2>
                <?php
                if ( ! $options['hide_date'] && $class == "no-post-thumbnail" && 'knowledge-version' === $theme_version ) :
                    echo '<div class="entry-meta">';
                    busyness_posted_on();
                    echo '</div><!-- .entry-meta -->';
                endif;
                ?>
            </header>

            <div class="entry-content">
                <?php the_excerpt(); ?>
            </div><!-- .entry-content -->

            <?php
            if ( 'knowledge-version' === $theme_version ) :
                echo '<footer class="entry-footer">';
                    knowledge_archive_categories();
                    knowledge_edit_link();
                echo '</footer>';
            else :
                if ( ! $options['hide_category'] ) : ?>
                    <span class="cat-links">
                        <?php the_category(); ?>
                    </span><!-- .cat-links -->
                <?php endif;
            endif;
            ?>
        </div><!-- .entry-container -->
    </div><!-- .post-item-wrapper -->
</article><!-- #post-## -->
