<?php

/**
 * Include WEN Customizer
 */
require trailingslashit(get_template_directory()) . 'wen-customizer/init.php';

/**
 * Init customizer
 */
require trailingslashit(get_template_directory()) . 'inc/init.php';


/**
 * WEN Business functions and definitions
 *
 * @package WEN Business
 */

/**
 * Set the content width based on the theme's design and stylesheet.
 */
if (! isset($content_width)) {
  $content_width = 1140; /* pixels */
}

if (! function_exists('wen_business_setup')) :
  /**
   * Sets up theme defaults and registers support for various WordPress features.
   *
   * Note that this function is hooked into the after_setup_theme hook, which
   * runs before the init hook. The init hook is too late for some features, such
   * as indicating support for post thumbnails.
   */
  function wen_business_setup()
  {

    /*
	 * Make theme available for translation.
	 * Translations can be filed in the /languages/ directory.
	 * If you're building a theme based on WEN Business, use a find and replace
	 * to change 'wen-business-pro' to the name of your theme in all the template files
	 */
    load_theme_textdomain('wen-business-pro', get_template_directory() . '/languages');

    // Add default posts and comments RSS feed links to head.
    add_theme_support('automatic-feed-links');

    /*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
    add_theme_support('title-tag');

    /*
	 * Enable support for custom logo.
	 */
    add_theme_support('custom-logo', array(
      'width'       => 200,
      'flex-height' => true,
    ));

    /*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link http://codex.wordpress.org/Function_Reference/add_theme_support#Post_Thumbnails
	 */
    add_theme_support('post-thumbnails');

    // Register image size for featured slider
    add_image_size('wen-business-slider', 1600, 440, true);

    // This theme uses wp_nav_menu() in one location.
    register_nav_menus(array(
      'primary'   => __('Primary Menu', 'wen-business-pro'),
      'secondary' => __('Secondary Menu', 'wen-business-pro'),
      'mobile'    => __('Mobile Menu', 'wen-business-pro'),
      'footer'    => __('Footer Menu', 'wen-business-pro'),
      'social'    => __('Social Menu', 'wen-business-pro'),
      'notfound'  => __('404 Menu', 'wen-business-pro'),
    ));

    /*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
    add_theme_support('html5', array(
      'search-form',
      'comment-form',
      'comment-list',
      'gallery',
      'caption',
    ));

    /**
     * Enable support for footer widgets
     */
    add_theme_support('footer-widgets', 4);

    // Load default block styles.
    add_theme_support('wp-block-styles');

    // Add support for responsive embeds.
    add_theme_support('responsive-embeds');

    /**
     * Enable support for theme shortcodes
     */
    add_theme_support('theme-shortcodes');

    /**
     * Enable support for WooCommerce
     */
    add_theme_support('woocommerce');
    add_theme_support('wc-product-gallery-lightbox');

    /*
	 * Enable support for Post Formats.
	 * See http://codex.wordpress.org/Post_Formats
	 */
    add_theme_support('post-formats', array(
      'aside',
      'image',
      'video',
      'quote',
      'link',
    ));

    // Set up the WordPress core custom background feature.
    add_theme_support('custom-background', apply_filters('wen_business_custom_background_args', array(
      'default-color' => '',
      'default-image' => '',
    )));

    // Include supports
    require get_template_directory() . '/inc/supports.php';
  }

endif; // wen_business_setup

add_action('after_setup_theme', 'wen_business_setup');

/**
 * Register widget area.
 *
 * @link http://codex.wordpress.org/Function_Reference/register_sidebar
 */
function wen_business_widgets_init()
{
  register_sidebar(array(
    'name'          => __('Primary Sidebar', 'wen-business-pro'),
    'id'            => 'sidebar-1',
    'description'   => __('Widgets to show in Primary Sidebar', 'wen-business-pro'),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ));
  register_sidebar(array(
    'name'          => __('Secondary Sidebar', 'wen-business-pro'),
    'id'            => 'sidebar-2',
    'description'   => __('Widgets to show in Secondary Sidebar', 'wen-business-pro'),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ));
  register_sidebar(array(
    'name'          => __('Front Page Widget Area', 'wen-business-pro'),
    'id'            => 'sidebar-front-page-widget-area',
    'description'   => __('Widgets to show in Front Page', 'wen-business-pro'),
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title"><span>',
    'after_title'   => '</span></h3>',
  ));
  register_sidebar(array(
    'name'          => __('Contact Sidebar', 'wen-business-pro'),
    'description'   => __('Widgets to show in Contact Page Template', 'wen-business-pro'),
    'id'            => 'sidebar-contact',
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ));
  register_sidebar(array(
    'name'          => __('404 Sidebar', 'wen-business-pro'),
    'description'   => __('Widgets to show in 404 error page', 'wen-business-pro'),
    'id'            => 'sidebar-notfound',
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ));
  register_sidebar(array(
    'name'          => __('Extra Sidebar 1', 'wen-business-pro'),
    'id'            => 'extra-sidebar-1',
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ));
  register_sidebar(array(
    'name'          => __('Extra Sidebar 2', 'wen-business-pro'),
    'id'            => 'extra-sidebar-2',
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ));
  register_sidebar(array(
    'name'          => __('Extra Sidebar 3', 'wen-business-pro'),
    'id'            => 'extra-sidebar-3',
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ));
  register_sidebar(array(
    'name'          => __('Extra Sidebar 4', 'wen-business-pro'),
    'id'            => 'extra-sidebar-4',
    'before_widget' => '<aside id="%1$s" class="widget %2$s">',
    'after_widget'  => '</aside>',
    'before_title'  => '<h3 class="widget-title">',
    'after_title'   => '</h3>',
  ));
}
add_action('widgets_init', 'wen_business_widgets_init');

/**
 * Enqueue scripts and styles.
 */
function wen_business_scripts()
{

  $theme_version = wp_get_theme()->get('Version');

  $min = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
  // Font Awesome
  wp_enqueue_style('wen-business-fontawesome', trailingslashit(esc_url(get_template_directory_uri())) . 'third-party/font-awesome/css/font-awesome' . $min . '.css', '', '6.7.2');

  wp_enqueue_style('wen-business-google-fonts', wen_business_fonts_url(), array(), null);

  wp_enqueue_style('wen-business-style', get_stylesheet_uri(), array(), $theme_version);

  wp_enqueue_script('wen-business-placeholder', get_template_directory_uri() . '/assets/js/jquery.placeholder.min.js', array('jquery'), '2.1.1', true);

  wp_enqueue_style('wen-business-mmenu-style', get_template_directory_uri() . '/third-party/mmenu/css/jquery.mmenu.min.css', '', '4.7.5');

  wp_enqueue_style('wen-business-responsive-style', get_template_directory_uri() . '/assets/css/responsive.css', '', '1.0.0');

  wp_enqueue_script('wen-business-navigation', get_template_directory_uri() . '/assets/js/navigation.min.js', array(), '20120206', true);

  wp_enqueue_script('wen-business-skip-link-focus-fix', get_template_directory_uri() . '/assets/js/skip-link-focus-fix.min.js', array(), '20130115', true);

  wp_enqueue_script('wen-business-cycle2-script', get_template_directory_uri() . '/third-party/cycle2/js/jquery.cycle2.min.js', array('jquery'), '2.1.6', true);

  wp_enqueue_script('wen-business-mmenu-script', get_template_directory_uri() . '/third-party/mmenu/js/jquery.mmenu.min.js', array('jquery'), '4.7.5', true);

  wp_enqueue_script('wen-business-custom-js', get_template_directory_uri() . '/assets/js/custom.min.js', array('jquery'), '1.0.0', true);


  if (is_singular() && comments_open() && get_option('thread_comments')) {
    wp_enqueue_script('comment-reply');
  }
}
add_action('wp_enqueue_scripts', 'wen_business_scripts');

if (! function_exists('wen_business_blocks_support')) :
  /**
   * Create add default blocks support
   */
  function wen_business_blocks_support()
  {
    // Add support for Block Styles.
    add_theme_support('wp-block-styles');

    // Add support for full and wide align images.
    add_theme_support('align-wide');

    // Add support for editor styles.
    add_theme_support('editor-styles');

    // Add support for responsive embeds.
    add_theme_support('responsive-embeds');

    // Add custom editor font sizes.
    add_theme_support(
      'editor-font-sizes',
      array(
        array(
          'name'      => esc_html__('Small', 'wen-business-pro'),
          'shortName' => esc_html__('S', 'wen-business-pro'),
          'size'      => 14,
          'slug'      => 'small',
        ),
        array(
          'name'      => esc_html__('Normal', 'wen-business-pro'),
          'shortName' => esc_html__('M', 'wen-business-pro'),
          'size'      => 18,
          'slug'      => 'normal',
        ),
        array(
          'name'      => esc_html__('Large', 'wen-business-pro'),
          'shortName' => esc_html__('L', 'wen-business-pro'),
          'size'      => 42,
          'slug'      => 'large',
        ),
        array(
          'name'      => esc_html__('Huge', 'wen-business-pro'),
          'shortName' => esc_html__('XL', 'wen-business-pro'),
          'size'      => 54,
          'slug'      => 'huge',
        ),
      )
    );

    // Add support for custom color scheme.
    add_theme_support('editor-color-palette', array(
      array(
        'name'  => esc_html__('White', 'wen-business-pro'),
        'slug'  => 'white',
        'color' => '#ffffff',
      ),
      array(
        'name'  => esc_html__('Black', 'wen-business-pro'),
        'slug'  => 'black',
        'color' => '#111111',
      ),
      array(
        'name'  => esc_html__('Gray', 'wen-business-pro'),
        'slug'  => 'gray',
        'color' => '#f4f4f4',
      ),
      array(
        'name'  => esc_html__('Blue', 'wen-business-pro'),
        'slug'  => 'blue',
        'color' => '#209fcc',
      ),
      array(
        'name'  => esc_html__('Orange', 'wen-business-pro'),
        'slug'  => 'orange',
        'color' => '#ffc300',
      ),
    ));
  }
  add_action('after_setup_theme', 'wen_business_blocks_support', 20);
endif; //wen_business_blocks_support

if (! function_exists('wen_business_add_blocks_style')) :
  /**
   * Add Blocks Style
   */
  function wen_business_add_blocks_style()
  {
    // Theme block stylesheet.
    wp_enqueue_style('wen-business-block-style', get_theme_file_uri('/assets/css/blocks.css'), array('wen-business-style'), date('Ymd-Gis', filemtime(get_template_directory() . '/assets/css/blocks.css')));
  }
  add_action('wp_enqueue_scripts', 'wen_business_add_blocks_style');
endif; //wen_business_add_blocks_style

if (! function_exists('wen_business_block_editor_styles')) :
  /**
   * Enqueue editor styles for Blocks
   */
  function wen_business_block_editor_styles()
  {
    // Block styles.
    wp_enqueue_style('wen-business-block-editor-style', get_theme_file_uri('/assets/css/editor-blocks.css'), null, date('Ymd-Gis', filemtime(get_template_directory() . '/assets/css/editor-blocks.css')));

    // Add custom fonts.
    wp_enqueue_style('wen-business-fonts', wen_business_fonts_url(), array(), null);
  }
  add_action('enqueue_block_editor_assets', 'wen_business_block_editor_styles');
endif; //wen_business_block_editor_styles

/**
 * Enqueue admin scripts and styles.
 */
function wen_business_admin_scripts($hook)
{

  if ('widgets.php' == $hook) {
    wp_enqueue_media();
    wp_enqueue_script('wen-business-widgets-script', get_template_directory_uri() . '/assets/js/widgets.js', array('jquery'), '1.0.0');
  }
}
add_action('admin_enqueue_scripts', 'wen_business_admin_scripts');

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Custom functions that act independently of the theme templates.
 */
require get_template_directory() . '/inc/extras.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
require get_template_directory() . '/inc/jetpack.php';

/**
 * Load theme updater functions.
 */
function wen_business_theme_updater()
{
  if (is_admin()) {
    require_once get_template_directory() . '/updater/theme-updater.php';
  }
}

add_action('after_setup_theme', 'wen_business_theme_updater');
