<?php

/**
 * Get theme option
 *
 * @since  WEN Business 1.0
 */
if ( ! function_exists( 'wen_business_get_option' ) ) :

  function wen_business_get_option( $key = '' ){

    $defaults = wen_business_get_default_theme_options();
    if ( empty( $key ) ) {
      return;
    }

    $default = ( isset( $defaults[ $key ] ) ) ? $defaults[ $key ] : '';
    $theme_options = get_theme_mod( 'theme_options', $defaults );
    $theme_options = array_merge( $defaults, $theme_options );
    $value = '';
    if ( isset( $theme_options[ $key ] ) ) {
      $value = $theme_options[ $key ];
    }
    return $value;

  }

endif; // wen_business_get_option

/**
 * Get theme option
 *
 * @since  WEN Business 1.0
 */
if ( ! function_exists( 'wen_business_get_options' ) ) :

  function wen_business_get_options() {

    $value = array();

    $value = get_theme_mod( 'theme_options' );

    return $value;

  }

endif;


/**
 * Returns excerpt.
 *
 * @since WEN Business 1.0
 */
if ( ! function_exists( 'wen_business_the_excerpt' ) ) :

  function wen_business_the_excerpt( $length = 40, $post_obj = null ) {

    global $post;
    if ( is_null( $post_obj ) ) {
      $post_obj = $post;
    }
    $length = absint( $length );
    if ( $length < 1 ) {
      $length = 40;
    }
    $source_content = $post_obj->post_content;
    if ( ! empty( $post_obj->post_excerpt ) ) {
      $source_content = $post_obj->post_excerpt;
    }
    $source_content = preg_replace( '`\[[^\]]*\]`', '', $source_content );
    $trimmed_content = wp_trim_words( $source_content, $length, '...' );
    return $trimmed_content;

  }

endif;


if ( ! function_exists( 'wen_business_content_class' ) ) :

  /**
   * Print content class.
   *
   * @since WEN Business 1.0
   */
  function wen_business_content_class( $class = '' ){

    $classes = array();
    if ( ! empty( $class ) ) {
      if ( !is_array( $class ) )
        $class = preg_split( '#\s+#', $class );
      $classes = array_merge( $classes, $class );
    } else {
      // Ensure that we always coerce class to being an array.
      $class = array();
    }

    $classes = array_map( 'esc_attr', $classes );
    $classes = apply_filters( 'wen_business_filter_content_class', $classes, $class );
    echo ' class="' . join( ' ', $classes ) . '" ';

  }

endif;

if ( ! function_exists( 'wen_business_sidebar_primary_class' ) ) :

  /**
   * Print sidebar primary class.
   *
   * @since WEN Business 1.0
   */
  function wen_business_sidebar_primary_class( $class = '' ){

    $classes = array();
    if ( ! empty( $class ) ) {
      if ( !is_array( $class ) )
        $class = preg_split( '#\s+#', $class );
      $classes = array_merge( $classes, $class );
    } else {
      // Ensure that we always coerce class to being an array.
      $class = array();
    }

    $classes = array_map( 'esc_attr', $classes );
    $classes = apply_filters( 'wen_business_filter_sidebar_primary_class', $classes, $class );
    echo ' class="' . join( ' ', $classes ) . '" ';

  }

endif;

if ( ! function_exists( 'wen_business_sidebar_secondary_class' ) ) :

  /**
   * Print sidebar secondary class.
   *
   * @since WEN Business 1.0
   */
  function wen_business_sidebar_secondary_class( $class = '' ){

    $classes = array();
    if ( ! empty( $class ) ) {
      if ( !is_array( $class ) )
        $class = preg_split( '#\s+#', $class );
      $classes = array_merge( $classes, $class );
    } else {
      // Ensure that we always coerce class to being an array.
      $class = array();
    }

    $classes = array_map( 'esc_attr', $classes );
    $classes = apply_filters( 'wen_business_filter_sidebar_secondary_class', $classes, $class );
    echo ' class="' . join( ' ', $classes ) . '" ';

  }

endif;
