<?php
/**
 * WEN Business Theme Customizer
 *
 * @package WEN Business
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function wen_business_customize_register( $wp_customize ) {

  $wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
  $wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
  $wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

  // Remove default Colors section
  $wp_customize->remove_section( 'colors' );

}
add_action( 'customize_register', 'wen_business_customize_register' );

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function wen_business_customize_preview_js() {
	wp_enqueue_script( 'wen_business_customizer', get_template_directory_uri() . '/assets/js/customizer.js', array( 'customize-preview' ), '20130508', true );
}
add_action( 'customize_preview_init', 'wen_business_customize_preview_js' );

if( ! function_exists( 'wen_business_customize_nav_fix' ) ) :

  /**
   * Fix for menu options.
   *
   * @since  WEN Business 1.0
   */
  function wen_business_customize_nav_fix( $wp_customize ) {

    // Move extra menu options to Menus panel.
    $wp_customize->get_section( 'section_menu' )->panel = 'nav_menus';
    $wp_customize->get_section( 'section_menu' )->priority = 2;

  }
endif;
add_action( 'customize_register', 'wen_business_customize_nav_fix', 20 );
