<?php

add_filter( 'wen_business_theme_options_args', 'wen_business_color_theme_options_args' );


/**
 * Add featured color options.
 *
 * @since  WEN Business 1.0
 */

if( ! function_exists( 'wen_business_color_theme_options_args' ) ):

  function wen_business_color_theme_options_args( $args ){

    // Create panel
    $args['panels']['color_settings_panel']['title'] = __( 'Color Settings', 'wen-business-pro' );

    $color_sections = wen_business_get_color_sections_options();
    $color_fields   = wen_business_get_color_theme_settings_options();

    // Add sections
    $pr = 1;
    foreach ($color_sections as $section_id => $section ) {

      $args['panels']['color_settings_panel']['sections'][ $section_id ] = array(
        'title'             => $section['label'],
        'priority'          => $pr,
        'sanitize_callback' => 'sanitize_hex_color',
      );

      $pr++;

    } //end foreach $color_section

    // Add color fields
    foreach ( $color_fields as $field_id => $field ) {
      $args['panels']['color_settings_panel']['sections'][ $field['section'] ]['fields'][ $field_id] = array(
          'title' => $field['label'],
          'type'  => 'color',
        );
    } //end foreach $color_fields

    return $args;

  }

endif;
