<?php

add_action( 'customize_register', 'wen_business_customize_custom_header_fields' );

if( ! function_exists( 'wen_business_customize_custom_header_fields' ) ):

  /**
   * Add Custom Header fields.
   *
   * @since  WEN Business 1.0
   */
  function wen_business_customize_custom_header_fields( $wp_customize ) {

    $default = wen_business_get_default_theme_options();

    // ch_status
    $wp_customize->add_setting( 'theme_options[ch_status]', array(
      'default'           => $default['ch_status'],
      'capability'        => 'edit_theme_options',
      'sanitize_callback' => 'wen_business_sanitize_select',
    ));
    $wp_customize->add_control( 'theme_options[ch_status]', array(
        'label'    => __( 'Enable Header Image', 'wen-business-pro' ),
        'type'     => 'select',
        'section'  => 'header_image',
        'settings' => 'theme_options[ch_status]',
        'choices'  => wen_business_get_custom_header_status_options(),
    ));

    // ch_image_alt
    $wp_customize->add_setting( 'theme_options[ch_image_alt]', array(
      'default'           => $default['ch_image_alt'],
      'capability'        => 'edit_theme_options',
      'sanitize_callback' => 'esc_attr',
    ));
    $wp_customize->add_control( 'theme_options[ch_image_alt]', array(
        'label'    => __( 'Alt Text', 'wen-business-pro' ),
        'type'     => 'url',
        'section'  => 'header_image',
        'settings' => 'theme_options[ch_image_alt]',
    ));

    // ch_link_url
    $wp_customize->add_setting( 'theme_options[ch_link_url]', array(
      'default'           => $default['ch_link_url'],
      'capability'        => 'edit_theme_options',
      'sanitize_callback' => 'esc_url_raw',
    ));
    $wp_customize->add_control( 'theme_options[ch_link_url]', array(
        'label'    => __( 'Link URL', 'wen-business-pro' ),
        'type'     => 'url',
        'section'  => 'header_image',
        'settings' => 'theme_options[ch_link_url]',
    ));

    // ch_link_url_open
    $wp_customize->add_setting( 'theme_options[ch_link_url_open]', array(
      'default'           => $default['ch_link_url_open'],
      'capability'        => 'edit_theme_options',
      'sanitize_callback' => 'wen_business_sanitize_checkbox',
    ));
    $wp_customize->add_control( 'theme_options[ch_link_url_open]', array(
        'label'    => __( 'Open Link in New Window', 'wen-business-pro' ),
        'type'     => 'checkbox',
        'section'  => 'header_image',
        'settings' => 'theme_options[ch_link_url_open]',
    ));

  }

endif;

