<?php

add_action( 'customize_register', 'wen_business_customize_reset_all_settings' );

if( ! function_exists( 'wen_business_customize_reset_all_settings' ) ):

  /**
   * Add Reset all settings section.
   *
   * @since  WEN Business 1.0
   */
  function wen_business_customize_reset_all_settings( $wp_customize ) {

    $wp_customize->add_section( 'section_reset_all_settings', array(
      'title'       => __( 'Reset All Theme Settings', 'wen-business-pro' ),
      'description' => __( 'Caution: All theme settings will be reset to default. Refresh the page after save to view full effects.', 'wen-business-pro' ),
      'priority'    => 200,
    ));
    $wp_customize->add_setting( 'theme_options[reset_all_settings]', array(
      'default'           => false,
      'capability'        => 'edit_theme_options',
      'transport'         => 'postMessage',
      'sanitize_callback' => 'wen_business_sanitize_checkbox',
    ));
    $wp_customize->add_control( 'reset_all_settings', array(
        'label'    => __( 'Check to reset all settings', 'wen-business-pro' ),
        'type'     => 'checkbox',
        'section'  => 'section_reset_all_settings',
        'settings' => 'theme_options[reset_all_settings]',
    ));

  }

endif;

