<?php

add_filter( 'wen_business_theme_options_args', 'wen_business_setting_theme_options_args' );


if( ! function_exists( 'wen_business_setting_theme_options_args' ) ):

  /**
   * Add settings options.
   *
   * @since  WEN Business 1.0
   */
  function wen_business_setting_theme_options_args( $args ){

    // Home Section
    $args['panels']['theme_option_panel']['sections']['section_home_page'] = array(
      'title'    => __( 'Home Page Options', 'wen-business-pro' ),
      'priority' => 30,
      'fields'   => array(
        'show_page_content_in_site_front' => array(
          'title'             => __( 'Check to show page content in site front', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
      )
    );

    // Header Section
    $args['panels']['theme_option_panel']['sections']['section_header'] = array(
      'title'    => __( 'Header Options', 'wen-business-pro' ),
      'priority' => 40,
      'fields'   => array(
        'move_logo_after_title' => array(
          'title'             => __( 'Move Logo After Title/Tagline', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'show_title' => array(
          'title'             => __( 'Show Site Title', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'show_tagline' => array(
          'title'             => __( 'Show Tagline', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'show_tagline_separator' => array(
          'title'             => __( 'Show Separator between Title and Tagline', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'move_tagline_below_title' => array(
          'title'             => __( 'Move Tagline Below Title', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'social_in_header' => array(
          'title'             => __( 'Show Social Icons', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'search_in_header' => array(
          'title'             => __( 'Show Search Icons', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'header_icon_size' => array(
          'title'             => __( 'Icon Size in Header Top', 'wen-business-pro' ),
          'description'       => __( 'in px. Size must be 5-20 px', 'wen-business-pro' ),
          'type'              => 'number',
          'sanitize_callback' => 'wen_business_sanitize_number_range',
          'input_attrs'       => array(
                                  'min'   => 5,
                                  'max'   => 20,
                                  'style' => 'width: 55px;'
                                ),
        ),
      )
    );

    // Menu Section
    $args['panels']['theme_option_panel']['sections']['section_menu'] = array(
      'title'    => __( 'Menu Options', 'wen-business-pro' ),
      'priority' => 63,
      'fields'   => array(
        'disable_primary_menu' => array(
          'title'             => __( 'Disable Primary Menu', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'disable_sticky_primary_menu' => array(
          'title'             => __( 'Disable Sticky in Primary Menu', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
          'active_callback'   => 'wen_business_is_primary_menu_field_inactive',
        ),
        'disable_underline_in_primary_menu' => array(
          'title'             => __( 'Disable Underline in Primary Menu', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
          'active_callback'   => 'wen_business_is_primary_menu_field_inactive',
        ),
        'disable_secondary_menu' => array(
          'title'             => __( 'Disable Secondary Menu', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'disable_underline_in_secondary_menu' => array(
          'title'             => __( 'Disable Underline in Secondary Menu', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
          'active_callback'   => 'wen_business_is_secondary_menu_field_inactive',
        ),
        'secondary_menu_alignment' => array(
          'title'             => __( 'Secondary Menu Alignment', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_menu_alignment_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
          'active_callback'   => 'wen_business_is_secondary_menu_field_inactive',
        ),
        'disable_mobile_menu' => array(
          'title'             => __( 'Disable Mobile Menu', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
      )
    );

    // Font Section
    $font_fields = array();

    $font_keys = wen_business_get_font_family_theme_settings_options();

    if ( ! empty( $font_keys ) && is_array( $font_keys ) ) {
      $choices = wen_business_get_customizer_font_options();

      $load_font_cdn_desc = sprintf(
        wp_kses(
          __( 'A German court fined a website using Google-hosted webfonts for violating Europe’s General Data Protection Regulation (GDPR). So this has been discouraged. More info %1$shere%2$s', 'wen-business-pro' ),
          array(
            'a' => array(
              'href' => array(),
              'target' => array(),
            )
          )
        ),
        '<a target="_blank" href="https://make.wordpress.org/themes/2022/06/18/complying-with-gdpr-when-using-google-fonts/">',
        '</a>'
      );

      $default = wen_business_get_default_theme_options();

      $font_fields['load_font_cdn'] = array(
          'title'       => esc_html__( 'Load Google Font from CDN', 'wen-business-pro' ),
          'description' => $load_font_cdn_desc,
          'default'     => $default['load_font_cdn'],
          'section'     => 'section_font_family',
          'type'        => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
          'priority'    => 10,
      );

      foreach ( $font_keys as $k => $v ) {
        $font_fields[ $k ] = array(
          'title'             => $v['label'],
          'type'              => 'select',
          'choices'           => $choices,
          'sanitize_callback' => 'wen_business_sanitize_select',
        );
      }
      // Add reset Font settings Field
      $font_fields['reset_font_settings'] = array(
        'title'             => __( 'Reset Font Settings', 'wen-business-pro' ),
        'type'              => 'checkbox',
        'transport'         => 'postMessage',
        'sanitize_callback' => 'wen_business_sanitize_checkbox',
      );
    }

    if ( ! empty( $font_fields ) ) {
      $args['panels']['theme_option_panel']['sections']['section_font_family'] = array(
        'title'    => __( 'Font Family Options', 'wen-business-pro' ),
        'priority' => 65,
        'fields'   => $font_fields
      );
    }

    // Layout Section
    $args['panels']['theme_option_panel']['sections']['section_layout'] = array(
      'title'    => __( 'Layout Options', 'wen-business-pro' ),
      'priority' => 70,
      'fields'   => array(
        'site_layout' => array(
          'title'             => __( 'Site Layout', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_site_layout_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
        'global_layout' => array(
          'title'             => __( 'Global Layout', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_global_layout_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
        'archive_layout' => array(
          'title'             => __( 'Archive Layout', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_archive_layout_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
        'archive_image' => array(
          'title'             => __( 'Image in Archive', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_image_sizes_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
        'archive_image_alignment' => array(
          'title'             => __( 'Alignment of Image in Archive', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_image_alignment_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
        'single_image' => array(
          'title'             => __( 'Image in Single Post/Page', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_image_sizes_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
        'single_image_alignment' => array(
          'title'             => __( 'Alignment of Image in Single Post/Page', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_image_alignment_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
      )
    );

    // Pagination Section
    $args['panels']['theme_option_panel']['sections']['section_pagination'] = array(
      'title'    => __( 'Pagination Options', 'wen-business-pro' ),
      'priority' => 70,
      'fields'   => array(
        'pagination_type' => array(
          'title'             => __( 'Pagination Type', 'wen-business-pro' ),
          'description'       => sprintf( __( 'Infinite Scroll: Requires %1$sJetPack - Infinite Scroll%2$s plugin', 'wen-business-pro' ), '<a href="https://wordpress.org/plugins/jetpack/" target="_blank">','</a>' ),
          'type'              => 'select',
          'sanitize_callback' => 'wen_business_sanitize_select',
          'choices'           => wen_business_get_pagination_type_options(),
        ),
      )
    );

    // Comment Section
    $args['panels']['theme_option_panel']['sections']['section_comment'] = array(
      'title'    => __( 'Comment Options', 'wen-business-pro' ),
      'priority' => 75,
      'fields'   => array(
        'comment_option' => array(
          'title'             => __( 'Comment Option', 'wen-business-pro' ),
          'type'              => 'select',
          'sanitize_callback' => 'wen_business_sanitize_select',
          'choices'           => wen_business_get_comment_setting_options(),
        ),
        'enable_comment_note' => array(
          'title'             => __( 'Enable Comment Note', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'enable_comment_website' => array(
          'title'             => __( 'Enable Website Field', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'enable_minimum_characters_in_comment' => array(
          'title'             => __( 'Enable Minimum Characters', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'minimum_characters_in_comment' => array(
          'title'             => __( 'Minimum Characters', 'wen-business-pro' ),
          'type'              => 'number',
          'sanitize_callback' => 'wen_business_sanitize_number_range',
          'active_callback'   => 'wen_business_is_minimum_character_comment_active',
          'input_attrs'       => array(
                                  'min'   => 1,
                                  'max'   => 200,
                                  'style' => 'width: 55px;'
                                ),

        ),
      )
    );

    // Content Meta Section
    $args['panels']['theme_option_panel']['sections']['section_content_meta'] = array(
      'title'    => __( 'Content Meta Options', 'wen-business-pro' ),
      'priority' => 78,
      'fields'   => array(
        'meta_show_date' => array(
          'title'             => __( 'Show Date', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'meta_show_author' => array(
          'title'             => __( 'Show Author', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'meta_footer_layout' => array(
          'title'             => __( 'Footer Meta Layout', 'wen-business-pro' ),
          'type'              => 'radio',
          'choices'           => wen_business_get_meta_footer_layout_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
        'meta_show_category' => array(
          'title'             => __( 'Show Categories', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'meta_show_tag' => array(
          'title'             => __( 'Show Tags', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'meta_show_comment' => array(
          'title'             => __( 'Show Comment', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),

      )
    );

    // Footer Section
    $args['panels']['theme_option_panel']['sections']['section_footer'] = array(
      'title'    => __( 'Footer Options', 'wen-business-pro' ),
      'priority' => 80,
      'fields'   => array(
        'copyright_text' => array(
          'title'             => __( 'Copyright Text', 'wen-business-pro' ),
          'type'              => 'textarea',
          'sanitize_callback' => 'wen_business_sanitize_footer_content',
        ),
        'powered_by_text' => array(
          'title'             => __( 'Powered By Text', 'wen-business-pro' ),
          'type'              => 'textarea',
          'sanitize_callback' => 'wen_business_sanitize_footer_content',
        ),
        'enable_centered_footer' => array(
          'title'             => __( 'Enable Centered Footer Content', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'reset_footer_content' => array(
          'title'             => __( 'Reset Footer Content', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
          'transport'         => 'postMessage',
        ),
      )
    );

    // Go To Top Section
    $args['panels']['theme_option_panel']['sections']['section_go_to_top'] = array(
      'title'    => __( 'Go To Top Options', 'wen-business-pro' ),
      'priority' => 80,
      'fields'   => array(
        'go_to_top' => array(
          'title'             => __( 'Show Go To Top', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'go_to_top_icon' => array(
          'title'             => __( 'Icon', 'wen-business-pro' ),
          'description'       => __( 'Enter FontAwesome icon. Default: fa-chevron-circle-up', 'wen-business-pro' ),
          'type'              => 'text',
          'sanitize_callback' => 'sanitize_key',
          'active_callback'   => 'wen_business_is_go_to_top_active',
        ),
      )
    );

    // Blog Section
    $args['panels']['theme_option_panel']['sections']['section_blog'] = array(
      'title'    => __( 'Blog Options', 'wen-business-pro' ),
      'priority' => 80,
      'fields'   => array(
        'excerpt_length' => array(
          'title'             => __( 'Excerpt Length (words)', 'wen-business-pro' ),
          'description'       => __( 'Default is 40 words', 'wen-business-pro' ),
          'type'              => 'number',
          'sanitize_callback' => 'wen_business_sanitize_number_range',
          'input_attrs'       => array(
                                  'min'   => 1,
                                  'max'   => 200,
                                  'style' => 'width: 55px;'
                                ),
        ),
        'read_more_text' => array(
          'title'             => __( 'Read More Text', 'wen-business-pro' ),
          'type'              => 'text',
          'sanitize_callback' => 'sanitize_text_field',
        ),
        'exclude_categories' => array(
          'title'             => __( 'Exclude Categories in Blog', 'wen-business-pro' ),
          'description'       => __( 'Enter category ID to exclude in Blog Page. Separate with comma if more than one', 'wen-business-pro' ),
          'type'              => 'text',
          'sanitize_callback' => 'sanitize_text_field',
        ),
      )
    );
    // Author Bio Section
    $args['panels']['theme_option_panel']['sections']['section_author_bio'] = array(
      'title'       => __( 'Author Bio Options', 'wen-business-pro' ),
      'description' => __( 'Author Box will be displayed in the single post article.', 'wen-business-pro' ),
      'priority'    => 80,
      'fields'   => array(
        'author_bio_in_single' => array(
          'title' => __( 'Show Author Bio', 'wen-business-pro' ),
          'type'  => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'author_bio_show_recent_posts' => array(
          'title'           => __( 'Show Recent Posts by Author in Bio', 'wen-business-pro' ),
          'type'            => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
          'active_callback' => 'wen_business_is_show_author_bio_active',
        ),
        'author_bio_recent_posts_number' => array(
          'title'             => __( 'No of Recent Posts', 'wen-business-pro' ),
          'type'              => 'number',
          'sanitize_callback' => 'wen_business_sanitize_number_range',
          'active_callback' => 'wen_business_is_author_bio_recent_posts_active',
          'input_attrs'       => array(
                                'min'   => 1,
                                'max'   => 10,
                                'step'  => 1,
                                'style' => 'width: 50px;'
                                ),
        ),
      )
    );

    // Breadcrumb Section
    $args['panels']['theme_option_panel']['sections']['section_breadcrumb'] = array(
      'title'    => __( 'Breadcrumb Options', 'wen-business-pro' ),
      'priority' => 80,
      'fields'   => array(
        'breadcrumb_type' => array(
          'title'             => __( 'Breadcrumb Type', 'wen-business-pro' ),
          'description'       => sprintf( __( 'Advanced: Requires %1$sBreadcrumb NavXT%2$s plugin', 'wen-business-pro' ), '<a href="https://wordpress.org/plugins/breadcrumb-navxt/" target="_blank">','</a>' ),
          'type'              => 'select',
          'choices'           => wen_business_get_breadcrumb_type_options(),
          'sanitize_callback' => 'wen_business_sanitize_select',
        ),
        'breadcrumb_separator' => array(
          'title'       => __( 'Separator', 'wen-business-pro' ),
          'type'        => 'text',
          'input_attrs' => array('style' => 'width: 55px;'),
          'active_callback' => 'wen_business_is_simple_breadcrumb_active',
        ),
      )
    );

    // Fix Custom CSS field.
    if ( ! version_compare( $GLOBALS['wp_version'], '4.7-alpha', '<' ) ) {
    	if ( isset( $args['panels']['theme_option_panel']['sections']['section_advanced']['fields']['custom_css'] ) ) {
	    	unset( $args['panels']['theme_option_panel']['sections']['section_advanced']['fields']['custom_css'] );
    	}
    }

    return $args;

  }

endif;
