<?php

add_filter( 'wen_business_theme_options_args', 'wen_business_slider_theme_options_args' );


/**
 * Add featured slider options.
 *
 * @since  WEN Business 1.0
 */

if( ! function_exists( 'wen_business_slider_theme_options_args' ) ):

  function wen_business_slider_theme_options_args( $args ){

    // Create featured slider option panel
    $args['panels']['featured_slider_panel']['title'] = __( 'Featured Slider', 'wen-business-pro' );

    // Settings Section
    $args['panels']['featured_slider_panel']['sections']['section_slider_settings'] = array(
      'title'    => __( 'Slider Settings', 'wen-business-pro' ),
      'priority' => 75,
      'fields'   => array(
        'featured_slider_transition_effect' => array(
          'title'             => __( 'Transition Effect', 'wen-business-pro' ),
          'type'              => 'select',
          'sanitize_callback' => 'wen_business_sanitize_select',
          'choices'           => wen_business_get_featured_slider_transition_effects(),
        ),

        'featured_slider_transition_delay' => array(
          'title'             => __( 'Transition Delay', 'wen-business-pro' ),
          'description'       => __( 'In second(s)', 'wen-business-pro' ),
          'type'              => 'number',
          'sanitize_callback' => 'wen_business_sanitize_number_range',
          'input_attrs'       => array(
                                'min'   => 1,
                                'max'   => 10,
                                'step'  => 1,
                                'style' => 'width: 50px;'
                                ),

        ),
        'featured_slider_transition_duration' => array(
          'title'             => __( 'Transition Duration', 'wen-business-pro' ),
          'description'       => __( 'In second(s)', 'wen-business-pro' ),
          'type'              => 'number',
          'sanitize_callback' => 'wen_business_sanitize_number_range',
          'input_attrs'       => array(
                                'min'   => 1,
                                'max'   => 10,
                                'step'  => 1,
                                'style' => 'width: 50px;'
                                ),
        ),
        'featured_slider_caption_length' => array(
          'title'             => __( 'Caption Length', 'wen-business-pro' ),
          'description'       => __( 'In words', 'wen-business-pro' ),
          'type'              => 'number',
          'sanitize_callback' => 'absint',
          'input_attrs'       => array(
                                'min'   => 0,
                                'max'   => 200,
                                'step'  => 1,
                                'style' => 'width: 50px;'
                                ),
        ),
        'featured_slider_enable_caption' => array(
          'title'             => __( 'Enable Caption', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'featured_slider_enable_arrow' => array(
          'title'             => __( 'Enable Arrow', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'featured_slider_enable_pager' => array(
          'title'             => __( 'Enable Pager', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'featured_slider_enable_autoplay' => array(
          'title'             => __( 'Enable Autoplay', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),
        'featured_slider_enable_clickable_image' => array(
          'title'             => __( 'Enable Link in Image', 'wen-business-pro' ),
          'type'              => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
        ),

      )
    );

    // Slider Type Section
    $args['panels']['featured_slider_panel']['sections']['section_slider_type'] = array(
      'title'    => __( 'Slider Type', 'wen-business-pro' ),
      'priority' => 70,
      'fields'   => array(
        'featured_slider_status' => array(
          'title'             => __( 'Enable Slider on', 'wen-business-pro' ),
          'type'              => 'select',
          'sanitize_callback' => 'wen_business_sanitize_select',
          'choices'           => wen_business_get_featured_slider_content_options(),
        ),
        'featured_slider_type' => array(
          'title'             => __( 'Select Slider Type', 'wen-business-pro' ),
          'type'              => 'select',
          'choices'           => wen_business_get_featured_slider_type(),
          'sanitize_callback' => 'wen_business_sanitize_select',
          'active_callback'   => 'wen_business_is_featured_slider_active',
        ),
        'featured_slider_number' => array(
          'title'             => __( 'No of Slides', 'wen-business-pro' ),
          'description'       => __( 'Enter number between 1 and 20. Save and refresh the page if No of Slides is changed. ', 'wen-business-pro' ),
          'type'              => 'number',
          'default'           => 3,
          'transport'         => 'postMessage',
          'sanitize_callback' => 'wen_business_sanitize_number_range',
          'active_callback'   => 'wen_business_is_featured_slider_active',
          'input_attrs'       => array(
                                  'min'   => 1,
                                  'max'   => 20,
                                  'style' => 'width: 55px;'
                                ),
        ),
        'featured_slider_category' => array(
          'title'             => __( 'Select Category', 'wen-business-pro' ),
          'type'              => 'dropdown-taxonomies',
          'sanitize_callback' => 'absint',
          'active_callback'   => 'wen_business_is_featured_category_slider_active',
        ),
        'featured_slider_tag' => array(
          'title'             => __( 'Select Tag', 'wen-business-pro' ),
          'type'              => 'dropdown-taxonomies',
          'taxonomy'          => 'post_tag',
          'sanitize_callback' => 'absint',
          'active_callback'   => 'wen_business_is_featured_tag_slider_active',
        ),
      )
    );

    $slider_number = wen_business_get_option('featured_slider_number');
    for ( $i = 1; $i <= $slider_number ; $i++ ) {

      // Page
      $args['panels']['featured_slider_panel']['sections']['section_slider_type']['fields'][ 'featured_slider_page_' . $i ] = array(
          'title'             => __( 'Featured Page', 'wen-business-pro' ) . ' - ' . $i,
          'type'              => 'dropdown-pages',
          'sanitize_callback' => 'wen_business_sanitize_page_id',
          'active_callback'   => 'wen_business_is_featured_page_slider_active',
        );

      // Post
      $args['panels']['featured_slider_panel']['sections']['section_slider_type']['fields'][ 'featured_slider_post_' . $i ] = array(
          'title'             => __( 'Featured Post', 'wen-business-pro' ) . ' - ' . $i,
          'type'              => 'text',
          'sanitize_callback' => 'wen_business_sanitize_post_id',
          'active_callback'   => 'wen_business_is_featured_post_slider_active',
        );

      // Image slider fields
      // Heading
      $args['panels']['featured_slider_panel']['sections']['section_slider_type']['fields'][ 'featured_slider_image_heading_' . $i ] = array(
          'title'             => __( 'Slide', 'wen-business-pro' ) . ' - ' . $i,
          'type'              => 'heading',
          'sanitize_callback' => 'sanitize_text_field',
          'active_callback'   => 'wen_business_is_featured_image_slider_active',
        );
      // Photo
      $args['panels']['featured_slider_panel']['sections']['section_slider_type']['fields'][ 'featured_slider_image_photo_' . $i ] = array(
          'title'                => __( 'Image', 'wen-business-pro' ),
          'type'                 => 'image',
          'sanitize_callback'    => 'esc_url_raw',
          'sanitize_js_callback' => 'esc_url',
          'active_callback'      => 'wen_business_is_featured_image_slider_active',
        );
      // Title
      $args['panels']['featured_slider_panel']['sections']['section_slider_type']['fields'][ 'featured_slider_image_title_' . $i ] = array(
          'title'             => __( 'Title', 'wen-business-pro' ),
          'type'              => 'text',
          'sanitize_callback' => 'sanitize_text_field',
          'active_callback'   => 'wen_business_is_featured_image_slider_active',
        );
      // Caption
      $args['panels']['featured_slider_panel']['sections']['section_slider_type']['fields'][ 'featured_slider_image_caption_' . $i ] = array(
          'title'                => __( 'Caption', 'wen-business-pro' ),
          'type'                 => 'textarea',
          'sanitize_callback'    => 'wp_filter_nohtml_kses',
          'sanitize_js_callback' => 'wp_filter_nohtml_kses',
          'active_callback'      => 'wen_business_is_featured_image_slider_active',
        );
      // URL
      $args['panels']['featured_slider_panel']['sections']['section_slider_type']['fields'][ 'featured_slider_image_url_' . $i ] = array(
          'title'                => __( 'URL', 'wen-business-pro' ),
          'type'                 => 'text',
          'sanitize_callback'    => 'esc_url_raw',
          'sanitize_js_callback' => 'esc_url',
          'active_callback'      => 'wen_business_is_featured_image_slider_active',
        );
      // New Window
      $args['panels']['featured_slider_panel']['sections']['section_slider_type']['fields'][ 'featured_slider_image_new_window_' . $i ] = array(
          'title'                => __( 'Open in New Window', 'wen-business-pro' ),
          'type'                 => 'checkbox',
          'sanitize_callback' => 'wen_business_sanitize_checkbox',
          'active_callback'      => 'wen_business_is_featured_image_slider_active',
        );
    }

    return $args;

  }

endif;
