<?php
/**
 * Get default theme options
 *
 * @since  WEN Business 1.0
 */

if ( ! function_exists( 'wen_business_get_default_theme_options' ) ) :

  function wen_business_get_default_theme_options(){

    $input = array();

    // Core
    $input['custom_css']         = '';
    $input['search_placeholder'] = __( 'Search...', 'wen-business-pro' );

    // Home
    $input['show_page_content_in_site_front'] = true;

    // Header
    $input['move_logo_after_title']    = false;
    $input['show_title']               = true;
    $input['show_tagline']             = true;
    $input['show_tagline_separator']   = true;
    $input['move_tagline_below_title'] = false;
    $input['social_in_header']         = true;
    $input['search_in_header']         = true;
    $input['header_icon_size']         = 15;

    // Custom Header
    $input['ch_status']        = 'entire-site';
    $input['ch_image_alt']     = '';
    $input['ch_link_url']      = '';
    $input['ch_link_url_open'] = false;

    // Navigation
    $input['disable_primary_menu']                = false;
    $input['disable_sticky_primary_menu']         = true;
    $input['disable_underline_in_primary_menu']   = false;
    $input['disable_secondary_menu']              = true;
    $input['disable_underline_in_secondary_menu'] = false;
    $input['secondary_menu_alignment']            = 'center';
    $input['disable_mobile_menu']                 = false;

    // Font
    $font_keys = wen_business_get_font_family_theme_settings_options();
    foreach ( $font_keys as $k => $v ) {
      $input[ $k ]  = $v['default'];
    }
    $input['reset_font_settings'] = false;

    // Layout
    $input['site_layout']             = 'fluid';
    $input['global_layout']           = 'right-sidebar';
    $input['archive_layout']          = 'full';
    $input['archive_image']           = 'large';
    $input['archive_image_alignment'] = 'center';
    $input['single_image']            = 'large';
    $input['single_image_alignment']  = 'center';

    // Pagination
    $input['pagination_type']       = 'default';

    // Comment
    $input['comment_option']                       = 'default';
    $input['enable_comment_note']                  = true;
    $input['enable_comment_website']               = true;
    $input['enable_minimum_characters_in_comment'] = false;
    $input['minimum_characters_in_comment']        = 10;

    // Content Meta
    $input['meta_show_date']     = true;
    $input['meta_show_author']   = true;
    $input['meta_footer_layout'] = 'default';
    $input['meta_show_category'] = true;
    $input['meta_show_tag']      = true;
    $input['meta_show_comment']  = true;

    // Footer
    $input['copyright_text']         = sprintf( __( 'Copyright &copy; %s. All Rights Reserved.', 'wen-business-pro' ), '[the_year] [site_link]' );
    $input['powered_by_text']        = '[powered_by] | [theme_credit]';
    $input['enable_centered_footer'] = false;
    $input['reset_footer_content']   = false;

    // Go To Top
    $input['go_to_top']      = true;
    $input['go_to_top_icon'] = 'fa-chevron-circle-up';


    // Load fonts from CDN
    $input['load_font_cdn']        = false;  

    // Blog
    $input['excerpt_length']       = 40;
    $input['read_more_text']       = __( 'Read More ...', 'wen-business-pro' );
    $input['exclude_categories']   = '';

    // Author Bio
    $input['author_bio_in_single']           = false;
    $input['author_bio_show_recent_posts']   = false;
    $input['author_bio_recent_posts_number'] = 5;

    // Breadcrumb
    $input['breadcrumb_type']      = 'disabled';
    $input['breadcrumb_separator'] = '&gt;';

    // WooCommerce
    $input['woo_page_layout']       = 'right-sidebar';
    $input['woo_sidebar_primary']   = '';
    $input['woo_sidebar_secondary'] = '';

    // Slider defaults
    $input['featured_slider_status']                 = 'home-page';
    $input['featured_slider_transition_effect']      = 'fadeout';
    $input['featured_slider_transition_delay']       = 3;
    $input['featured_slider_transition_duration']    = 1;
    $input['featured_slider_caption_length']         = 20;
    $input['featured_slider_enable_caption']         = true;
    $input['featured_slider_enable_arrow']           = false;
    $input['featured_slider_enable_pager']           = true;
    $input['featured_slider_enable_autoplay']        = true;
    $input['featured_slider_enable_clickable_image'] = true;
    $input['featured_slider_type']                   = 'featured-category';
    $input['featured_slider_number']                 = 3;
    $input['featured_slider_category']               = '';

    // Color
    $colors = wen_business_get_default_colors();
    if ( ! empty( $colors ) ) {
      foreach ( $colors as $key => $val ) {
        $input[$key] = $val;
      }
    }

    $input = apply_filters( 'wen_business_filter_default_theme_options', $input );

    return $input;

  }

endif;
