<?php
if( ! function_exists( 'wen_business_is_social_menu_active' ) ) :

  /**
   * Check if social menu is active.
   *
   * @since WEN Business 1.0.4
   * @return bool true/false
   */
  function wen_business_is_social_menu_active(){

    $is_menu_set = false;
    // Fetch nav
    $nav_menu_locations = get_nav_menu_locations();
    if ( isset( $nav_menu_locations['social'] ) && absint( $nav_menu_locations['social'] ) > 0 ) {
      $is_menu_set = true;
    }

    return $is_menu_set;

  }

endif;


if( ! function_exists( 'wen_business_fonts_url' ) ) :

  /**
   * Return fonts URL.
   *
   * @since WEN Business 1.0
   */
  function wen_business_fonts_url(){

    $fonts_url = '';
    $fonts     = array();
    $subsets   = 'latin,latin-ext';

    $font_settings = wen_business_get_font_family_theme_settings_options();
    $web_fonts = wen_business_get_web_fonts();

    $theme_options = array();
    if ( ! empty( $font_settings ) ) {
      foreach ($font_settings as $k => $v ) {
        $theme_options[] = wen_business_get_option( $k );
      }
    }
    $theme_options = array_unique( $theme_options );

    $required_fonts = array();

    if ( ! empty( $theme_options )) {
      foreach ($theme_options as $key => $value) {
        if ( array_key_exists( $value, $web_fonts ) ) {
          $required_fonts[] = $value;
        }
      }
    }

    if ( ! empty( $required_fonts )) {
      foreach ($required_fonts as $key => $f ) {
        $fonts[] = $web_fonts[ $f ]['name'] . ':300,400,400i,700,700i';
      }
    }

    if ( $fonts ) {
      $fonts_url = add_query_arg( array(
        'family' => urlencode( implode( '|', $fonts ) ),
        'subset' => urlencode( $subsets ),
      ), 'https://fonts.googleapis.com/css' );
    }

    $font_load = wen_business_get_option( 'load_font_cdn' );

    if ( ! $font_load ) {
      require_once get_theme_file_path( 'inc/wptt-webfont-loader.php' );
    
      $fonts_url = wptt_get_webfont_url( $fonts_url );
    }

    return $fonts_url;

  }

endif;


if( ! function_exists( 'wen_business_get_font_family_from_key' ) ) :

  /**
   * Return font family from font slug.
   *
   * @since WEN Business 1.0.4
   */
  function wen_business_get_font_family_from_key( $key ){

    $output = '';

    $web_fonts = wen_business_get_web_fonts();
    $os_fonts  = wen_business_get_os_fonts();

    $fonts = array_merge( $web_fonts, $os_fonts );

    if ( isset( $fonts[ $key ] ) ) {
      $output = $fonts[ $key ]['label'];
    }
    return $output;

  }

endif;



if( ! function_exists( 'wen_business_get_sidebar_options' ) ) :

  /**
   * Get sidebar options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_sidebar_options(){

    global $wp_registered_sidebars;

    $output = array();

    if ( ! empty( $wp_registered_sidebars ) && is_array( $wp_registered_sidebars ) ) {
      foreach ( $wp_registered_sidebars as $key => $sidebar ) {
        $output[$key] = $sidebar['name'];
      }
    }

    return $output;

  }

endif;

if ( ! function_exists( 'wen_business_primary_menu_fallback' ) ) :

	/**
	 * Fallback for Primary menu.
	 *
	 * @since 1.1.0
	 */
	function wen_business_primary_menu_fallback( $args ){

		echo '<ul>';
		echo '<li><a href="' . esc_url( home_url( '/' ) ) . '">' . __( 'Home', 'wen-business-pro' ) . '</a></li>';
		wp_list_pages( array(
			'title_li' => '',
			'depth'    => 1,
			'number'   => 5,
		) );
		echo '</ul>';

	}
endif;
