<?php


if( ! function_exists( 'wen_business_is_simple_breadcrumb_active' ) ) :

  /**
   * Check if simple breadcrumb is active
   *
   * @since  WEN Business 1.0
   */
  function wen_business_is_simple_breadcrumb_active( $control ) {

    if ( 'simple' == $control->manager->get_setting( 'theme_options[breadcrumb_type]' )->value() )
    {
      return true;
    } else {
      return false;
    }

  }

endif;

if( ! function_exists( 'wen_business_is_show_author_bio_active' ) ) :

  /**
   * Check if show author bio is active
   *
   * @since  WEN Business 1.0
   */
  function wen_business_is_show_author_bio_active( $control ) {

    if ( true == $control->manager->get_setting( 'theme_options[author_bio_in_single]' )->value() )
    {
      return true;
    } else {
      return false;
    }

  }

endif;

if( ! function_exists( 'wen_business_is_author_bio_recent_posts_active' ) ) :

  /**
   * Check if show author bio and recent posts is active
   *
   * @since  WEN Business 1.0
   */
  function wen_business_is_author_bio_recent_posts_active( $control ) {

    if (
      true == $control->manager->get_setting( 'theme_options[author_bio_in_single]' )->value()
      && true == $control->manager->get_setting( 'theme_options[author_bio_show_recent_posts]' )->value()
      )
    {
      return true;
    } else {
      return false;
    }

  }

endif;

/**
 * Check if featured slider is active
 *
 * @since  WEN Business 1.0
 */
if( ! function_exists( 'wen_business_is_featured_slider_active' ) ) :

  function wen_business_is_featured_slider_active( $control ) {

    if ( 'disabled' != $control->manager->get_setting( 'theme_options[featured_slider_status]' )->value() )
    {
      return true;
    } else {
      return false;
    }

  }

endif;

/**
 * Check if featured category slider is active
 *
 * @since  WEN Business 1.0
 */
if( ! function_exists( 'wen_business_is_featured_category_slider_active' ) ) :

  function wen_business_is_featured_category_slider_active( $control ) {

    if (
      'featured-category' == $control->manager->get_setting( 'theme_options[featured_slider_type]' )->value()
      && 'disabled' != $control->manager->get_setting( 'theme_options[featured_slider_status]' )->value()
     )
    {
      return true;
    } else {
      return false;
    }

  }

endif;


/**
 * Check if featured category slider is active
 *
 * @since  WEN Business 1.0
 */
if( ! function_exists( 'wen_business_is_featured_tag_slider_active' ) ) :

  function wen_business_is_featured_tag_slider_active( $control ) {

    if (
      'featured-tag' == $control->manager->get_setting( 'theme_options[featured_slider_type]' )->value()
      && 'disabled' != $control->manager->get_setting( 'theme_options[featured_slider_status]' )->value()
     )
    {
      return true;
    } else {
      return false;
    }

  }

endif;

/**
 * Check if featured page slider is active
 *
 * @since  WEN Business 1.0
 */
if( ! function_exists( 'wen_business_is_featured_page_slider_active' ) ) :

  function wen_business_is_featured_page_slider_active( $control ) {

    if (
      'featured-page' == $control->manager->get_setting( 'theme_options[featured_slider_type]' )->value()
      && 'disabled' != $control->manager->get_setting( 'theme_options[featured_slider_status]' )->value()
     )
    {
      return true;
    } else {
      return false;
    }

  }

endif;

/**
 * Check if featured post slider is active
 *
 * @since  WEN Business 1.0
 */
if( ! function_exists( 'wen_business_is_featured_post_slider_active' ) ) :

  function wen_business_is_featured_post_slider_active( $control ) {

    if (
      'featured-post' == $control->manager->get_setting( 'theme_options[featured_slider_type]' )->value()
      && 'disabled' != $control->manager->get_setting( 'theme_options[featured_slider_status]' )->value()
     )
    {
      return true;
    } else {
      return false;
    }

  }

endif;


/**
 * Check if featured image slider is active
 *
 * @since  WEN Business 1.0
 */
if( ! function_exists( 'wen_business_is_featured_image_slider_active' ) ) :

  function wen_business_is_featured_image_slider_active( $control ) {

    if (
      'featured-image' == $control->manager->get_setting( 'theme_options[featured_slider_type]' )->value()
      && 'disabled' != $control->manager->get_setting( 'theme_options[featured_slider_status]' )->value()
     )
    {
      return true;
    } else {
      return false;
    }

  }

endif;


if( ! function_exists( 'wen_business_is_go_to_top_active' ) ) :

  /**
   * Check if go to top is active
   *
   * @since  WEN Business 1.0
   */
  function wen_business_is_go_to_top_active( $control ) {

    if ( true == $control->manager->get_setting( 'theme_options[go_to_top]' )->value() )
    {
      return true;
    } else {
      return false;
    }

  }

endif;


if( ! function_exists( 'wen_business_is_primary_menu_field_inactive' ) ) :

  /**
   * Check if primary menu field is active
   *
   * @since  WEN Business 1.0
   */
  function wen_business_is_primary_menu_field_inactive( $control ) {

    if ( false == $control->manager->get_setting( 'theme_options[disable_primary_menu]' )->value() )
    {
      return true;
    } else {
      return false;
    }

  }

endif;

if( ! function_exists( 'wen_business_is_secondary_menu_field_inactive' ) ) :

  /**
   * Check if secondary menu field is active
   *
   * @since  WEN Business 1.0
   */
  function wen_business_is_secondary_menu_field_inactive( $control ) {

    if ( false == $control->manager->get_setting( 'theme_options[disable_secondary_menu]' )->value() )
    {
      return true;
    } else {
      return false;
    }

  }

endif;


if( ! function_exists( 'wen_business_is_minimum_character_comment_active' ) ) :

  /**
   * Check if minimum character in comment is active
   *
   * @since  WEN Business 1.0
   */
  function wen_business_is_minimum_character_comment_active( $control ) {

    if ( true == $control->manager->get_setting( 'theme_options[enable_minimum_characters_in_comment]' )->value() )
    {
      return true;
    } else {
      return false;
    }

  }

endif;
