<?php

if( ! function_exists( 'wen_business_get_featured_slider_transition_effects' ) ) :

  /**
   * Returns the featured slider transition effects.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_featured_slider_transition_effects(){

    $choices = array(
      'fade'       => __( 'fade', 'wen-business-pro' ),
      'fadeout'    => __( 'fadeout', 'wen-business-pro' ),
      'none'       => __( 'none', 'wen-business-pro' ),
      'scrollHorz' => __( 'scrollHorz', 'wen-business-pro' ),
    );
    $output = apply_filters( 'wen_business_filter_featured_slider_transition_effects', $choices );
    if ( ! empty( $output ) ) {
      ksort( $output );
    }
    return $output;

  }

endif;


if( ! function_exists( 'wen_business_get_featured_slider_content_options' ) ) :

  /**
   * Returns the featured slider content options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_featured_slider_content_options(){

    $choices = array(
      'home-page'   => __( 'Home Page / Front Page', 'wen-business-pro' ),
      'entire-site' => __( 'Entire Site', 'wen-business-pro' ),
      'disabled'    => __( 'Disabled', 'wen-business-pro' ),
    );
    $output = apply_filters( 'wen_business_filter_featured_slider_content_options', $choices );
    if ( ! empty( $output ) ) {
      ksort( $output );
    }
    return $output;

  }

endif;


if( ! function_exists( 'wen_business_get_custom_header_status_options' ) ) :

  /**
   * Returns the custom header status options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_custom_header_status_options(){

    $choices = array(
      'home-page'               => __( 'Home Page / Front Page', 'wen-business-pro' ),
      'entire-site'             => __( 'Entire Site', 'wen-business-pro' ),
      'entire-site-except-home' => __( 'Entire Site Except Home', 'wen-business-pro' ),
      'disabled'                => __( 'Disabled', 'wen-business-pro' ),
    );
    $output = apply_filters( 'wen_business_filter_custom_header_status_options', $choices );
    if ( ! empty( $output ) ) {
      ksort( $output );
    }
    return $output;

  }

endif;


if( ! function_exists( 'wen_business_get_featured_slider_type' ) ) :

  /**
   * Returns the featured slider type.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_featured_slider_type(){

    $choices = array(
      'featured-category' => __( 'Featured Category', 'wen-business-pro' ),
      'featured-page'     => __( 'Featured Pages', 'wen-business-pro' ),
      'featured-post'     => __( 'Featured Posts', 'wen-business-pro' ),
      'featured-image'    => __( 'Featured Images', 'wen-business-pro' ),
      'featured-tag'      => __( 'Featured Tag', 'wen-business-pro' ),
    );
    $output = apply_filters( 'wen_business_filter_featured_slider_type', $choices );
    if ( ! empty( $output ) ) {
      ksort( $output );
    }
    return $output;


  }

endif;


if( ! function_exists( 'wen_business_get_global_layout_options' ) ) :

  /**
   * Returns global layout options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_global_layout_options(){

    $choices = array(
      'left-sidebar'            => __( 'Primary Sidebar - Content', 'wen-business-pro' ),
      'right-sidebar'           => __( 'Content - Primary Sidebar', 'wen-business-pro' ),
      'three-columns'           => __( 'Three Columns ( Secondary - Content - Primary )', 'wen-business-pro' ),
      'three-columns-pcs'       => __( 'Three Columns ( Primary - Content - Secondary )', 'wen-business-pro' ),
      'three-columns-cps'       => __( 'Three Columns ( Content - Primary - Secondary )', 'wen-business-pro' ),
      'three-columns-psc'       => __( 'Three Columns ( Primary - Secondary - Content )', 'wen-business-pro' ),
      'three-columns-pcs-equal' => __( 'Three Columns ( Equal Primary - Content - Secondary )', 'wen-business-pro' ),
      'three-columns-scp-equal' => __( 'Three Columns ( Equal Secondary - Content - Primary )', 'wen-business-pro' ),
      'no-sidebar'              => __( 'No Sidebar ( Full Width )', 'wen-business-pro' ),
      'no-sidebar-centered'     => __( 'No Sidebar ( Centered Content )', 'wen-business-pro' ),
    );
    $output = apply_filters( 'wen_business_filter_layout_options', $choices );
    return $output;

  }

endif;


if( ! function_exists( 'wen_business_get_site_layout_options' ) ) :

  /**
   * Returns site options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_site_layout_options(){

    $choices = array(
      'fluid' => __( 'Fluid', 'wen-business-pro' ),
      'boxed' => __( 'Boxed', 'wen-business-pro' ),
    );
    $output = apply_filters( 'wen_business_filter_site_layout_options', $choices );
    if ( ! empty( $output ) ) {
      ksort( $output );
    }
    return $output;

  }

endif;


if( ! function_exists( 'wen_business_get_archive_layout_options' ) ) :

  /**
   * Returns archive layout options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_archive_layout_options(){

    $choices = array(
      'full'          => __( 'Full Post', 'wen-business-pro' ),
      // 'full-thumb'    => __( 'Full with Featured Image', 'wen-business-pro' ),
      'excerpt'       => __( 'Post Excerpt', 'wen-business-pro' ),
      // 'excerpt-thumb' => __( 'Excerpt with Featured Image', 'wen-business-pro' ),
    );
    $output = apply_filters( 'wen_business_filter_archive_layout_options', $choices );
    if ( ! empty( $output ) ) {
      ksort( $output );
    }
    return $output;


  }

endif;


if( ! function_exists( 'wen_business_get_image_sizes_options' ) ) :

  /**
   * Returns archive layout options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_image_sizes_options( $add_disable = true ){

    global $_wp_additional_image_sizes;
    $get_intermediate_image_sizes = get_intermediate_image_sizes();
    $choices = array();
    if ( true == $add_disable ) {
      $choices['disable'] = __( 'No Image', 'wen-business-pro' );
    }
    foreach ( array( 'thumbnail', 'medium', 'large' ) as $key => $_size ) {
      $choices[ $_size ] = $_size . ' ('. get_option( $_size . '_size_w' ) . 'x' . get_option( $_size . '_size_h' ) . ')';
    }
    $choices['full'] = __( 'full (original)', 'wen-business-pro' );
    if ( ! empty( $_wp_additional_image_sizes ) && is_array( $_wp_additional_image_sizes ) ) {

      foreach ($_wp_additional_image_sizes as $key => $size ) {
        $choices[ $key ] = $key . ' ('. $size['width'] . 'x' . $size['height'] . ')';
      }

    }
    return $choices;

  }

endif;



if( ! function_exists( 'wen_business_get_image_alignment_options' ) ) :

  /**
   * Returns image options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_image_alignment_options(){

    $choices = array(
      'none'   => __( 'None', 'wen-business-pro' ),
      'left'   => __( 'Left', 'wen-business-pro' ),
      'center' => __( 'Center', 'wen-business-pro' ),
      'right'  => __( 'Right', 'wen-business-pro' ),
    );
    return $choices;

  }

endif;


if( ! function_exists( 'wen_business_get_menu_alignment_options' ) ) :

  /**
   * Returns menu options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_menu_alignment_options(){

    $choices = array(
      'left'   => __( 'Left', 'wen-business-pro' ),
      'center' => __( 'Center', 'wen-business-pro' ),
      'right'  => __( 'Right', 'wen-business-pro' ),
    );
    return $choices;

  }

endif;


if( ! function_exists( 'wen_business_get_pagination_type_options' ) ) :

  /**
   * Returns pagination type options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_pagination_type_options(){

    $choices = array(
      'default'               => __( 'Default (Older / Newer Post)', 'wen-business-pro' ),
      'numeric'               => __( 'Numeric', 'wen-business-pro' ),
      'infinite-scroll'       => __( 'Infinite Scroll - Scroll', 'wen-business-pro' ),
      'infinite-scroll-click' => __( 'Infinite Scroll - Click', 'wen-business-pro' ),
    );
    return $choices;

  }

endif;

if( ! function_exists( 'wen_business_get_comment_setting_options' ) ) :

  /**
   * Returns comment settings options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_comment_setting_options(){

    $choices = array(
      'default'         => __( 'WordPress Default', 'wen-business-pro' ),
      'disable-in-page' => __( 'Disable in Page', 'wen-business-pro' ),
      'disabled'        => __( 'Disable Completely', 'wen-business-pro' ),
    );
    return $choices;

  }

endif;


if( ! function_exists( 'wen_business_get_breadcrumb_type_options' ) ) :

  /**
   * Returns breadcrumb type options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_breadcrumb_type_options(){

    $choices = array(
      'disabled' => __( 'Disabled', 'wen-business-pro' ),
      'simple'   => __( 'Simple', 'wen-business-pro' ),
      'advanced' => __( 'Advanced', 'wen-business-pro' ),
    );
    return $choices;

  }

endif;


if( ! function_exists( 'wen_business_get_meta_footer_layout_options' ) ) :

  /**
   * Returns meta footer layout options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_meta_footer_layout_options(){

    $choices = array(
      'default' => __( 'Default', 'wen-business-pro' ),
      'compact' => __( 'Compact', 'wen-business-pro' ),
    );
    $output = apply_filters( 'wen_business_filter_meta_footer_layout_options', $choices );
    if ( ! empty( $output ) ) {
      ksort( $output );
    }
    return $output;

  }

endif;

if( ! function_exists( 'wen_business_get_font_family_theme_settings_options' ) ) :

  /**
   * Returns font family theme settings options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_font_family_theme_settings_options(){

    $choices = array(
      'font_site_title' => array(
          'label'   => __( 'Site Title', 'wen-business-pro' ),
          'default' => 'lato',
        ),
      'font_site_tagline' => array(
          'label'   => __( 'Site Tagline', 'wen-business-pro' ),
          'default' => 'lato',
        ),
      'font_site_default' => array(
          'label'   => __( 'Default', 'wen-business-pro' ),
          'default' => 'lato',
        ),
      'font_content_title' => array(
          'label'   => __( 'Content Title', 'wen-business-pro' ),
          'default' => 'lato',
        ),
      'font_content_body' => array(
          'label'   => __( 'Content Body', 'wen-business-pro' ),
          'default' => 'open-sans',
        ),
      'font_heading_tags' => array(
          'label'   => __( 'Heading Tags', 'wen-business-pro' ),
          'default' => 'lato',
        ),
      'font_navigation' => array(
          'label'   => __( 'Navigation', 'wen-business-pro' ),
          'default' => 'lato',
        ),
    );
    return $choices;

  }

endif;


if( ! function_exists( 'wen_business_get_web_fonts' ) ) :

  /**
   * Returns web font options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_web_fonts(){

    $choices = array(
      'open-sans' => array(
        'name'  => 'Open Sans',
        'label' => "'Open Sans', sans-serif",
      ),
      'roboto' => array(
        'name'  => 'Roboto',
        'label' => "'Roboto', sans-serif",
      ),
      'raleway' => array(
        'name'  => 'Raleway',
        'label' => "'Raleway', sans-serif",
      ),
      'droid-sans' => array(
        'name'  => 'Droid Sans',
        'label' => "'Droid Sans', sans-serif",
      ),
      'lato' => array(
        'name'  => 'Lato',
        'label' => "'Lato', sans-serif",
      ),
      'dosis' => array(
        'name'  => 'Dosis',
        'label' => "'Dosis', sans-serif",
      ),
      'slabo-27px' => array(
        'name'  => 'Slabo 27px',
        'label' => "'Slabo 27px', serif",
      ),
      'oswald' => array(
        'name'  => 'Oswald',
        'label' => "'Oswald', sans-serif",
      ),
      'pt-sans-narrow' => array(
        'name'  => 'PT Sans Narrow',
        'label' => "'PT Sans Narrow', sans-serif",
      ),
      'josefin-slab' => array(
        'name'  => 'Josefin Slab',
        'label' => "'Josefin Slab', serif",
      ),
      'alegreya' => array(
        'name'  => 'Alegreya',
        'label' => "'Alegreya', serif",
      ),
      'exo' => array(
        'name'  => 'Exo',
        'label' => "'Exo', sans-serif",
      ),
      'signika' => array(
        'name'  => 'Signika',
        'label' => "'Signika', sans-serif",
      ),
      'lobster' => array(
        'name'  => 'Lobster',
        'label' => "'Lobster', sans-serif",
      ),
    );
    $choices = apply_filters( 'wen_business_filter_web_fonts', $choices );

    if ( ! empty( $choices ) ) {
      ksort( $choices );
    }

    return $choices;

  }

endif;

if( ! function_exists( 'wen_business_get_os_fonts' ) ) :

  /**
   * Returns OS font options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_os_fonts(){

    $choices = array(
      'arial' => array(
        'name'  => 'Arial',
        'label' => "'Arial', sans-serif",
      ),
      'georgia' => array(
        'name'  => 'Georgia',
        'label' => "'Georgia', serif",
      ),
      'cambria' => array(
        'name'  => 'Cambria',
        'label' => "'Cambria', Georgia, serif",
      ),
      'tahoma' => array(
        'name'  => 'Tahoma',
        'label' => "'Tahoma', Geneva, sans-serif",
      ),
      'sans-serif' => array(
        'name'  => 'Sans Serif',
        'label' => "'Sans Serif', Arial",
      ),
      'verdana' => array(
        'name'  => 'Verdana',
        'label' => "'Verdana', Geneva, sans-serif",
      ),
    );
    $choices = apply_filters( 'wen_business_filter_os_fonts', $choices );

    if ( ! empty( $choices ) ) {
      ksort( $choices );
    }

    return $choices;

  }

endif;

if( ! function_exists( 'wen_business_get_customizer_font_options' ) ) :

  /**
   * Returns customizer font options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_customizer_font_options(){

    $web_fonts = wen_business_get_web_fonts();
    $os_fonts  = wen_business_get_os_fonts();

    $web_fonts = array_merge( $web_fonts, $os_fonts );

    if ( ! empty( $web_fonts ) ) {
      ksort( $web_fonts );
    }

    $choices = array();

    if ( ! empty( $web_fonts ) ) {
      foreach ( $web_fonts as $k => $v ) {
        $choices[$k] = esc_html( $v['label'] );
      }
    }
    return $choices;

  }

endif;


if( ! function_exists( 'wen_business_get_default_colors' ) ) :

  /**
   * Returns default colors.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_default_colors( $scheme = 'default' ){

    $output = array();

    switch ( $scheme ) {

      case 'default':
      default:
        $output = array(

          // Basic
          'color_basic_background'              => '#f5f4f4',
          'color_basic_text'                    => '#8c8b8b',
          'color_basic_link'                    => '#209fcc',
          'color_basic_link_hover'              => '#0079a6',
          'color_basic_heading'                 => '#209fcc',
          'color_basic_button_background'       => '#209fcc',
          'color_basic_button_text'             => '#ffffff',
          'color_basic_button_background_hover' => '#0079a6',
          'color_basic_button_text_hover'       => '#ffffff',

          // Header
          'color_header_background'  => '#f5f4f4',
          'color_header_title'       => '#209fcc',
          'color_header_title_hover' => '#0079a6',
          'color_header_tagline'     => '#858585',

          // Header Top
          'color_header_top_background' => '#d7d7d7',
          'color_header_top_icon'       => '#353526',

          // Content
          'color_content_background'      => '#ededed',
          'color_content_title'           => '#464637',
          'color_content_text'            => '#8c8b8b',
          'color_content_link'            => '#209fcc',
          'color_content_link_hover'      => '#0079a6',
          'color_content_meta_text'       => '#a7a9ac',
          'color_content_meta_link'       => '#a7a9ac',
          'color_content_meta_link_hover' => '#0079a6',
          'color_content_meta_icon'       => '#1f9fcc',

          // Sidebar
          'color_sidebar_background'        => '#f5f4f4',
          'color_sidebar_widget_background' => '#f1f1e5',
          'color_sidebar_widget_title'      => '#464637',
          'color_sidebar_widget_text'       => '#464637',
          'color_sidebar_widget_link'       => '#464637',
          'color_sidebar_widget_link_hover' => '#0079a6',

          // Home Page Widgets
          'color_home_widgets_title'            => '#ffffff',
          'color_home_widgets_title_background' => '#313131',

          // Primary Menu
          'color_primary_menu_main_background'    => '#f5f4f4',
          'color_primary_menu_main_link'          => '#6f6f6f',
          'color_primary_menu_main_link_hover'    => '#209fcc',
          'color_primary_menu_main_underline'     => '#242415',
          'color_primary_menu_submenu_background' => '#ffffff',
          'color_primary_menu_submenu_link'       => '#6f6f6f',
          'color_primary_menu_submenu_link_hover' => '#209fcc',
          'color_primary_menu_icon'               => '#c2c2c2',

          // Secondary Menu
          'color_secondary_menu_main_background'    => '#f5f4f4',
          'color_secondary_menu_main_link'          => '#6f6f6f',
          'color_secondary_menu_main_link_hover'    => '#209fcc',
          'color_secondary_menu_submenu_background' => '#ffffff',
          'color_secondary_menu_submenu_link'       => '#6f6f6f',
          'color_secondary_menu_submenu_link_hover' => '#209fcc',
          'color_secondary_menu_icon'               => '#c2c2c2',

          // Slider
          'color_slider_caption_background'   => '#000000',
          'color_slider_caption_title'        => '#f0f0df',
          'color_slider_caption_title_hover'  => '#f0f0df',
          'color_slider_caption_text'         => '#f0f0df',
          'color_slider_next_prev_icon'       => '#eeeeee',
          'color_slider_next_prev_icon_hover' => '#eeeeee',
          'color_slider_pager'                => '#ffffff',
          'color_slider_pager_hover'          => '#ffffff',

          // Footer Menu
          'color_footer_menu_background' => '#888888',
          'color_footer_menu_link'       => '#ffffff',
          'color_footer_menu_link_hover' => '#0a89b6',

          // Go To Top
          'color_goto_top_icon'       => '#209fcc',
          'color_goto_top_icon_hover' => '#0079a6',

          // Pagination
          'color_pagination_link'                  => '#ffffff',
          'color_pagination_link_hover'            => '#ffffff',
          'color_pagination_link_background'       => '#209fcc',
          'color_pagination_link_background_hover' => '#0079a6',

          // Footer Widgets
          'color_footer_widgets_background' => '#d5d5d5',
          'color_footer_widgets_title'      => '#8c8b8b',
          'color_footer_widgets_text'       => '#8c8b8b',
          'color_footer_widgets_link'       => '#209fcc',
          'color_footer_widgets_link_hover' => '#0a89b6',

          // Footer Copyright
          'color_footer_copyright_background' => '#d5d5d5',
          'color_footer_copyright_text'       => '#262626',
          'color_footer_copyright_link'       => '#209fcc',
          'color_footer_copyright_link_hover' => '#0a89b6',

          // Content Box
          'color_content_box_background' => '#f5f4f4',

        );
        break;

    }
    return $output;

  }

endif;


if( ! function_exists( 'wen_business_get_color_theme_settings_options' ) ) :

  /**
   * Returns color theme settings options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_color_theme_settings_options(){

    $choices = array(

      // Basic
      'color_basic_background' => array(
          'label'   => __( 'Background Color', 'wen-business-pro' ),
          'section' => 'color_section_basic',
        ),
      'color_basic_text' => array(
          'label'   => __( 'Text Color', 'wen-business-pro' ),
          'section' => 'color_section_basic',
        ),
      'color_basic_link' => array(
          'label'   => __( 'Link Color', 'wen-business-pro' ),
          'section' => 'color_section_basic',
        ),
      'color_basic_link_hover' => array(
          'label'   => __( 'Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_basic',
        ),
      'color_basic_heading' => array(
          'label'   => __( 'Heading Color', 'wen-business-pro' ),
          'section' => 'color_section_basic',
        ),
      'color_basic_button_text' => array(
          'label'   => __( 'Button Text Color', 'wen-business-pro' ),
          'section' => 'color_section_basic',
        ),
      'color_basic_button_background' => array(
          'label'   => __( 'Button Background Color', 'wen-business-pro' ),
          'section' => 'color_section_basic',
        ),
      'color_basic_button_text_hover' => array(
          'label'   => __( 'Button Text Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_basic',
        ),
      'color_basic_button_background_hover' => array(
          'label'   => __( 'Button Background Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_basic',
        ),

      // Header
      'color_header_background' => array(
          'label'   => __( 'Header Background Color', 'wen-business-pro' ),
          'section' => 'color_section_header',
        ),
      'color_header_title' => array(
          'label'   => __( 'Site Title Color', 'wen-business-pro' ),
          'section' => 'color_section_header',
        ),
      'color_header_title_hover' => array(
          'label'   => __( 'Site Title Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_header',
        ),
      'color_header_tagline' => array(
          'label'   => __( 'Site Tagline Color', 'wen-business-pro' ),
          'section' => 'color_section_header',
        ),

      // Header Top
      'color_header_top_background' => array(
          'label'   => __( 'Background Color', 'wen-business-pro' ),
          'section' => 'color_section_header_top',
        ),
      'color_header_top_icon' => array(
          'label'   => __( 'Icon Color', 'wen-business-pro' ),
          'section' => 'color_section_header_top',
        ),

      // Content
      'color_content_background' => array(
          'label'   => __( 'Background Color', 'wen-business-pro' ),
          'section' => 'color_section_content',
        ),
      'color_content_title' => array(
          'label'   => __( 'Title Color', 'wen-business-pro' ),
          'section' => 'color_section_content',
        ),
      'color_content_text' => array(
          'label'   => __( 'Text Color', 'wen-business-pro' ),
          'section' => 'color_section_content',
        ),
      'color_content_link' => array(
          'label'   => __( 'Link Color', 'wen-business-pro' ),
          'section' => 'color_section_content',
        ),
      'color_content_link_hover' => array(
          'label'   => __( 'Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_content',
        ),
      'color_content_meta_text' => array(
          'label'   => __( 'Meta Text Color', 'wen-business-pro' ),
          'section' => 'color_section_content',
        ),
      'color_content_meta_link' => array(
          'label'   => __( 'Meta Link Color', 'wen-business-pro' ),
          'section' => 'color_section_content',
        ),
      'color_content_meta_link_hover' => array(
          'label'   => __( 'Meta Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_content',
        ),
      'color_content_meta_icon' => array(
          'label'   => __( 'Meta Icon Color', 'wen-business-pro' ),
          'section' => 'color_section_content',
        ),

      // Sidebar
      'color_sidebar_background' => array(
          'label'   => __( 'Background Color', 'wen-business-pro' ),
          'section' => 'color_section_sidebar',
        ),
      'color_sidebar_widget_background' => array(
          'label'   => __( 'Widget Background Color', 'wen-business-pro' ),
          'section' => 'color_section_sidebar',
        ),
      'color_sidebar_widget_title' => array(
          'label'   => __( 'Widget Title Color', 'wen-business-pro' ),
          'section' => 'color_section_sidebar',
        ),
      'color_sidebar_widget_text' => array(
          'label'   => __( 'Widget Text Color', 'wen-business-pro' ),
          'section' => 'color_section_sidebar',
        ),
      'color_sidebar_widget_link' => array(
          'label'   => __( 'Widget Link Color', 'wen-business-pro' ),
          'section' => 'color_section_sidebar',
        ),
      'color_sidebar_widget_link_hover' => array(
          'label'   => __( 'Widget Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_sidebar',
        ),

      // Home Page Widgets
      'color_home_widgets_title' => array(
          'label'   => __( 'Widget Title Color', 'wen-business-pro' ),
          'section' => 'color_section_home_widgets',
        ),
      'color_home_widgets_title_background' => array(
          'label'   => __( 'Widget Title Background Color', 'wen-business-pro' ),
          'section' => 'color_section_home_widgets',
        ),

      // Primary Menu
      'color_primary_menu_main_background' => array(
          'label'   => __( 'Main Background Color', 'wen-business-pro' ),
          'section' => 'color_section_primary_menu',
        ),
      'color_primary_menu_main_link' => array(
          'label'   => __( 'Main Link Color', 'wen-business-pro' ),
          'section' => 'color_section_primary_menu',
        ),
      'color_primary_menu_main_link_hover' => array(
          'label'   => __( 'Main Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_primary_menu',
        ),
      'color_primary_menu_main_underline' => array(
          'label'   => __( 'Main Underline Color', 'wen-business-pro' ),
          'section' => 'color_section_primary_menu',
        ),
      'color_primary_menu_submenu_background' => array(
          'label'   => __( 'Sub Menu Background Color', 'wen-business-pro' ),
          'section' => 'color_section_primary_menu',
        ),
      'color_primary_menu_submenu_link' => array(
          'label'   => __( 'Sub Menu Link Color', 'wen-business-pro' ),
          'section' => 'color_section_primary_menu',
        ),
      'color_primary_menu_submenu_link_hover' => array(
          'label'   => __( 'Sub Menu Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_primary_menu',
        ),
      'color_primary_menu_icon' => array(
          'label'   => __( 'Icon Color', 'wen-business-pro' ),
          'section' => 'color_section_primary_menu',
        ),

      // Secondary Menu
      'color_secondary_menu_main_background' => array(
          'label'   => __( 'Main Background Color', 'wen-business-pro' ),
          'section' => 'color_section_secondary_menu',
        ),
      'color_secondary_menu_main_link' => array(
          'label'   => __( 'Main Link Color', 'wen-business-pro' ),
          'section' => 'color_section_secondary_menu',
        ),
      'color_secondary_menu_main_link_hover' => array(
          'label'   => __( 'Main Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_secondary_menu',
        ),
      'color_secondary_menu_submenu_background' => array(
          'label'   => __( 'Sub Menu Background Color', 'wen-business-pro' ),
          'section' => 'color_section_secondary_menu',
        ),
      'color_secondary_menu_submenu_link' => array(
          'label'   => __( 'Sub Menu Link Color', 'wen-business-pro' ),
          'section' => 'color_section_secondary_menu',
        ),
      'color_secondary_menu_submenu_link_hover' => array(
          'label'   => __( 'Sub Menu Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_secondary_menu',
        ),
      'color_secondary_menu_icon' => array(
          'label'   => __( 'Icon Color', 'wen-business-pro' ),
          'section' => 'color_section_secondary_menu',
        ),

      // Footer menu
      'color_footer_menu_background' => array(
          'label'   => __( 'Background Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_menu',
        ),
      'color_footer_menu_link' => array(
          'label'   => __( 'Link Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_menu',
        ),
      'color_footer_menu_link_hover' => array(
          'label'   => __( 'Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_menu',
        ),

      // Go To Top
      'color_goto_top_icon' => array(
          'label'   => __( 'Icon Color', 'wen-business-pro' ),
          'section' => 'color_section_goto_top',
        ),
      'color_goto_top_icon_hover' => array(
          'label'   => __( 'Icon Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_goto_top',
        ),

      // Pagination
      'color_pagination_link' => array(
          'label'   => __( 'Link Color', 'wen-business-pro' ),
          'section' => 'color_section_pagination',
        ),
      'color_pagination_link_hover' => array(
          'label'   => __( 'Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_pagination',
        ),
      'color_pagination_link_background' => array(
          'label'   => __( 'Link Background Color', 'wen-business-pro' ),
          'section' => 'color_section_pagination',
        ),
      'color_pagination_link_background_hover' => array(
          'label'   => __( 'Link Background Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_pagination',
        ),

      // Slider
      'color_slider_caption_background' => array(
          'label'   => __( 'Caption Background Color', 'wen-business-pro' ),
          'section' => 'color_section_slider',
        ),
      'color_slider_caption_title' => array(
          'label'   => __( 'Caption Title Color', 'wen-business-pro' ),
          'section' => 'color_section_slider',
        ),
      'color_slider_caption_title_hover' => array(
          'label'   => __( 'Caption Title Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_slider',
        ),
      'color_slider_caption_text' => array(
          'label'   => __( 'Caption Text Color', 'wen-business-pro' ),
          'section' => 'color_section_slider',
        ),
      'color_slider_next_prev_icon' => array(
          'label'   => __( 'Next Previous Icon Color', 'wen-business-pro' ),
          'section' => 'color_section_slider',
        ),
      'color_slider_next_prev_icon_hover' => array(
          'label'   => __( 'Next Previous Icon Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_slider',
        ),
      'color_slider_pager' => array(
          'label'   => __( 'Pager Color', 'wen-business-pro' ),
          'section' => 'color_section_slider',
        ),
      'color_slider_pager_hover' => array(
          'label'   => __( 'Pager Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_slider',
        ),

      // Footer Widgets
      'color_footer_widgets_background' => array(
          'label'   => __( 'Background Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_widgets',
        ),
      'color_footer_widgets_title' => array(
          'label'   => __( 'Title Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_widgets',
        ),
      'color_footer_widgets_text' => array(
          'label'   => __( 'Text Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_widgets',
        ),
      'color_footer_widgets_link' => array(
          'label'   => __( 'Link Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_widgets',
        ),
      'color_footer_widgets_link_hover' => array(
          'label'   => __( 'Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_widgets',
        ),

      // Footer Copyright
      'color_footer_copyright_background' => array(
          'label'   => __( 'Background Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_copyright',
        ),
      'color_footer_copyright_text' => array(
          'label'   => __( 'Text Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_copyright',
        ),
      'color_footer_copyright_link' => array(
          'label'   => __( 'Link Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_copyright',
        ),
      'color_footer_copyright_link_hover' => array(
          'label'   => __( 'Link Hover Color', 'wen-business-pro' ),
          'section' => 'color_section_footer_copyright',
        ),

      // Content Box
      'color_content_box_background' => array(
          'label'   => __( 'Background Color', 'wen-business-pro' ),
          'section' => 'color_section_content_box',
        ),


    );
    return $choices;

  }

endif;

if( ! function_exists( 'wen_business_get_color_sections_options' ) ) :

  /**
   * Returns color sections options.
   *
   * @since WEN Business 1.0
   */
  function wen_business_get_color_sections_options(){

    $choices = array(
      'color_section_basic' => array(
          'label' => __( 'Basic Color Options', 'wen-business-pro' ),
        ),
      'color_section_header_top' => array(
          'label' => __( 'Top Header Color Options', 'wen-business-pro' ),
        ),
      'color_section_header' => array(
          'label' => __( 'Header Color Options', 'wen-business-pro' ),
        ),
      'color_section_primary_menu' => array(
          'label' => __( 'Primary Menu Color Options', 'wen-business-pro' ),
        ),
      'color_section_secondary_menu' => array(
          'label' => __( 'Secondary Menu Color Options', 'wen-business-pro' ),
        ),
      'color_section_slider' => array(
          'label' => __( 'Slider Color Options', 'wen-business-pro' ),
        ),
      'color_section_home_widgets' => array(
          'label' => __( 'Home Page Widgets Color Options', 'wen-business-pro' ),
        ),
      'color_section_content_box' => array(
          'label' => __( 'Content Box Color Options', 'wen-business-pro' ),
        ),
      'color_section_content' => array(
          'label' => __( 'Content Color Options', 'wen-business-pro' ),
        ),
      'color_section_sidebar' => array(
          'label' => __( 'Sidebar Color Options', 'wen-business-pro' ),
        ),
      'color_section_footer_menu' => array(
          'label' => __( 'Footer Menu Color Options', 'wen-business-pro' ),
        ),
      'color_section_goto_top' => array(
          'label' => __( 'Go To Top Color Options', 'wen-business-pro' ),
        ),
      'color_section_pagination' => array(
          'label' => __( 'Pagination Color Options', 'wen-business-pro' ),
        ),
      'color_section_footer_widgets' => array(
          'label' => __( 'Footer Widgets Color Options', 'wen-business-pro' ),
        ),
      'color_section_footer_copyright' => array(
          'label' => __( 'Footer Copyright Color Options', 'wen-business-pro' ),
        ),
    );
    return $choices;

  }

endif;


