<?php

if( ! function_exists( 'wen_business_trigger_custom_css_action' ) ) :

  /**
   * Do action theme custom CSS
   *
   * @since  WEN Business 1.0
   */
  function wen_business_trigger_custom_css_action(){

    do_action( 'wen_business_action_theme_custom_css' );

  }

endif;

add_action( 'wp_head', 'wen_business_trigger_custom_css_action', 99 );


if( ! function_exists( 'wen_business_add_basic_custom_css' ) ) :

  /**
   * Add basic custom CSS
   *
   * @since  WEN Business 1.0
   */
  function wen_business_add_basic_custom_css(){

    $custom_css = '';

    // Header top icon size
    $header_icon_size = wen_business_get_option( 'header_icon_size' );
    if ( absint( $header_icon_size ) > 0 ) {
      $custom_css .= '.header-top-inner .wen_business_widget_social a:before{font-size:' . esc_attr( $header_icon_size ) .'px;}';
    }

    // Render style
    if ( ! empty( $custom_css ) ) {
      echo '<style type="text/css">';
      echo $custom_css;
      echo '</style>';
    }

    return ;

  }

endif;

add_action( 'wen_business_action_theme_custom_css', 'wen_business_add_basic_custom_css', 10 );


if( ! function_exists( 'wen_business_add_theme_custom_font_css' ) ) :

  /**
   * Inject theme custom font CSS
   *
   * @since  WEN Business 1.0
   */
  function wen_business_add_theme_custom_font_css(){

    $custom_css = '';

    $font_settings = wen_business_get_font_family_theme_settings_options();

    $required_fonts = array();

    if ( ! empty( $font_settings ) ) {
      foreach ($font_settings as $key => $val ) {
        $option_value = wen_business_get_option( $key );
        if ( ! empty( $option_value ) && $val['default'] != $option_value ) {
          $required_fonts[ $key ] =  $option_value;
        }
      }
    }
    if ( empty( $required_fonts ) ) {
      // We do not need extra CSS
      return;
    }

    foreach ($required_fonts as $key => $font ) {

      $family = wen_business_get_font_family_from_key( $font );

      if ( ! empty( $family ) ) {

        switch ( $key ) {
          case 'font_site_default':
            $custom_css .= 'body{font-family:' . $family . '}' . "\n";
            break;

          case 'font_site_title':
            $custom_css .= '.site-title{font-family:' . $family . '}' . "\n";
            break;

          case 'font_site_tagline':
            $custom_css .= '.site-description{font-family:' . $family . '}' . "\n";
            break;

          case 'font_heading_tags':
            $custom_css .= 'h1,h2,h3,h4,h5,h6{font-family:' . $family . '}' . "\n";
            break;

          case 'font_content_title':
            $custom_css .= '.entry-header .entry-title{font-family:' . $family . '}' . "\n";
            break;

          case 'font_content_body':
            $custom_css .= '#content,#content p{font-family:' . $family . '}' . "\n";
            break;

          case 'font_navigation':
            $custom_css .= '#site-navigation ul li a,#secondary-navigation ul li a{font-family:' . $family . '}' . "\n";
            break;

          default:
            break;
        }
        #
      }
    }

    // Render style
    if ( ! empty( $custom_css ) ) {
      echo '<style type="text/css">';
      echo $custom_css;
      echo '</style>';
    }

    return ;

  }

endif;

add_action( 'wen_business_action_theme_custom_css', 'wen_business_add_theme_custom_font_css', 20 );


if( ! function_exists( 'wen_business_add_theme_custom_color_css' ) ) :

  /**
   * Inject theme custom color CSS
   *
   * @since 1.0
   */
  function wen_business_add_theme_custom_color_css(){

    $custom_css = '';

    $color_settings = wen_business_get_color_theme_settings_options();

    $default = wen_business_get_default_colors();

    $required_colors = array();

    if ( ! empty( $color_settings ) ) {
      foreach ($color_settings as $key => $val ) {
        $option_value = wen_business_get_option( $key );
        if ( ! empty( $option_value ) && $default[$key] != $option_value ) {
          $required_colors[ $key ] =  $option_value;
        }
      }
    }
    if ( empty( $required_colors ) ) {
      // We do not need extra CSS.
      return;
    }

    foreach ( $required_colors as $key => $color ) {

      switch ( $key ) {

        // Basic
        case 'color_basic_background':
          $custom_css .= 'body{background-color:' . $color . '}' . "\n";
          break;
        case 'color_basic_text':
          $custom_css .= 'body,p{color:' . $color . '}' . "\n";
          break;
        case 'color_basic_link':
          $custom_css .= 'a{color:' . $color . '}' . "\n";
          break;
        case 'color_basic_link_hover':
          $custom_css .= 'a:hover{color:' . $color . '}' . "\n";
          break;
        case 'color_basic_heading':
          $custom_css .= 'h1,h2,h3,h4,h5,h6{color:' . $color . '}' . "\n";
          break;
        case 'color_basic_button_text':
          $custom_css .= 'button, input[type="button"], input[type="reset"], input[type="submit"]{color:' . $color . '}' . "\n";
          if ( class_exists( 'WooCommerce' ) ) {
            $custom_css .= '.woocommerce #respond input#submit.alt,  .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{color:' . $color . '}' . "\n";
            # code...
          }
          break;

        case 'color_basic_button_text_hover':
          $custom_css .= 'button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover{color:' . $color . '}' . "\n";
          if ( class_exists( 'WooCommerce' ) ) {
            $custom_css .= '.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover,.woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover.woocommerce #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover{color:' . $color . '}' . "\n";
            # code...
          }
          break;
        case 'color_basic_button_background':
          $custom_css .= 'button, input[type="button"], input[type="reset"], input[type="submit"]{background-color:' . $color . '}' . "\n";
          if ( class_exists( 'WooCommerce' ) ) {
            $custom_css .= '.woocommerce #respond input#submit.alt,  .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce #respond input#submit, .woocommerce a.button, .woocommerce button.button, .woocommerce input.button{background-color:' . $color . '}' . "\n";
          }
          break;
        case 'color_basic_button_background_hover':
          $custom_css .= 'button:hover, input[type="button"]:hover, input[type="reset"]:hover, input[type="submit"]:hover{background-color:' . $color . '}' . "\n";
          if ( class_exists( 'WooCommerce' ) ) {
            $custom_css .= '.woocommerce #respond input#submit.alt:hover, .woocommerce a.button.alt:hover,.woocommerce button.button.alt:hover, .woocommerce input.button.alt:hover,.woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover.woocommerce #respond input#submit.alt.disabled, .woocommerce #respond input#submit.alt.disabled:hover, .woocommerce #respond input#submit.alt:disabled, .woocommerce #respond input#submit.alt:disabled:hover, .woocommerce #respond input#submit.alt[disabled]:disabled, .woocommerce #respond input#submit.alt[disabled]:disabled:hover, .woocommerce a.button.alt.disabled, .woocommerce a.button.alt.disabled:hover, .woocommerce a.button.alt:disabled, .woocommerce a.button.alt:disabled:hover, .woocommerce a.button.alt[disabled]:disabled, .woocommerce a.button.alt[disabled]:disabled:hover, .woocommerce button.button.alt.disabled, .woocommerce button.button.alt.disabled:hover, .woocommerce button.button.alt:disabled, .woocommerce button.button.alt:disabled:hover, .woocommerce button.button.alt[disabled]:disabled, .woocommerce button.button.alt[disabled]:disabled:hover, .woocommerce input.button.alt.disabled, .woocommerce input.button.alt.disabled:hover, .woocommerce input.button.alt:disabled, .woocommerce input.button.alt:disabled:hover, .woocommerce input.button.alt[disabled]:disabled, .woocommerce input.button.alt[disabled]:disabled:hover, .woocommerce #respond input#submit:hover, .woocommerce a.button:hover, .woocommerce button.button:hover, .woocommerce input.button:hover:hover{background-color:' . $color . '}' . "\n";
            # code...
          }
          break;

        // Header
        case 'color_header_background':
          $custom_css .= '.site-header{background-color:' . $color . '}' . "\n";
          break;
        case 'color_header_title':
          $custom_css .= '.site-title a{color:' . $color . '}' . "\n";
          break;
        case 'color_header_title_hover':
          $custom_css .= '.site-title a:hover{color:' . $color . '}' . "\n";
          break;
        case 'color_header_tagline':
          $custom_css .= '.site-description{color:' . $color . '}' . "\n";
          break;

        // Header Top
        case 'color_header_top_background':
          $custom_css .= '.header-top-inner{background-color:' . $color . '}' . "\n";
          $custom_css .= '#header-top-content{border-top: 10px solid ' . $color . '}' . "\n";
          break;
        case 'color_header_top_icon':
          $custom_css .= '.header-top .wen_business_widget_social ul li a:before, #header-search-form input[type="submit"], #header-search-form input[type="text"]{color:' . $color . '}' . "\n";
          $custom_css .= '.header-top .wen_business_widget_social li a{border-color:' . $color . '}' . "\n";
          break;

        // Primary Navigation
        case 'color_primary_menu_main_background':
          $custom_css .= '#site-navigation{background-color:' . $color . '}' . "\n";
          break;
        case 'color_primary_menu_main_link':
          $custom_css .= '#site-navigation ul li a{color:' . $color . '}' . "\n";
          break;
        case 'color_primary_menu_icon':
          $custom_css .= '#site-navigation ul li.menu-item-has-children > a:before, #site-navigation ul li.page_item_has_children > a:before{color:' . $color . '}' . "\n";
          break;
        case 'color_primary_menu_main_link_hover':
          $custom_css .= '#site-navigation .current_page_item a:after, #site-navigation .current-menu-item a:after, #site-navigation ul li a:hover:after{background-color:' . $color . '}' . "\n";
          $custom_css .= '#site-navigation ul li a:hover,#site-navigation ul li:hover > a,#site-navigation ul li.menu-item-has-children:hover > a:before,#site-navigation ul li.page_item_has_children:hover > a:before,#site-navigation  li.current_page_item > a,
#site-navigation  li.current-menu-item > a{color:' . $color . '}' . "\n";
          break;
        case 'color_primary_menu_main_underline':
          $custom_css .= '#site-navigation ul li a::after,#site-navigation .current_page_item a:after, #site-navigation .current-menu-item a:after{background-color:' . $color . '}' . "\n";
          break;
        case 'color_primary_menu_submenu_background':
          $custom_css .= '#site-navigation ul ul{background-color:' . $color . '}' . "\n";
          break;
        case 'color_primary_menu_submenu_link':
          $custom_css .= '#site-navigation ul ul li a{color:' . $color . '}' . "\n";
          break;
        case 'color_primary_menu_submenu_link_hover':
          $custom_css .= '#site-navigation ul ul li a:hover, #site-navigation ul ul li.current_page_item a, #site-navigation ul ul li.current-menu-item a, #site-navigation ul ul li:hover > a,#site-navigation ul li li.menu-item-has-children:hover > a:before,#site-navigation ul li li.page_item_has_children:hover > a:before{color:' . $color . '}' . "\n";
          break;

        // Secondary Navigation
        case 'color_secondary_menu_main_background':
          $custom_css .= '#secondary-navigation{background-color:' . $color . '}' . "\n";
          break;
        case 'color_secondary_menu_main_link':
          $custom_css .= '#secondary-navigation ul li a{color:' . $color . '}' . "\n";
          break;
        case 'color_secondary_menu_icon':
          $custom_css .= '#secondary-navigation ul li.menu-item-has-children > a:before, #secondary-navigation ul li.page_item_has_children > a:before{color:' . $color . '}' . "\n";
          break;
        case 'color_secondary_menu_main_link_hover':
          $custom_css .= '#secondary-navigation .current_page_item a:after, #secondary-navigation .current-menu-item a:after, #secondary-navigation ul li a:hover:after{background-color:' . $color . '}' . "\n";
          $custom_css .= '#secondary-navigation ul li a:hover,#secondary-navigation ul li:hover > a,#secondary-navigation ul li.menu-item-has-children:hover > a:before,#secondary-navigation ul li.page_item_has_children:hover > a:before,#secondary-navigation  li.current_page_item > a,
#secondary-navigation  li.current-menu-item > a{color:' . $color . '}' . "\n";
          break;
        case 'color_secondary_menu_main_underline':
          $custom_css .= '#secondary-navigation ul li a::after,#secondary-navigation .current_page_item a:after, #secondary-navigation .current-menu-item a:after{background-color:' . $color . '}' . "\n";
          break;
        case 'color_secondary_menu_submenu_background':
          $custom_css .= '#secondary-navigation ul ul{background-color:' . $color . '}' . "\n";
          break;
        case 'color_secondary_menu_submenu_link':
          $custom_css .= '#secondary-navigation ul ul li a{color:' . $color . '}' . "\n";
          break;
        case 'color_secondary_menu_submenu_link_hover':
          $custom_css .= '#secondary-navigation ul ul li a:hover, #secondary-navigation ul ul li.current_page_item a, #secondary-navigation ul ul li.current-menu-item a, #secondary-navigation ul ul li:hover > a,#secondary-navigation ul li li.menu-item-has-children:hover > a:before,#secondary-navigation ul li li.page_item_has_children:hover > a:before{color:' . $color . '}' . "\n";
          break;


        // Slider
        case 'color_slider_caption_background':
          $custom_css .= '#main-slider .cycle-caption{background-color:' . $color . '}' . "\n";
          break;
        case 'color_slider_caption_title':
          $custom_css .= '#main-slider .cycle-caption h3 a{color:' . $color . '}' . "\n";
          break;
        case 'color_slider_caption_title_hover':
          $custom_css .= '#main-slider .cycle-caption h3 a:hover{color:' . $color . '}' . "\n";
          break;
        case 'color_slider_caption_text':
          $custom_css .= '#main-slider .cycle-caption p{color:' . $color . '}' . "\n";
          break;
        case 'color_slider_next_prev_icon':
          $custom_css .= '#main-slider .cycle-prev:after, #main-slider .cycle-next:after{color:' . $color . '}' . "\n";
          break;
        case 'color_slider_next_prev_icon_hover':
          $custom_css .= '#main-slider .cycle-prev:hover:after, #main-slider .cycle-next:hover:after{color:' . $color . '}' . "\n";
          break;
        case 'color_slider_pager':
          $custom_css .= '#main-slider .pager-box{background-color:' . $color . ';border:1px ' . $color . ' solid}' . "\n";
          break;
        case 'color_slider_pager_hover':
          $custom_css .= '#main-slider .pager-box:hover, #main-slider .pager-box.cycle-pager-active{background-color:' . $color . ';border:1px ' . $color . ' solid}' . "\n";
          break;

        // Home Page Widgets
        case 'color_home_widgets_title':
          $custom_css .= '#sidebar-front-page-widget-area .widget-title span{color:' . $color . '}' . "\n";
          break;
        case 'color_home_widgets_title_background':
          $custom_css .= '#sidebar-front-page-widget-area .widget-title span, #sidebar-front-page-widget-area .widget-title span::after{background-color:' . $color . '}' . "\n";
          break;

        // Content Box
        case 'color_content_box_background':
          $custom_css .= '#content{background-color:' . $color . '}' . "\n";
          break;

        // Content
        case 'color_content_background':
          $custom_css .= '#primary{background-color:' . $color . '}' . "\n";
          break;
        case 'color_content_title':
          $custom_css .= '.entry-header .entry-title, .entry-header .entry-title a{color:' . $color . '}' . "\n";
          break;
        case 'color_content_text':
          $custom_css .= '#primary p{color:' . $color . '}' . "\n";
          break;
        case 'color_content_link':
          $custom_css .= '#primary a{color:' . $color . '}' . "\n";
          break;
        case 'color_content_link_hover':
          $custom_css .= '#primary a:hover{color:' . $color . '}' . "\n";
          break;
        case 'color_content_meta_text':
          $custom_css .= '.posted-on > a, .byline a{color:' . $color . '}' . "\n";
          break;
        case 'color_content_meta_link':
          $custom_css .= '.posted-on > a, .byline a{color:' . $color . '}' . "\n";
          break;
        case 'color_content_meta_link_hover':
          $custom_css .= '.posted-on > a:hover, .byline a:hover{color:' . $color . '}' . "\n";
          break;
        case 'color_content_meta_icon':
          $custom_css .= '.posted-on:after, .byline:after, .comment:after{color:' . $color . '}' . "\n";
          break;

        // Sidebar
        case 'color_sidebar_background':
          $custom_css .= '.sidebar{background-color:' . $color . '}' . "\n";
          break;
        case 'color_sidebar_widget_background':
          $custom_css .= '.sidebar .widget{background-color:' . $color . '}' . "\n";
          break;
        case 'color_sidebar_widget_title':
          $custom_css .= '.sidebar .widget-title{color:' . $color . '}' . "\n";
          break;
        case 'color_sidebar_widget_text':
          $custom_css .= '.sidebar{color:' . $color . '}' . "\n";
          break;
        case 'color_sidebar_widget_link':
          $custom_css .= '.sidebar a{color:' . $color . '}' . "\n";
          break;
        case 'color_sidebar_widget_link_hover':
          $custom_css .= '.sidebar a:hover{color:' . $color . '}' . "\n";
          break;

        // Footer Widgets
        case 'color_footer_widgets_background':
          $custom_css .= '#footer-widgets{background-color:' . $color . '}' . "\n";
          break;
        case 'color_footer_widgets_title':
          $custom_css .= '#footer-widgets .widget-title{color:' . $color . '}' . "\n";
          break;
        case 'color_footer_widgets_text':
          $custom_css .= '#footer-widgets{color:' . $color . '}' . "\n";
          break;
        case 'color_footer_widgets_link':
          $custom_css .= '#footer-widgets a{color:' . $color . '}' . "\n";
          break;
        case 'color_footer_widgets_link_hover':
          $custom_css .= '#footer-widgets a:hover{color:' . $color . '}' . "\n";
          break;

        // Footer Menu
        case 'color_footer_menu_background':
          $custom_css .= '#footer-nav {background-color:' . $color . '}' . "\n";
          break;
        case 'color_footer_menu_link':
          $custom_css .= '#footer-nav a{color:' . $color . '}' . "\n";
          break;
        case 'color_footer_menu_link_hover':
          $custom_css .= '#footer-nav a:hover{color:' . $color . '}' . "\n";
          break;

        // Footer Copyright
        case 'color_footer_copyright_background':
          $custom_css .= '#colophon{background-color:' . $color . '}' . "\n";
          break;
        case 'color_footer_copyright_text':
          $custom_css .= '#colophon{color:' . $color . '}' . "\n";
          break;
        case 'color_footer_copyright_link':
          $custom_css .= '#colophon a{color:' . $color . '}' . "\n";
          break;
        case 'color_footer_copyright_link_hover':
          $custom_css .= '#colophon a:hover{color:' . $color . '}' . "\n";
          break;

        // Go To Top
        case 'color_goto_top_icon':
          $custom_css .= '.scrollup{color:' . $color . '}' . "\n";
          break;
        case 'color_goto_top_icon_hover':
          $custom_css .= '.scrollup:hover{color:' . $color . '}' . "\n";
          break;

        // Pagination.
        case 'color_pagination_link':
          $custom_css .= '.navigation .nav-links a{color:' . $color . '}' . "\n";
          break;
        case 'color_pagination_link_hover':
          $custom_css .= '.navigation .nav-links a:hover,.wp-pagenavi span.pages, .wp-pagenavi span.current, .pagination .current{color:' . $color . '}' . "\n";
          break;
        case 'color_pagination_link_background':
          $custom_css .= '.navigation .nav-links a{background-color:' . $color . '}' . "\n";
          break;
        case 'color_pagination_link_background_hover':
          $custom_css .= ' .navigation .nav-links a:hover,.wp-pagenavi span.pages, .wp-pagenavi span.current, .pagination .current{background-color:' . $color . '}' . "\n";
          break;

        default:
          break;

      } // end switch

    } //end if


    // Render style
    if ( ! empty( $custom_css ) ) {
      echo '<style type="text/css">';
      echo $custom_css;
      echo '</style>';
    }

    return ;

  }

endif;

add_action( 'wen_business_action_theme_custom_css', 'wen_business_add_theme_custom_color_css', 30 );
