<?php

// Check custom header status
add_filter( 'wen_business_filter_custom_header_status', 'wen_business_check_custom_header_status' );

// Custom header details
add_filter( 'wen_business_filter_custom_header_details', 'wen_business_get_custom_header_details' );

/////////////////////////////////////////////////////

if( ! function_exists( 'wen_business_add_custom_header_content' ) ) :

  /**
   * Add custom header content.
   *
   * @since  WEN Business 1.0
   */
  function wen_business_add_custom_header_content(){

    $flag_apply_custom_header = apply_filters( 'wen_business_filter_custom_header_status', false );
    if ( true != $flag_apply_custom_header ) {
      return false;
    }

    $custom_header_details = array();
    $custom_header_details = apply_filters( 'wen_business_filter_custom_header_details', $custom_header_details );

    if ( empty( $custom_header_details ) ) {
      return;
    }

    // Render custom header now
    wen_business_render_custom_header( $custom_header_details );

  }

endif;

add_action( 'wen_business_action_before_content', 'wen_business_add_custom_header_content', 6 );


if ( ! function_exists( 'wen_business_render_custom_header' ) ) :

  /**
   * Render custom header.
   *
   * @since WEN Business 1.0
   *
   */
  function wen_business_render_custom_header( $detail ) {

    if ( empty( $detail ) ) {
      return;
    }
    $image_attr = array();
    if ( isset( $detail['image_url'] ) && ! empty( $detail['image_url'] ) ) {
      $image_attr['src'] = esc_url( $detail['image_url'] );
    }
    if ( isset( $detail['image_width'] ) && ! empty( $detail['image_width'] ) ) {
      $image_attr['width'] = absint( $detail['image_width'] );
    }
    if ( isset( $detail['image_height'] ) && ! empty( $detail['image_height'] ) ) {
      $image_attr['height'] = absint( $detail['image_height'] );
    }
    if ( isset( $detail['image_alt'] ) && ! empty( $detail['image_alt'] ) ) {
      $image_attr['alt'] = esc_attr( $detail['image_alt'] );
    }
    $image_attr_text = '';
    if ( ! empty( $image_attr ) ) {
      foreach ( $image_attr as $key => $attr ) {
        $image_attr_text .= ' ' . $key . '="' . $attr .'"';
      }
    }

    $link_open = '';
    $link_close = '';
    if ( isset( $detail['link_url'] ) && ! empty( $detail['link_url'] ) ) {
      $target_text = '';
      if ( isset( $detail['link_url_open'] ) && true == $detail['link_url_open'] ) {
        $target_text = ' target="_blank" ';
      }
      $link_open = '<a href="' . esc_url( $detail['link_url'] ) . '" ' . $target_text . '>';
      $link_close = '</a>';
    }
    $image_tag = sprintf('<img %s />', $image_attr_text );
    echo '<div id="custom-header">';
    printf('%s%s%s',
      $link_open,
      $image_tag,
      $link_close
    );
    echo '</div>';

  }
endif;

if ( ! function_exists( 'wen_business_get_custom_header_details' ) ) :

  /**
   * Get custom header details.
   *
   * @since WEN Business 1.0
   *
   */
  function wen_business_get_custom_header_details() {

    $output = array();

    if ( get_header_image() ){
      $output['image_url']     = get_header_image();
      $output['image_width']   = get_custom_header()->width;
      $output['image_height']  = get_custom_header()->height;
      $output['image_alt']     = esc_attr( wen_business_get_option( 'ch_image_alt' ) );
      $output['link_url']      = esc_url( wen_business_get_option( 'ch_link_url' ) );
      $output['link_url_open'] = wen_business_get_option( 'ch_link_url_open' );
    }

    return $output;

  }
endif;


if ( ! function_exists( 'wen_business_check_custom_header_status' ) ) :

  /**
   * Check status of custom header.
   *
   * @since WEN Business 1.0
   *
   */
  function wen_business_check_custom_header_status( $input ) {

    $ch_status = wen_business_get_option( 'ch_status' );

    if ( 'entire-site' == $ch_status ) {
      $input = true;
    }
    elseif ( 'disabled' == $ch_status ) {
      $input = false;
    }
    elseif ( 'home-page' == $ch_status ) {
      if ( is_front_page() || is_home() ) {
        $input = true;
      }
    }
    elseif ( 'entire-site-except-home' == $ch_status ) {
      if ( !( is_front_page() || is_home() ) ) {
        $input = true;
      }
    }

    return $input;

  }
endif;
