<?php

if ( ! function_exists( 'wen_business_custom_body_class' ) ) :
  /**
   * Custom body class
   *
   * @since WEN Business 1.0
   *
   */
function wen_business_custom_body_class( $input ) {

    // Site layout
  $site_layout = wen_business_get_option( 'site_layout' );
  $input[] = 'site-layout-' . esc_attr( $site_layout );

    // Global layout
  global $post;
  $global_layout = wen_business_get_option( 'global_layout' );
  $global_layout = apply_filters( 'wen_business_filter_theme_global_layout', $global_layout );
    // Check if single
  if ( $post  && is_singular() ) {
    $post_options = get_post_meta( $post->ID, 'theme_settings', true );
    if ( isset( $post_options['post_layout'] ) && ! empty( $post_options['post_layout'] ) ) {
      $global_layout = $post_options['post_layout'];
    }
  }

  $input[] = 'global-layout-' . esc_attr( $global_layout );

  return $input;
}
endif;
add_filter( 'body_class', 'wen_business_custom_body_class' );


if ( ! function_exists( 'wen_business_custom_content_class' ) ) :

  /**
   * Custom Primary class
   *
   * @since WEN Business 1.0
   *
   */
function wen_business_custom_content_class( $input ) {

  global $post;
  $global_layout = wen_business_get_option( 'global_layout' );
  $global_layout = apply_filters( 'wen_business_filter_theme_global_layout', $global_layout );
    // Check if single
  if ( $post  && is_singular() ) {
    $post_options = get_post_meta( $post->ID, 'theme_settings', true );
    if ( isset( $post_options['post_layout'] ) && ! empty( $post_options['post_layout'] ) ) {
      $global_layout = $post_options['post_layout'];
    }
  }

  $new_class = '';

  switch ( $global_layout ) {
    case 'left-sidebar':
    case 'right-sidebar':
      $new_class = 'col-sm-8';
      break;

    case 'three-columns':
    case 'three-columns-pcs':
    case 'three-columns-cps':
    case 'three-columns-psc':
      $new_class = 'col-sm-6';
      break;

    case 'three-columns-pcs-equal':
    case 'three-columns-scp-equal':
      $new_class = 'col-sm-4';
      break;

    case 'no-sidebar':
      $new_class = 'col-sm-12';
      break;

    case 'no-sidebar-centered':
      $new_class = 'col-sm-6';
      break;

    default:
      break;
  }
  if ( ! empty( $new_class ) ) {
    $input[] = $new_class;
  }

  return $input;
}
endif;
add_filter( 'wen_business_filter_content_class', 'wen_business_custom_content_class' );


if ( ! function_exists( 'wen_business_custom_sidebar_primary_class' ) ) :
  /**
   * Custom Sidebar Primary class
   *
   * @since WEN Business 1.0
   *
   */
function wen_business_custom_sidebar_primary_class( $input ) {


  global $post;
  $global_layout = wen_business_get_option( 'global_layout' );
  $global_layout = apply_filters( 'wen_business_filter_theme_global_layout', $global_layout );
    // Check if single
  if ( $post && is_singular() ) {
    $post_options = get_post_meta( $post->ID, 'theme_settings', true );
    if ( isset( $post_options['post_layout'] ) && ! empty( $post_options['post_layout'] ) ) {
      $global_layout = $post_options['post_layout'];
    }
  }

  $new_class = '';

  switch ( $global_layout ) {
    case 'three-columns':
    case 'three-columns-pcs':
    case 'three-columns-cps':
    case 'three-columns-psc':
      $new_class = 'col-sm-3';
      break;

    case 'three-columns-pcs-equal':
    case 'three-columns-scp-equal':
      $new_class = 'col-sm-4';
      break;

    case 'left-sidebar':
    case 'right-sidebar':
      $new_class = 'col-sm-4';
      break;

    default:
      break;
  }
  if ( ! empty( $new_class ) ) {
    $input[] = $new_class;
  }

  return $input;
}
endif;
add_filter( 'wen_business_filter_sidebar_primary_class', 'wen_business_custom_sidebar_primary_class' );


if ( ! function_exists( 'wen_business_custom_sidebar_secondary_class' ) ) :

  /**
   * Custom Sidebar Secondary class
   *
   * @since WEN Business 1.0
   *
   */
function wen_business_custom_sidebar_secondary_class( $input ) {

  global $post;
  $global_layout = wen_business_get_option( 'global_layout' );
  $global_layout = apply_filters( 'wen_business_filter_theme_global_layout', $global_layout );
    // Check if single
  if ( $post  && is_singular() ) {
    $post_options = get_post_meta( $post->ID, 'theme_settings', true );
    if ( isset( $post_options['post_layout'] ) && ! empty( $post_options['post_layout'] ) ) {
      $global_layout = $post_options['post_layout'];
    }
  }

  $new_class = '';

  switch ( $global_layout ) {
    case 'three-columns':
    case 'three-columns-pcs':
    case 'three-columns-cps':
    case 'three-columns-psc':
      $new_class = 'col-sm-3';
      break;

    case 'three-columns-pcs-equal':
    case 'three-columns-scp-equal':
      $new_class = 'col-sm-4';
      break;

    default:
      break;
  }
  if ( ! empty( $new_class ) ) {
    $input[] = $new_class;
  }

  return $input;
}
endif;

add_filter( 'wen_business_filter_sidebar_secondary_class', 'wen_business_custom_sidebar_secondary_class' );



if ( ! function_exists( 'wen_business_custom_content_width' ) ) :

  /**
   * Custom Content Width
   *
   * @since WEN Business 1.0
   *
   */
function wen_business_custom_content_width( $input ) {

  global $post, $wp_query, $content_width;

  $global_layout = wen_business_get_option( 'global_layout' );
  $global_layout = apply_filters( 'wen_business_filter_theme_global_layout', $global_layout );

    // Check if single
  if ( $post  && is_singular() ) {
    $post_options = get_post_meta( $post->ID, 'theme_settings', true );
    if ( isset( $post_options['post_layout'] ) && ! empty( $post_options['post_layout'] ) ) {
      $global_layout = $post_options['post_layout'];
    }
  }
  switch ( $global_layout ) {

    case 'no-sidebar':
      $content_width = 1140;
      break;

    case 'three-columns':
    case 'three-columns-pcs':
    case 'three-columns-cps':
    case 'three-columns-psc':
    case 'no-sidebar-centered':
      $content_width = 555;
      break;

    case 'three-columns-pcs-equal':
    case 'three-columns-scp-equal':
      $content_width = 380;
      break;

    case 'left-sidebar':
    case 'right-sidebar':
      $content_width = 750;
      break;

    default:
      break;
  }

}
endif;

add_filter( 'template_redirect', 'wen_business_custom_content_width' );


if ( ! function_exists( 'wen_business_implement_front_page_widget_area' ) ) :

  /**
   * Implement front page widget area
   *
   * @since WEN Business 1.0
   *
   */
function wen_business_implement_front_page_widget_area(){

  if ( is_front_page() && is_active_sidebar( 'sidebar-front-page-widget-area' ) ) {
    // Sidebar active
    echo '<div id="sidebar-front-page-widget-area" class="widget-area">';
      dynamic_sidebar( 'sidebar-front-page-widget-area' );
    echo '</div><!-- #sidebar-front-page-widget-area -->';
  }

}

endif;

add_action( 'wen_business_action_front_page', 'wen_business_implement_front_page_widget_area' );



if ( ! function_exists( 'wen_business_add_author_bio_in_single' ) ) :

  /**
   * Display Author bio
   *
   * @since WEN Business 1.0
   *
   */
function wen_business_add_author_bio_in_single() {

  $author_bio_in_single = wen_business_get_option( 'author_bio_in_single' );
  if ( 1 != $author_bio_in_single ) {
    return;
  }
  get_template_part( 'template-parts/author-bio', 'single' );

}
endif;

add_action( 'wen_business_author_bio', 'wen_business_add_author_bio_in_single' );


if ( ! function_exists( 'wen_business_add_ie_fix_scripts' ) ) :

  /**
   * Add IE hack scripts.
   *
   * @since WEN Business 1.0
   *
   */
function wen_business_add_ie_fix_scripts(){

  ?>
  <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
  <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
      <script src="<?php echo get_template_directory_uri();?>/assets/js/html5shiv.js"></script>
      <script src="<?php echo get_template_directory_uri();?>/assets/js/respond.js"></script>
      <![endif]-->

      <?php

    }
    endif;
    add_action( 'wp_head', 'wen_business_add_ie_fix_scripts' );


    if ( ! function_exists( 'wen_business_featured_image_instruction' ) ) :

  /**
   * Message to show in the Featured Image Meta box.
   *
   * @since WEN Business 1.0
   *
   */
function wen_business_featured_image_instruction( $content, $post_id ) {

  if ( 'post' == get_post_type( $post_id ) ) {
    $content .= '<strong>' . __( 'Recommended Image Sizes', 'wen-business-pro' ) . ':</strong><br/>';
    $content .= __( 'Slider Image', 'wen-business-pro' ).' : 1600px X 440px';
  }

  return $content;

}

endif;
add_filter( 'admin_post_thumbnail_html', 'wen_business_featured_image_instruction', 10, 2 );


if( ! function_exists( 'wen_business_footer_goto_top' ) ) :

  /**
   * Go to top
   *
   * @since  WEN Business 1.0
   */
function wen_business_footer_goto_top(){

  $go_to_top = wen_business_get_option( 'go_to_top' );

  if ( 1 != $go_to_top ) {
    return;
  }

  $go_to_top_icon = wen_business_get_option( 'go_to_top_icon' );

  echo '<a href="#" class="scrollup" id="btn-scrollup"><i class="fa ' . esc_attr( $go_to_top_icon ) . '"></i></a>';

}

endif;

add_action( 'wen_business_action_after', 'wen_business_footer_goto_top', 20 );


if( ! function_exists( 'wen_business_get_comment_section' ) ) :

  /**
   * Implement comment section
   *
   * @since  WEN Business 1.0
   */
function wen_business_get_comment_section(){

  $comment_option = wen_business_get_option( 'comment_option' );

  switch ( $comment_option ) {
    case 'default':
      // If comments are open or we have at least one comment, load up the comment template
      if ( comments_open() || get_comments_number() ) :
        comments_template();
      endif;

      break;

    case 'disable-in-page':
      if ( ! is_page() ) {
        // If comments are open or we have at least one comment, load up the comment template
        if ( comments_open() || get_comments_number() ) :
          comments_template();
        endif;
      }
      break;

    case 'disabled':
      break;

    default:
      break;
  }


}

endif;

add_action( 'wen_business_action_comment', 'wen_business_get_comment_section', 10 );


if( ! function_exists( 'wen_business_comment_defaults' ) ) :

  /**
   * Customize default comment form
   *
   * @since  WEN Business 1.0
   */
  function wen_business_comment_defaults( $defaults ){

    $enable_comment_note = wen_business_get_option( 'enable_comment_note' );
    if ( true != $enable_comment_note) {
      $defaults['comment_notes_after'] = '';
    }

    // Comment form
    $defaults['comment_field'] = '<div class="row">
        <div class="col-sm-12">
          <textarea id="comment" name="comment" aria-required="true" cols="45" rows="8"  placeholder="'.__( 'Comment', 'wen-business-pro' ).'"></textarea>
        </div><!-- .col-sm-12 -->
      </div><!-- .row -->';
    return $defaults;

  }

endif;

add_filter( 'comment_form_defaults', 'wen_business_comment_defaults' );


if( ! function_exists( 'wen_business_comment_form_fields' ) ) :

  /**
   * Customize default comment form fields
   *
   * @since  WEN Business 1.0
   */
  function wen_business_comment_form_fields( $fields ){

    $enable_comment_website = wen_business_get_option( 'enable_comment_website' );

    $commenter = wp_get_current_commenter();
    $req = get_option( 'require_name_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );

    if (  true == $enable_comment_website ) {
      // Just like default
      $fields['author'] = '<div class="row"><div class="col-sm-4 comment-form-author">' .
          '<input id="author" name="author" type="text" placeholder="'.__( 'Name', 'wen-business-pro' ).( $req ? '*' : '' ) . '" value="' . esc_attr( $commenter['comment_author'] ) .
          '" size="30"' . $aria_req . ' /></div>';
      $fields['email'] = '<div class="col-sm-4 comment-form-email">' .
          '<input id="email" name="email" type="text" placeholder="'.__( 'Email', 'wen-business-pro' ).( $req ? '*' : '' ) . '" value="' . esc_attr(  $commenter['comment_author_email'] ) .
          '" size="30"' . $aria_req . ' /></div>';
      $fields['url'] = '<div class="col-sm-4 comment-form-url">' .
          '<input id="url" name="url" type="text" placeholder="'.__( 'Website', 'wen-business-pro' ) . '" value="' . esc_attr( $commenter['comment_author_url'] ) .
          '" size="30" /></div></div><!-- .row -->';
    }
    else{
      // no website field
      $fields['author'] = '<div class="row"><div class="col-sm-6 comment-form-author">' .
          '<input id="author" name="author" type="text" placeholder="'.__( 'Name', 'wen-business-pro' ).( $req ? '*' : '' ) . '" value="' . esc_attr( $commenter['comment_author'] ) .
          '" size="30"' . $aria_req . ' /></div>';
      $fields['email'] = '<div class="col-sm-6 comment-form-email">' .
          '<input id="email" name="email" type="text" placeholder="'.__( 'Email', 'wen-business-pro' ).( $req ? '*' : '' ) . '" value="' . esc_attr(  $commenter['comment_author_email'] ) .
          '" size="30"' . $aria_req . ' /></div></div><!-- .row -->';
      $fields['url'] = '';
    }

    return $fields;

  }

endif;

add_filter( 'comment_form_default_fields', 'wen_business_comment_form_fields' );


if( ! function_exists( 'wen_business_pre_comment_check' ) ) :

  /**
   * Check comment form
   *
   * @since  WEN Business 1.0
   */
  function wen_business_pre_comment_check(){

    $enable_minimum_characters_in_comment = wen_business_get_option( 'enable_minimum_characters_in_comment' );
    $minimum_characters_in_comment        = wen_business_get_option( 'minimum_characters_in_comment' );

    if ( true != $enable_minimum_characters_in_comment ) {
      return;
    }

    $comment_content      = ( isset($_POST['comment']) ) ? trim($_POST['comment']) : null;
    if ( strlen( $comment_content ) < $minimum_characters_in_comment ) {
      wp_die( 'Comment is too short.');
    }

  }

endif;


add_action( 'pre_comment_on_post', 'wen_business_pre_comment_check' );


if( ! function_exists( 'wen_business_display_sidebar_default_info' ) ) :

  /**
   * Display default sidebar info.
   *
   * @since  WEN Business 1.0
   */
  function wen_business_display_sidebar_default_info( $sidebar_args, $widget_args ){

    // Bail if user cannot edit theme
    if ( ! current_user_can( 'edit_theme_options' ) ) {
      return;
    }

    $sidebar_default_args = array(
      'id'   => 'sidebar-1',
      'name' => __( 'Primary Sidebar', 'wen-business-pro' ),
    );
    $sidebar_args = wp_parse_args( $sidebar_args, $sidebar_default_args );

    $widget_default_args = array(
      'before_title'  => '<h3 class="widget-title">',
      'after_title'   => '</h3>',
    );
    $widget_args = wp_parse_args( $widget_args, $widget_default_args );

    // Render text widget
    $widget = 'WP_Widget_Text';
    $text = sprintf( __( "Widgets of %s will be displayed here. To add widgets go to 'Appearance' -> 'Widgets'.", 'wen-business-pro' ), $sidebar_args['name'] );
    $instance = array(
      'title' => $sidebar_args['name'],
      'text'  => $text,
    );
    the_widget( $widget, $instance, $widget_args );

  }

endif;

add_action( 'wen_business_action_sidebar_default', 'wen_business_display_sidebar_default_info', 10, 2 );
