<?php

if( ! function_exists( 'wen_business_footer_navigation' ) ) :

  /**
   * Footer navigation
   *
   * @since  WEN Business 1.0
   */
  function wen_business_footer_navigation(){

    $footer_menu_content = wp_nav_menu( array(
      'theme_location' => 'footer' ,
      'container'      => 'div' ,
      'container_id'   => 'footer-navigation' ,
      'depth'          => 1 ,
      'fallback_cb'    => false ,
      'echo'           => false ,
    ) );
    if ( empty( $footer_menu_content ) ) {
      return;
    }
    echo '<div id="footer-nav">';
      echo '<div class="container">';
        echo $footer_menu_content;
      echo '</div><!-- .container -->';
    echo '</div><!-- #footer-nav -->';
    return;

  }

endif;

add_action( 'wen_business_action_before_footer', 'wen_business_footer_navigation', 5 );

if( ! function_exists( 'wen_business_footer_copyright' ) ) :

  /**
   * Footer copyright
   *
   * @since  WEN Business 1.0
   */
  function wen_business_footer_copyright(){

    // Check if footer is disabled
    $footer_status = apply_filters( 'wen_business_filter_footer_status', true );
    if ( true !== $footer_status) {
      return;
    }

    // Copyright
    $copyright_text = wen_business_get_option( 'copyright_text' );
    $copyright_text = apply_filters( 'wen_business_filter_copyright_text', $copyright_text );

    // Powered By
    $powered_by_text = wen_business_get_option( 'powered_by_text' );
    $powered_by_text = apply_filters( 'wen_business_filter_powered_by_text', $powered_by_text );

    // Centering
    $enable_centered_footer = wen_business_get_option( 'enable_centered_footer' );
    $extra_footer_class = '';
    if ( true == $enable_centered_footer ) {
      $extra_footer_class = 'centered-footer';
    }
    ?>
    <div class="row <?php echo $extra_footer_class; ?>">
      <div class="col-sm-6 copyright-column">
        <?php if ( ! empty( $copyright_text ) ): ?>
          <div class="copyright">
            <?php echo do_shortcode( $copyright_text ); ?>
          </div><!-- .copyright -->
        <?php endif ?>

      </div><!-- .col-sm-6 -->
      <div class="col-sm-6 powered-by-column">

          <div class="site-info">
            <?php echo do_shortcode( $powered_by_text ); ?>
          </div><!-- .site-info -->

      </div><!-- .col-sm-6 -->
    </div><!-- .row -->
    <?php

  }

endif;

add_action( 'wen_business_action_footer', 'wen_business_footer_copyright', 10 );


if( ! function_exists( 'wen_business_check_footer_status' ) ) :

  /**
   * Check Footer copyright
   *
   * @since  WEN Business 1.0
   */
  function wen_business_check_footer_status( $input ){

    // Copyright
    $copyright_text = wen_business_get_option( 'copyright_text' );
    $copyright_text = apply_filters( 'wen_business_filter_copyright_text', $copyright_text );

    // Powered By
    $powered_by_text = wen_business_get_option( 'powered_by_text' );
    $powered_by_text = apply_filters( 'wen_business_filter_powered_by_text', $powered_by_text );

    if ( empty( $copyright_text ) && empty( $powered_by_text ) ) {
      $input = false;
    }

    return $input;

  }

endif;

add_filter( 'wen_business_filter_footer_status', 'wen_business_check_footer_status' );
