<?php
if( ! function_exists( 'wen_business_site_branding' ) ) :

  /**
   * Site branding
   *
   * @since  WEN Business 1.0
   */
  function wen_business_site_branding(){


    $branding_class = array();
    $branding_class_text = '';

    // Show title
    $show_title = wen_business_get_option( 'show_title' );

    $move_tagline_below_title = wen_business_get_option( 'move_tagline_below_title' );
    if ( 1 == $move_tagline_below_title ) {
      $branding_class[] = 'tagline-below-title';
    }

    $move_logo_after_title = wen_business_get_option( 'move_logo_after_title' );
    if ( 1 == $move_logo_after_title ) {
      $branding_class[] = 'logo-after-title';
    }

    $show_tagline_separator = wen_business_get_option( 'show_tagline_separator' );
    if ( 1 == $show_tagline_separator ) {
      $branding_class[] = 'show-tagline-separator';
    }

    if ( ! empty( $branding_class ) ) {
      $branding_class_text .= implode(' ', $branding_class );
    }
    ?>
    <div class="site-branding <?php echo $branding_class_text; ?>">
    <?php if ( function_exists( 'the_custom_logo' ) ) : ?>
    	<div class="site-logo">
    	<?php the_custom_logo(); ?>
    	</div><!-- .site-logo -->
    <?php endif; ?>

      <div class="title-description-wrap">
        <?php if ( 1 == $show_title ):
          if ( is_front_page() && is_home() ) : ?>
            <h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>
          <?php else : ?>
            <p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
          <?php endif;
        endif; ?>

        <?php $show_tagline = wen_business_get_option( 'show_tagline' ); ?>
         <?php if ( 1 == $show_tagline ) : ?>
          <h2 class="site-description"><?php bloginfo( 'description' ); ?></h2>
         <?php endif ?>
      </div><!-- .title-description-wrap -->

    </div><!-- .site-branding -->

    <?php if ( true != wen_business_get_option( 'disable_primary_menu' )  ): ?>
      <div id="site-navigation" role="navigation">
          <?php
            $menu_class = array();
            if ( true == wen_business_get_option( 'disable_underline_in_primary_menu' ) ) {
              $menu_class[] = 'primary-disable-underline';
            }

            wp_nav_menu( array(
				'theme_location'  => 'primary',
				'container'       => 'nav',
				'container_class' => 'main-navigation',
				'menu_class'      => implode( ' ', $menu_class ),
				'fallback_cb'     => 'wen_business_primary_menu_fallback',
              )
            );
          ?>
      </div><!-- #site-navigation -->
    <?php endif ?>

    <?php

  }

endif;
add_action( 'wen_business_action_header', 'wen_business_site_branding' );


if( ! function_exists( 'wen_business_mobile_navigation' ) ) :

  /**
   * Primary navigation
   *
   * @since  WEN Business 1.0
   */
  function wen_business_mobile_navigation(){

    $disable_mobile_menu = wen_business_get_option( 'disable_mobile_menu' );
    if ( true == $disable_mobile_menu ) {
      return;
    }

    $mobile_menu = '';

    if ( has_nav_menu( 'mobile' ) ) {
      $mobile_menu = 'mobile';
    }

    if ( empty( $mobile_menu ) && has_nav_menu( 'primary' ) ) {
      $mobile_menu = 'primary';
    }

    if ( empty( $mobile_menu ) && has_nav_menu( 'secondary' ) ) {
      $mobile_menu = 'secondary';
    }

    if ( empty( $mobile_menu ) ) {
      return;
    }

    ?>
    <a href="#mob-menu" id="mobile-trigger"><i class="fa fa-bars"></i></a>
    <div style="display:none;">
      <div id="mob-menu">
          <?php
            wp_nav_menu( array(
              'theme_location'  => $mobile_menu,
              'container'       => '',
            ) );
          ?>
      </div><!-- #mob-menu -->
    </div>

    <?php

  }

endif;
add_action( 'wen_business_action_before', 'wen_business_mobile_navigation', 20 );


if( ! function_exists( 'wen_business_header_top_content' ) ) :

  /**
   * Header top content
   *
   * @since  WEN Business 1.0
   */
  function wen_business_header_top_content(){

    $social_in_header = wen_business_get_option( 'social_in_header' );
    $search_in_header = wen_business_get_option( 'search_in_header' );

    ?>

    <?php if ( ( 1 == $social_in_header && wen_business_is_social_menu_active() ) || 1 == $search_in_header ): ?>

      <div id="header-top-content">
        <div class="container">
          <div class="header-top">

              <div class="header-top-inner">
                <?php if ( 1 == $social_in_header ): ?>
                  <?php the_widget( 'WEN_Business_Social_Widget', array( 'icon_size' => 15 ) ); ?>
                <?php endif ?>
                <?php if ( 1 == $search_in_header ): ?>
                  <div id="header-search-form">
                    <?php get_search_form(); ?>
                  </div><!-- #header-search-form -->
                <?php endif ?>
              </div><!-- .header-top-inner -->

          </div><!-- .header-top -->
        </div><!-- .container -->
      </div><!-- #header-top-content -->

    <?php endif ?>


    <?php

  }

endif;
add_action( 'wen_business_action_before_header', 'wen_business_header_top_content', 5 );



if( ! function_exists( 'wen_business_add_secondary_navigation' ) ) :

  /**
   * Add secondary navigation.
   *
   * @since  WEN Business 1.0
   */
  function wen_business_add_secondary_navigation(){
    ?>
    <?php if ( true != wen_business_get_option( 'disable_secondary_menu' )  ): ?>
      <div id="secondary-navigation" role="navigation">
        <div class="container">

          <?php
            $menu_class = array( 'menu' );
            $menu_class[] = 'menu-align-' . esc_attr( wen_business_get_option( 'secondary_menu_alignment' ) );
            if ( true == wen_business_get_option( 'disable_underline_in_secondary_menu' ) ) {
              $menu_class[] = 'secondary-disable-underline';
            }
            wp_nav_menu( array(
              'theme_location'  => 'secondary',
              'container'       => 'nav',
              'container_class' => 'secondary-navigation',
              'menu_class'      => implode( ' ', $menu_class ),
              )
            );
          ?>
        </div><!-- .container -->
      </div><!-- #secondary-navigation -->
    <?php endif ?>

    <?php
  }
endif;

add_action( 'wen_business_action_after_header', 'wen_business_add_secondary_navigation', 20 );
